---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-BUTTON.ADS
--  Description : Root of GUI Widget Button Hierarchy
--
--  Copyright (C) 2003, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- Additions to hierarchy
--               GUI_Widget
--                   |
--                 Button
--                /      \
--         Text_Button  Picture_Button
--
-- Button adds action (for press)
-- Text_Button adds Text (label)
-- Picture_Button adds Picture -- name of GIF (without .GIF extension)
---------------------------------------------------------------
with mcc.Gui.Widget.Text_Entry;
with mcc.Gui.Image;
with mcc.Gui.Container;

package gui.Widget.Button is
   type Button is abstract new gui.Widget.GUI_Widget with record
      Action       : String_Pointer;
      Action_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- for novice mode, update actions when window name changes.
   procedure Update_Action
     (Widget     : in out Button;
      Old_Window : String;
      New_Window : String);

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Button);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Button);

   procedure Generate_Action_Context_Clause
     (Widget : in Button);

   procedure Generate_Widget_Creation
     (Widget      : in Button;
      Window_Name : in String);

   procedure Generate_Callback_Action
     (Widget : in Button);

   procedure Set_Properties (Widget : in out Button);

   procedure Apply_Properties (Widget : in out Button);

   procedure Check_Properties (Widget : in out Button; Ok : out Boolean);

   type Text_Button is new Button with record
      Text       : String_Pointer;
      Text_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Text_Button);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Text_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Text_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Text_Button);

   -- wbw 5/10/99
   procedure Generate_Action_Context_Clause
     (Widget : in Text_Button);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Text_Button;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Text_Button;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Text_Button);

   procedure Apply_Properties (Widget : in out Text_Button);
   procedure Check_Properties
     (Widget : in out Text_Button;
      Ok     : out Boolean);

   type Picture_Button is new Button with record
      Picture       : String_Pointer;
      Picture_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Image         : mcc.Gui.Image.External_Image;
      Tooltip       : String_Pointer;
      Tip_Entry     : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Picture_Button);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Picture_Button);

   -- wbw 6/6/99
   procedure Generate_Action_Context_Clause
     (Widget : in Picture_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Picture_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Picture_Button);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Picture_Button;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Picture_Button;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Picture_Button);

   procedure Apply_Properties (Widget : in out Picture_Button);
   procedure Check_Properties
     (Widget : in out Picture_Button;
      Ok     : out Boolean);

end Gui.Widget.Button;
