---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI_ENUM.ADS
--  Description : IO for GUI keywords
--
--  By: Martin Carlisle
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- Add something to this file every time you create a new widget
-- To create a new widget, you will then need to add something
-- to the gui-widget hierarchy.
---------------------------------------------------------------
-- Change log:
-- 09/20/99 (mcc) : added Separator
-- 02/16/99 (wbw) : added Scale
---------------------------------------------------------------

with Ada.Text_IO;
with gui.Widget;

package Gui_Enum is

   type Frame_T is (No_Frame, Frame);
   type Main_Win_T is (Main_Win, Sub_Win);

   type Keyword is (
      Menubar,
      Menu,
      Item,
      Separator,
      EndOf,
      Window,
      Widgets,
      TextButton,
      PictureButton,
      Label,
      TextEntry,
      CheckButton,
      RadioButton,
      Picture,
      Listbox,
      Scale,
      Progress,
      Dropdown,
      Textbox,
      Frame);
   subtype Widget_Keyword is Keyword range TextButton .. Keyword'Last;

   function Img (Item : Keyword) return String;

   ----------------------------------------------------------
   -- Allocate widget
   --
   -- allocate a widget of the given type and return a pointer
   -- to it.  Does not fill in any fields of the widget
   ----------------------------------------------------------
   function Allocate_Widget
     (Widget_Type : in Widget_Keyword)
      return        gui.Widget.Widget_Access;

end Gui_Enum;
