with mcc.gui.container.window;
with mcc.gui.widget.button.check;
with mcc.gui.widget.button.radio;
with mcc.gui.widget.button.text;
with mcc.gui.widget.button.picture;
with mcc.gui.widget.label;
with mcc.gui.widget.picture;
with mcc.gui.widget.text_entry;
with mcc.gui.widget.listbox;
with mcc.gui.widget.progress;
with ada.text_io;
with mcc.gui.colors;
with mcc.gui.image;
with mcc.gui.menu;
with mcc.gui.container.frame;


procedure test_everything is
   Window  : aliased mcc.gui.container.window.main_window;
   group1  : aliased mcc.gui.widget.button.radio.radio_group;
   radio1  : aliased mcc.gui.widget.button.radio.radio_button;
   radio2  : aliased mcc.gui.widget.button.radio.radio_button;
   radio3  : aliased mcc.gui.widget.button.radio.radio_button;
   label1  : aliased mcc.gui.widget.label.label;
   button1 : aliased mcc.gui.widget.button.text.text_button;
   check1  : aliased mcc.gui.widget.button.check.check_button;
   text1   : aliased mcc.gui.widget.text_entry.text_entry;
   list1   : aliased mcc.gui.widget.listbox.listbox;
   image1  : aliased mcc.gui.image.external_image;
   image2  : aliased mcc.gui.image.external_image;
   picture1: aliased mcc.gui.widget.picture.picture;
   pbutton1: aliased mcc.gui.widget.button.picture.picture_button;
   progress1: aliased mcc.gui.widget.progress.progress;
   window_menu : aliased mcc.gui.menu.window_menu;
   file_menu   : aliased mcc.gui.menu.submenu;
   new_choice  : aliased mcc.gui.menu.choice;
   delete_choice  : aliased mcc.gui.menu.choice;
   frame1  : aliased mcc.gui.container.frame.frame;
   frame_menu  : aliased mcc.gui.menu.window_menu;
   frame_file  : aliased mcc.gui.menu.submenu;
   frame_edit  : aliased mcc.gui.menu.submenu;
   frame_copy  : aliased mcc.gui.menu.choice;
   frame_new   : aliased mcc.gui.menu.choice;

   procedure Key_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Key_Event) is
   begin
      ada.text_io.put_line("key " &
         mcc.gui.key_action_type'image(event.action) &
         mcc.gui.key_type'image(event.key));
   end Key_Listener;

   procedure Mouse_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Mouse_Event) is
   begin
      ada.text_io.put_line(
         mcc.gui.mouse_action_type'image(event.action) & " " &
         mcc.gui.mouse_button'image(event.button) &
         natural'image(event.x) & natural'image(event.y));
   end Mouse_Listener;

   procedure button_pushed(
      obj : in out mcc.gui.widget.button.button'class) is
   begin
      ada.text_io.put_line("button pushed");
      ada.text_io.put_line(
         "list-- count:" &
         integer'image(mcc.gui.widget.listbox.count(list1))
         & " selected:" &
         integer'image(mcc.gui.widget.listbox.get_selected(list1)));
      mcc.gui.widget.listbox.delete_entry(list1,1,3);
      mcc.gui.widget.listbox.add_entry(list1,0,"adding1");
      mcc.gui.widget.listbox.add_entry(list1,0,"adding2");
      mcc.gui.widget.listbox.add_entry(list1,0,"adding3");
      ada.text_io.put_line("check:" & boolean'image(
         mcc.gui.widget.button.check.is_checked(check1)));
      mcc.gui.widget.button.check.unselect_check(check1);

      ada.text_io.put_line("entry:" &
         mcc.gui.widget.text_entry.get_text(text1));
      mcc.gui.widget.text_entry.set_text(text1,"bob\o\\o]}{[");
      mcc.gui.widget.text_entry.highlight(text1,1,3);
      ada.text_io.put_line("end of button pushed");
   end button_pushed;

   procedure resize_procedure(
      obj : in out mcc.gui.container.window.window'class;
      width : in integer;
      height :in integer) is
   begin
      if width /= 300 or else height /= 300 then
         ada.text_io.put_line(integer'image(width) &
            integer'image(height));
         mcc.gui.resize(mcc.gui.sized_object(obj),300,300);
      end if;
   end resize_procedure;

   procedure new_callback is
   begin
      ada.text_io.put_line("new menu choice selected");
   end new_callback;

   procedure menu_callback is
   begin
      ada.text_io.put_line("menu displayed");
   end menu_callback;
begin
   -- test window functions
   mcc.gui.container.window.create(window,
      100,100,300,300);
   mcc.gui.container.window.set_title(window,"Fr""ed");

   mcc.gui.container.window.hide(window);
   delay 1.0;
   mcc.gui.container.window.show(window);
   mcc.gui.container.window.set_resize_handler(window'unchecked_access,
      resize_procedure'unrestricted_access);
   mcc.gui.container.window.to_top(window);
   ada.text_io.put_line("window created");
   -- test label functions
   mcc.gui.widget.label.create(label1,
      window,28,20,103,28,mcc.gui.widget.label.right,"b\\o}b""]{is");
   mcc.gui.set_background_color(
      mcc.gui.sized_object(label1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   ada.text_io.put_line("past background");
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(label1),mcc.gui.colors.to_color("FF00FF"));
   mcc.gui.widget.label.set_text(
      label1,"Changed! bo\\o}b""]{is");
   ada.text_io.put_line("past foreground");

   -- test text button functions
   mcc.gui.widget.button.text.create(
      button1,window,19,264,71,23,"reset");
   mcc.gui.widget.button.set_push_callback(
      button1'unchecked_access,
      button_pushed'unrestricted_access);
   mcc.gui.widget.button.set_text(
      mcc.gui.widget.button.labeled_button(button1),"RESET!");
   mcc.gui.set_background_color(
      mcc.gui.sized_object(button1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(button1),mcc.gui.colors.to_color("FF00FF"));
   ada.text_io.put_line("past text button");

   -- test progress bar functions
   mcc.gui.widget.progress.create(
      progress1,window,100,264,71,23);
   mcc.gui.widget.progress.set_progress(
      progress1,0.5);
   mcc.gui.set_background_color(
      mcc.gui.sized_object(progress1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(progress1),mcc.gui.colors.to_color("FFFFFF"));
   ada.text_io.put_line("past progress bar");

--   -- radio button functions
   mcc.gui.widget.button.radio.create(
      radio1,window,25,226,62,12,"radio1");
   ada.text_io.put_line("past radio create 1");
   mcc.gui.widget.button.radio.add_to_group(
      group1,radio1'unchecked_access);
   mcc.gui.set_background_color(
      mcc.gui.sized_object(radio1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(radio1),mcc.gui.colors.to_color("FF00FF"));
   ada.text_io.put_line("past radio group 1");

   mcc.gui.widget.button.radio.create(
      radio2,window,99,228,62,12,"radio1");
   ada.text_io.put_line("past radio create 2");
   mcc.gui.widget.button.radio.add_to_group(
      group1,radio2'unchecked_access);
   ada.text_io.put_line("past radio group 2");

   mcc.gui.widget.button.radio.create(
      radio3,window,172,230,62,12,"radio1");
   mcc.gui.widget.button.radio.add_to_group(
      group1,radio3'unchecked_access);

   mcc.gui.widget.button.disable(
      mcc.gui.widget.button.button(radio3));
   mcc.gui.widget.button.enable(
      mcc.gui.widget.button.button(radio2));

   mcc.gui.widget.button.radio.select_radio(radio2);
   mcc.gui.widget.button.disable(mcc.gui.widget.button.button(
      mcc.gui.widget.button.radio.get_selected(group1).all));
   ada.text_io.put_line("past all radios");
   -- checkbox functions
   mcc.gui.widget.button.check.create(
      check1,window,54,124,108,19,"check");
   mcc.gui.set_background_color(
      mcc.gui.sized_object(check1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(check1),mcc.gui.colors.to_color("FF00FF"));
   mcc.gui.widget.button.check.select_check(check1);
   ada.text_io.put_line("past check");

   -- text entry functions
   mcc.gui.widget.text_entry.create(
      text1,window,65,61,88,34);
   mcc.gui.set_mouse_listener(text1'unchecked_access,
      mouse_listener'unrestricted_access);
   mcc.gui.set_key_listener(text1'unchecked_access,
      key_listener'unrestricted_access);
   mcc.gui.set_background_color(
      mcc.gui.sized_object(text1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(text1),mcc.gui.colors.to_color("FF00FF"));
   ada.text_io.put_line("past text entry");
--   -- listbox functions
   mcc.gui.widget.listbox.create(
      list1,window,181,109,86,76,true,true);
   ada.text_io.put_Line("past listbox create");
   mcc.gui.set_background_color(
      mcc.gui.sized_object(list1),mcc.gui.colors.named_color(
         mcc.gui.colors.blue));
   mcc.gui.widget.set_foreground_color(
      mcc.gui.widget.widget(list1),mcc.gui.colors.to_color("FF00FF"));
   ada.text_io.put_Line("past listbox colors");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"cleared?");
   ada.text_io.put_line("past 1st add");
   mcc.gui.widget.listbox.clear(list1);
   ada.text_io.put_line("past clear");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"add1");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"add2");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"add3");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"add4");
   mcc.gui.widget.listbox.add_entry(
      list1,0,"add5");
   mcc.gui.widget.listbox.select_item(
      list1,3);
   ada.text_io.put_line(
      "list-- count:" &
      integer'image(mcc.gui.widget.listbox.count(list1))
      & " selected:" &
      integer'image(mcc.gui.widget.listbox.get_selected(list1)));

--   -- test picture button
   mcc.gui.image.create(image1,"check_gif.gif");
   mcc.gui.image.create(image2,"compile_gif.gif");
   ada.text_io.put_line("images created");
   mcc.gui.widget.button.picture.create(pbutton1,window,
      172,14,34,30,mcc.gui.image.image(image1));
   ada.text_io.put_line("picture button created");
   mcc.gui.widget.picture.create(picture1,window,
      212,62,48,32,mcc.gui.image.image(image1));
   mcc.gui.widget.picture.set_image(picture1,image2);
   ada.text_io.put_line("picture created");

--   -- frame test
   mcc.gui.container.frame.create(frame1,window,5,148,170,70,1);

--   -- menu tests
--   mcc.gui.menu.create(window_menu,window);
--   mcc.gui.menu.add_submenu(file_menu,"File",1,window_menu);
--   mcc.gui.menu.add_choice(new_choice,file_menu,"New",
--      new_callback'unrestricted_access,1,"Ctrl+G");
--   mcc.gui.menu.disable(new_choice);
--   mcc.gui.menu.enable(new_choice);
--   mcc.gui.menu.delete(file_menu);
--   -- was testing menu_callback above, but that menu is deleted!!
--   mcc.gui.menu.add_submenu(file_menu,"File",1,window_menu,0,
--      menu_callback'unrestricted_access);
--   mcc.gui.menu.add_choice(delete_choice,file_menu,"Delete",
--      new_callback'unrestricted_access,1,"Del");
--   -- test no accelerator here
--   mcc.gui.menu.add_choice(new_choice,file_menu,"New",
--      new_callback'unrestricted_access,1,0,"");
--   mcc.gui.menu.delete(delete_choice);

--   mcc.gui.menu.create(frame_menu,frame1);
--   mcc.gui.menu.add_submenu(frame_file,"File",1,frame_menu);
--   mcc.gui.menu.add_choice(frame_new,frame_file,"New",
--      new_callback'unrestricted_access,1,0,"Ctrl+L");
--   mcc.gui.menu.disable(frame_new);
--   mcc.gui.menu.add_submenu(frame_edit,"Edit",1,frame_menu);
--   mcc.gui.menu.add_choice(Obj => frame_copy, To_Menu => frame_edit,
--      Text => "Copy", Underline => 1,
--      Action => new_callback'unrestricted_access,
--      Accelerator => "Ctrl+C");
--   mcc.gui.menu.delete(frame_file);

   ada.text_io.put_line("starting event loop");

   mcc.gui.container.window.event_loop;
end test_everything;
