-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;
with Gtk.Object;
with Gtk.Button;
with Gtk.Container;
with Gtk.Widget;
with mcc.Gui.Widget.Peer;
with peer.Image;          use peer.Image;
package body mcc.Gui.Widget.Button.Picture is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Picture_Button;
      Parent : in mcc.Gui.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural;
      Image  : in mcc.Gui.Image.Image'Class)
   is
      new_button : Gtk.Button.Gtk_Button;
   begin
      Obj.Push_Handler := null;

      Gtk.Button.Gtk_New (Button => new_button);

      --Have Object point to Button
      Obj.My_Peer := Gtk.Object.Gtk_Object (new_button);

      mcc.Gui.Widget.Peer.Setup
        (Obj    => Obj,
         Parent => Parent,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height);

      Initialize
        (Image  => Mcc_Gtk_Image_Record (mcc.Gui.Image.Get_Peer (Image).all),
         Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      Gtk.Button.Add
        (Container => Gtk.Button.Gtk_Button (Obj.My_Peer),
         Widget    =>
           Mcc_Gtk_Image_Record (mcc.Gui.Image.Get_Peer (Image).all).Pixmap);
   end Create;

   ---------------
   -- Set_Image --
   ---------------

   procedure Set_Image
     (Obj   : in out Picture_Button;
      Image : in mcc.Gui.Image.Image'Class)
   is
      Child_List : Gtk.Widget.Widget_List.Glist;
   begin

      Child_List :=
         Gtk.Container.Children
           (Container => Gtk.Container.Gtk_Container (Obj.My_Peer));
      Gtk.Button.Remove
        (Container => Gtk.Button.Gtk_Button (Obj.My_Peer),
         Widget    =>
            Gtk.Widget.Widget_List.Nth_Data
              (List => Child_List,
               N    => Glib.Guint (0)));
      Initialize
        (Image  => Mcc_Gtk_Image_Record (mcc.Gui.Image.Get_Peer (Image).all),
         Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      Gtk.Button.Add
        (Container => Gtk.Button.Gtk_Button (Obj.My_Peer),
         Widget    =>
           Mcc_Gtk_Image_Record (mcc.Gui.Image.Get_Peer (Image).all).Pixmap);
   end Set_Image;

end Mcc.Gui.Widget.Button.Picture;
