-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle
--           includes code by Jonathan Busch
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib.Object;
with Gtk.Container;
with Gtk.Widget;

with Glib; use Glib;

with System;

package body peer.Style is

   procedure Set_Style_Recursively
     (Widget : in Gtk.Widget.Gtk_Widget;
      Style  : in Gtk.Style.Gtk_Style)
   is

      Num_Child  : Glib.Guint;
      Child_List : Gtk.Widget.Widget_List.Glist;

   begin --Set_Style_Recursively
      Gtk.Widget.Set_Style (Widget => Widget, Style => Style);
      -- we should stop at a leaf!
      if not (Widget.all in Gtk.Container.Gtk_Container_Record'Class) then
         return;
      end if;
      Child_List :=
         Gtk.Container.Children
           (Container => Gtk.Container.Gtk_Container (Widget));

      Num_Child := Gtk.Widget.Widget_List.Length (List => Child_List);
      if Num_Child > 0 then
         for X in 1 .. Num_Child loop
            Set_Style_Recursively
              (Widget =>
                  Gtk.Widget.Widget_List.Nth_Data
                    (List => Child_List,
                     N    => Glib.Guint (X - 1)),
               Style  => Style);
         end loop;
      end if;

   end Set_Style_Recursively;

   procedure Set_Text_Recursively
     (Widget : in Gtk.Widget.Gtk_Widget;
      Text   : in String)
   is

      Num_Child  : Glib.Guint;
      Child_List : Gtk.Widget.Widget_List.Glist;
      procedure Internal (Label : in System.Address; Str : in String);
      pragma Import (C, Internal, "gtk_label_set_text");
   begin
      if Gtk.Widget.Get_Name (Widget) = "GtkLabel" then
         Internal (Glib.Object.Get_Object (Widget), Text & ASCII.NUL);
      end if;

      -- we should stop at a leaf!
      if not (Widget.all in Gtk.Container.Gtk_Container_Record'Class) then
         return;
      end if;
      Child_List :=
         Gtk.Container.Children
           (Container => Gtk.Container.Gtk_Container (Widget));

      Num_Child := Gtk.Widget.Widget_List.Length (List => Child_List);
      if Num_Child > 0 then
         for X in 1 .. Num_Child loop
            Set_Text_Recursively
              (Widget =>
                  Gtk.Widget.Widget_List.Nth_Data
                    (List => Child_List,
                     N    => Glib.Guint (X - 1)),
               Text   => Text);
         end loop;
      end if;

   end Set_Text_Recursively;
end Peer.Style;
