--README File for Program Distribution Accompanying
--"Software Construction and Data Structures with Ada 95"
--by Michael B. Feldman
--copyright 1996, Addison Wesley Publishing Company
--ISBN 0-201-88795-9

--Comments and questions to mfeldman@seas.gwu.edu

--This program distribution is intended mainly for the
--convenience of users of the above text. You may use the
--programs as you choose for general educational purposes,
--provided:

--(1) you must include this README file in any further
--    distribution;

--(2) if you modify any of the programs and distribute them
--    further, you may add your name and other identifying
--    info to the comment block at the top of the program,
--    but must otherwise leave the comment block unchanged.

--Keep in mind that these programs were published in a
--copyrighted text and should be treated accordingly.

generic

   type ElementType is private;

package Lists_Generic is
   ------------------------------------------------------------------------
   --| Generic ADT for one-way linked lists
   --| Author: Michael B. Feldman, The George Washington University
   --| Last Modified: January 1996
   ------------------------------------------------------------------------

   -- exported types

   type Position is private;
   --TYPE List IS LIMITED PRIVATE;
   -- this really should be limited, but then I wouldn't be able to
   -- put one of these inside a non-limited record.
   type List is private;

   -- exported exceptions

   OutOfSpace : exception;  -- raised if no space left for a new node
   PastEnd : exception;  -- raised if a Position is past the end
   PastBegin : exception;  -- raised if a Position is before the begin
   EmptyList : exception;

   -- basic constructors

   procedure Initialize (L : in out List);
   -- Pre:  none
   -- Post: L is initialized. If L contained nodes, these are deleted.

   procedure AddToFront (L : in out List; X : ElementType);
   procedure AddToRear (L : in out List; X : ElementType);
   -- Pre:  L and X are defined
   -- Post: a node containing X is inserted
   --   at the front or rear of L, respectively

   -- basic selectors

   function First (L : List) return Position;
   function Last (L : List) return Position;
   -- Pre:  L is defined
   -- Post: returns the position of the first or last node
   --   of L, respectively; return NULL if L is empty

   function Retrieve (L : in List; P : in Position) return ElementType;
   -- Pre:    L and P are defined; P designates a node in L
   -- Post:   returns the value of the element at position P
   -- Raises: EmptyList if L is empty
   --         PastBegin if P points before the beginning of L
   --         PastEnd   if P points beyond the end of L

   -- other constructors

   procedure Insert (L : in out List; X : ElementType; P : Position);
   -- Pre:  L, X, and P are defined; P designates a node in L
   -- Post: X is inserted into L at position P; equivalent to
   --   AddToRear if P is NULL

   procedure Replace (L : in out List; X : ElementType; P : Position);
   -- Pre:    L, X, and P are defined; P designates a node in L
   -- Post:   X replace the element in L at position P
   -- Raises: PastEnd if P is NULL

   procedure Delete (L : in out List; P : Position);
   -- Pre:    L and P are defined; P designates a node in L
   -- Post:   the node at position P of L is deleted
   -- Raises: EmptyList if L is empty
   --         PastBegin if P is NULL

   procedure Copy (To : in out List; From : in List);
   -- Pre:  From is defined
   -- Post: To is a list whose elements are the same as those
   --   of From, in the same order.

   -- iterator operations

   procedure GoAhead (L : List; P : in out Position);
   -- Pre:    L and P are defined; P designates a node in L
   -- Post:   P is advanced to designate the next node of L
   -- Raises: EmptyList if L is empty
   --         PastEnd   if P points beyond the end of L

   procedure GoBack (L : List; P : in out Position);
   -- Pre:    L and P are defined; P designates a node in L
   -- Post:   P is moved to designate the previous node of L
   -- Raises: EmptyList if L is empty
   --         PastBegin if P points beyond the end of L

   -- inquiry operators

   function IsEmpty (L : List) return Boolean;
   function IsFirst (L : List; P : Position) return Boolean;
   function IsLast (L : List; P : Position) return Boolean;
   function IsPastEnd (L : List; P : Position) return Boolean;
   function IsPastBegin (L : List; P : Position) return Boolean;
   -- Pre:    L and P are defined
   -- Post:   return True iff the condition is met; False otherwise

private

   type Node;
   type Position is access Node;

   type Node is record
      Info : ElementType;
      Link : Position;
   end record;

   type List is record
      Head : Position;
      Tail : Position;
   end record;

end Lists_Generic;
