---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  mcc-decode_common_line.adb
--  Description : Decodes the command line arguments supplied
--    on invoking the rapid main program.
--
--  Copyright (C) 2009, Oliver Kellogg <okellogg@users.soureforge.net>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Ada.Command_Line;
with Ada.Text_IO;
with mcc.Directory_Operations;

procedure mcc.Decode_Command_Line
            (Filename : out Ada.Strings.Unbounded.Unbounded_String;
             Interactive : out Boolean) is
   Argc : constant Natural := Ada.Command_Line.Argument_Count;
   Arg_Index : Positive := 1;
begin
   Interactive := True;
   Filename := Ada.Strings.Unbounded.Null_Unbounded_String;
   if Argc = 0 then
      return;
   end if;
   declare
      Arg : constant String := Ada.Command_Line.Argument (1);
   begin
      if Arg (1) = '-' then
         if Arg = "-ni" or else Arg = "--noninteractive" then
            if Argc < 2 then
               Ada.Text_IO.Put_Line
                 ("non-interactive mode requires filename");
               return;
            end if;
            Interactive := False;
            Arg_Index := 2;
         else
            Ada.Text_IO.Put_Line ("ignoring unknown switch " & Arg);
         end if;
      end if;
   end;
   declare
      Argument : constant String := Ada.Command_Line.Argument (Arg_Index);
      Has_Directory : Boolean := False;
      End_Directory : Natural;
      -- following will be filled in based on argument
      use Ada.Strings.Unbounded;
   begin
      for i in reverse Argument'Range loop
         if Argument (i) = mcc.Directory_Operations.Directory_Separator and
            not Has_Directory
         then
            Has_Directory := True;
            End_Directory := i;
         end if;
      end loop;

      if Has_Directory then
         Filename := To_Unbounded_String (Argument);
         mcc.Directory_Operations.Change_Dir
           (Argument (Argument'First .. End_Directory - 1));
      else
         Filename :=
            To_Unbounded_String
              (mcc.Directory_Operations.Get_Current_Dir & Argument);
      end if;
   end;
end mcc.Decode_Command_Line;

