/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.element;

import java.io.InputStream;
import java.util.logging.LogManager;
import junit.framework.TestCase;
import org.x4o.xml.element.DefaultElementObjectPropertyValue;
import org.x4o.xml.element.ElementObjectPropertyValueException;
import org.x4o.xml.test.models.TestObjectChild;

public class DefaultElementObjectPropertyValueTest
extends TestCase {
    DefaultElementObjectPropertyValue helper = new DefaultElementObjectPropertyValue();

    public void setUp() throws Exception {
        InputStream loggingProperties = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/logging.properties");
        LogManager.getLogManager().readConfiguration(loggingProperties);
        loggingProperties.close();
    }

    public void testNullValue() throws Exception {
        TestObjectChild obj = new TestObjectChild();
        obj.setName("test");
        DefaultElementObjectPropertyValueTest.assertEquals((String)"test", (String)obj.getName());
        DefaultElementObjectPropertyValueTest.assertEquals((Object)"test", (Object)this.helper.getProperty((Object)obj, "name"));
        this.helper.setProperty((Object)obj, "name", null);
        DefaultElementObjectPropertyValueTest.assertEquals(null, (String)obj.getName());
        DefaultElementObjectPropertyValueTest.assertEquals(null, (Object)this.helper.getProperty((Object)obj, "name"));
    }

    public void testIntegerValue() throws Exception {
        TestObjectChild obj = new TestObjectChild();
        this.helper.setProperty((Object)obj, "price", (Object)666);
        DefaultElementObjectPropertyValueTest.assertEquals((Object)666, (Object)this.helper.getProperty((Object)obj, "price"));
    }

    public void testException() throws Exception {
        TestObjectChild obj = new TestObjectChild();
        this.helper.setProperty((Object)obj, "price", (Object)666);
        boolean error = false;
        try {
            this.helper.getProperty((Object)obj, "price2");
        }
        catch (ElementObjectPropertyValueException not) {
            error = true;
        }
        DefaultElementObjectPropertyValueTest.assertEquals((boolean)true, (boolean)error);
    }
}

