/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.io.X4OReaderContext;
import org.x4o.xml.io.X4OWriter;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestBean;
import org.x4o.xml.test.models.TestObjectRoot;

public class X4OReaderTest
extends TestCase {
    private File copyResourceToTempFile() throws IOException {
        File tempFile = File.createTempFile("test-resource", ".xml");
        tempFile.deleteOnExit();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        try {
            writer.writeFile(reader.readResource("tests/attributes/test-bean.xml"), tempFile);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadInputStream() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReaderContext reader = driver.createReaderContext();
        File xmlFile = this.copyResourceToTempFile();
        URL basePath = new File(xmlFile.getAbsolutePath()).toURI().toURL();
        FileInputStream inputStream = new FileInputStream(xmlFile);
        TestObjectRoot root = null;
        try {
            root = (TestObjectRoot)reader.read((InputStream)inputStream, xmlFile.getAbsolutePath(), basePath);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        X4OReaderTest.assertNotNull((Object)root);
        X4OReaderTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderTest.assertNotNull((Object)bean);
    }

    public void testReadResource() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/attributes/test-bean.xml");
        X4OReaderTest.assertNotNull((Object)root);
    }

    public void testReadResourceNull() throws Exception {
        Exception e = null;
        try {
            TestDriver driver = TestDriver.getInstance();
            X4OReader reader = driver.createReader();
            reader.readResource(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("resourceName"));
    }

    public void testReadString() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        TestObjectRoot root = (TestObjectRoot)reader.readString("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root:root xmlns:root=\"http://test.x4o.org/xml/ns/test-root\" xmlns=\"http://test.x4o.org/xml/ns/test-lang\"><testBean privateIntegerTypeField=\"987654321\"/></root:root>");
        X4OReaderTest.assertNotNull((Object)root);
        X4OReaderTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderTest.assertNotNull((Object)bean);
        X4OReaderTest.assertEquals((String)"987654321", (String)("" + bean.getPrivateIntegerTypeField()));
    }

    public void testReadStringNull() throws Exception {
        Exception e = null;
        try {
            TestDriver driver = TestDriver.getInstance();
            X4OReader reader = driver.createReader();
            reader.readString(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("string"));
    }

    public void testReadUrl() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        URL xmlUrl = Thread.currentThread().getContextClassLoader().getResource("tests/attributes/test-bean.xml");
        TestObjectRoot root = (TestObjectRoot)reader.readUrl(xmlUrl);
        X4OReaderTest.assertNotNull((Object)root);
        X4OReaderTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderTest.assertNotNull((Object)bean);
    }

    public void testReadUrlNull() throws Exception {
        Exception e = null;
        try {
            TestDriver driver = TestDriver.getInstance();
            X4OReader reader = driver.createReader();
            reader.readUrl(null);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("url"));
    }

    public void testReadFileName() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        File xmlFile = this.copyResourceToTempFile();
        TestObjectRoot root = (TestObjectRoot)reader.readFile(xmlFile.getAbsolutePath());
        X4OReaderTest.assertNotNull((Object)root);
        X4OReaderTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderTest.assertNotNull((Object)bean);
    }

    public void testReadFileNameNull() throws Exception {
        Exception e = null;
        try {
            TestDriver driver = TestDriver.getInstance();
            X4OReader reader = driver.createReader();
            String nullFileName = null;
            reader.readFile(nullFileName);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("fileName"));
    }

    public void testReadFile() throws Exception {
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        File xmlFile = this.copyResourceToTempFile();
        TestObjectRoot root = (TestObjectRoot)reader.readFile(xmlFile);
        X4OReaderTest.assertNotNull((Object)root);
        X4OReaderTest.assertTrue((root.getTestBeans().size() > 0 ? 1 : 0) != 0);
        TestBean bean = root.getTestBeans().get(0);
        X4OReaderTest.assertNotNull((Object)bean);
    }

    public void testReadFileNull() throws Exception {
        Exception e = null;
        try {
            TestDriver driver = TestDriver.getInstance();
            X4OReader reader = driver.createReader();
            File nullFile = null;
            reader.readFile(nullFile);
        }
        catch (Exception catchE) {
            e = catchE;
        }
        X4OReaderTest.assertNotNull((String)"No exception", (Object)e);
        X4OReaderTest.assertEquals((String)"Wrong exception class", NullPointerException.class, e.getClass());
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("null"));
        X4OReaderTest.assertTrue((String)"Wrong exception message", (boolean)e.getMessage().contains("file"));
    }
}

