/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.x4o.xml.eld.doc.EldDocWriterElementClass;
import org.x4o.xml.eld.doc.EldDocWriterLanguage;
import org.x4o.xml.eld.doc.EldDocXTreePageWriter;
import org.x4o.xml.eld.doc.api.ApiDocContentWriter;
import org.x4o.xml.eld.doc.api.ApiDocNodeWriterBean;
import org.x4o.xml.eld.doc.api.ApiDocNodeWriterMethod;
import org.x4o.xml.eld.doc.api.ApiDocWriter;
import org.x4o.xml.eld.doc.api.DefaultPageWriterHelp;
import org.x4o.xml.eld.doc.api.DefaultPageWriterIndexAll;
import org.x4o.xml.eld.doc.api.DefaultPageWriterTree;
import org.x4o.xml.eld.doc.api.dom.ApiDoc;
import org.x4o.xml.eld.doc.api.dom.ApiDocConcept;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeBody;
import org.x4o.xml.eld.doc.api.dom.ApiDocWriteEvent;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementConfigurator;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EldDocWriter {
    private X4OLanguageContext context = null;
    private static final String[] C_CONTEXT = new String[]{"language", "Overview", "All language modules.", "The loaded language modules.."};
    private static final String[] C_MODULE = new String[]{"module", "Module", "The Language Modules.", "The language is build by the modules and provides the namespaces."};
    private static final String[] C_NAMESPACE = new String[]{"namespace", "Namespace", "The Language Namespace.", "The language namespace holds all the xml elements."};
    private static final String[] C_ELEMENT = new String[]{"element", "Element", "The Language Element.", "The xml language element description."};

    public EldDocWriter(X4OLanguageContext context) {
        this.context = context;
    }

    public void writeDoc(File basePath) throws ElementException {
        try {
            ApiDocWriter writer = new ApiDocWriter();
            ApiDoc doc = this.buildLanguageDoc();
            doc.checkModel();
            writer.write(doc, basePath);
        }
        catch (SAXException e) {
            throw new ElementException((Exception)e);
        }
        catch (IOException e) {
            throw new ElementException((Exception)e);
        }
    }

    private ApiDoc buildLanguageDoc() {
        ApiDoc doc = new ApiDoc();
        doc.setName("X4O ELD DOC");
        doc.setDescription("X4O Meta Language Description");
        doc.setDocAbout(this.createLanguageAbout());
        doc.setDocCopyright(this.createLanguageCopyright());
        doc.addDocKeywordAll(this.createLanguageKeywords());
        doc.setFrameNavPrintParent(true);
        doc.setFrameNavPrintParentId(true);
        doc.setFrameNavConceptClass(ElementClass.class);
        ApiDocNodeWriterBean.addAnnotatedNodeContentWriters(doc, new EldDocWriterLanguage());
        ApiDocNodeWriterBean.addAnnotatedNodeContentWriters(doc, new EldDocWriterElementClass());
        ApiDocNodeWriterBean.addAnnotatedNodeContentWriters(doc, this);
        ApiDocConcept adc1 = doc.addConcept(new ApiDocConcept(null, C_CONTEXT, X4OLanguageContext.class, new Class[0]));
        ApiDocConcept adc2 = doc.addConcept(new ApiDocConcept(adc1, C_MODULE, X4OLanguageModule.class, ElementAttributeHandler.class, ElementConfigurator.class, ElementInterface.class, ElementBindingHandler.class));
        ApiDocConcept adc3 = doc.addConcept(new ApiDocConcept(adc2, C_NAMESPACE, ElementNamespaceContext.class, new Class[0]));
        doc.addConcept(new ApiDocConcept(adc3, C_ELEMENT, ElementClass.class, new Class[0]));
        doc.addDocPage(EldDocXTreePageWriter.createDocPage());
        doc.addDocPage(DefaultPageWriterTree.createDocPage());
        doc.addDocPage(DefaultPageWriterIndexAll.createDocPage());
        doc.addDocPage(DefaultPageWriterHelp.createDocPage());
        ApiDocNode rootNode = new ApiDocNode(this.context, "language", "Language", "The X4O Language");
        doc.setRootNode(rootNode);
        for (X4OLanguageModule mod : this.context.getLanguage().getLanguageModules()) {
            ApiDocNode modNode = rootNode.addNode(this.createNodeLanguageModule(mod));
            for (ElementBindingHandler bind : mod.getElementBindingHandlers()) {
                modNode.addNode(this.createNodeElementBindingHandler(bind));
            }
            for (ElementAttributeHandler attr : mod.getElementAttributeHandlers()) {
                modNode.addNode(this.createNodeElementAttributeHandler(attr));
            }
            for (ElementConfigurator conf : mod.getElementConfiguratorGlobals()) {
                modNode.addNode(this.createNodeElementConfigurator(conf));
            }
            for (ElementInterface iface : mod.getElementInterfaces()) {
                ApiDocNode ifaceNode = modNode.addNode(this.createNodeElementInterface(iface));
                for (ElementBindingHandler bind : iface.getElementBindingHandlers()) {
                    ifaceNode.addNode(this.createNodeElementBindingHandler(bind));
                }
                for (ElementConfigurator conf : iface.getElementConfigurators()) {
                    ifaceNode.addNode(this.createNodeElementConfigurator(conf));
                }
            }
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                ApiDocNode nsNode = modNode.addNode(this.createNodeElementNamespaceContext(ns));
                for (ElementClass ec : ns.getElementClasses()) {
                    ApiDocNode ecNode = nsNode.addNode(this.createNodeElementClass(ec));
                    for (ElementConfigurator conf : ec.getElementConfigurators()) {
                        ecNode.addNode(this.createNodeElementConfigurator(conf));
                    }
                }
            }
        }
        return doc;
    }

    private ApiDocNode createNodeElementBindingHandler(ElementBindingHandler bind) {
        return new ApiDocNode(bind, bind.getId(), bind.getId(), bind.getDescription());
    }

    private ApiDocNode createNodeElementAttributeHandler(ElementAttributeHandler attr) {
        return new ApiDocNode(attr, attr.getId(), attr.getId(), attr.getDescription());
    }

    private ApiDocNode createNodeElementConfigurator(ElementConfigurator conf) {
        return new ApiDocNode(conf, conf.getId(), conf.getId(), conf.getDescription());
    }

    private ApiDocNode createNodeLanguageModule(X4OLanguageModule mod) {
        return new ApiDocNode(mod, mod.getId(), mod.getId(), mod.getDescription());
    }

    private ApiDocNode createNodeElementInterface(ElementInterface iface) {
        return new ApiDocNode(iface, iface.getId(), iface.getId(), iface.getDescription());
    }

    private ApiDocNode createNodeElementNamespaceContext(ElementNamespaceContext ns) {
        return new ApiDocNode(ns, ns.getId(), ns.getUri(), ns.getDescription());
    }

    private ApiDocNode createNodeElementClass(ElementClass ec) {
        return new ApiDocNode(ec, ec.getId(), ec.getId(), ec.getDescription());
    }

    private String createLanguageAbout() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("XML X4O Language\n");
        buf.append(this.context.getLanguage().getLanguageName().toUpperCase());
        buf.append("&trade;&nbsp;");
        buf.append(this.context.getLanguage().getLanguageVersion());
        return buf.toString();
    }

    private String createLanguageCopyright() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer buf = new StringBuffer(100);
        buf.append("Copyright&nbsp;&#x00a9;&nbsp;");
        buf.append(calendar.get(1));
        buf.append("&nbsp;");
        buf.append(this.context.getLanguage().getLanguageName().toUpperCase());
        buf.append("&nbsp;");
        buf.append("All Rights Reserved.");
        return buf.toString();
    }

    private List<String> createLanguageKeywords() {
        ArrayList<String> keywords = new ArrayList<String>(10);
        keywords.add(this.context.getLanguage().getLanguageName());
        keywords.add("x4o");
        keywords.add("xml");
        keywords.add("language");
        keywords.add("documentation");
        return keywords;
    }

    private void printBeanProperties(ApiDocContentWriter writer, Object bean) throws SAXException {
        writer.docTableStart("Bean Properties", "Bean properties overview.");
        writer.docTableHeader("Name", "Value");
        for (Method m : bean.getClass().getMethods()) {
            if (!m.getName().startsWith("get")) continue;
            String n = m.getName().substring(3);
            if (m.getParameterTypes().length != 0 || n.length() < 2) continue;
            n = n.substring(0, 1).toLowerCase() + n.substring(1, n.length());
            Object value = null;
            try {
                value = m.invoke(bean, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            writer.docTableRow(n, this.printValue(value));
        }
        writer.docTableEnd();
    }

    private String printValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Class) {
            return "class " + ((Class)value).getName();
        }
        if (value instanceof List) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("[L: ");
            List l = (List)value;
            if (l.isEmpty()) {
                buf.append("Empty");
            }
            for (Object o : l) {
                buf.append("" + o);
                buf.append(" ");
            }
            buf.append("]");
            return buf.toString();
        }
        if (value instanceof Object[]) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("[A: ");
            Object[] l = (Object[])value;
            if (l.length == 0) {
                buf.append("Empty");
            }
            for (Object o : l) {
                buf.append("" + o);
                buf.append(" ");
            }
            buf.append("]");
            return buf.toString();
        }
        return value.toString();
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.SUMMARY, targetClasses={ElementBindingHandler.class})
    public void writeElementBindingHandlerBeanProperties(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        this.printBeanProperties(event.getWriter(), event.getEvent().getUserData());
    }

    @ApiDocNodeWriterMethod(nodeBody=ApiDocNodeBody.SUMMARY, targetClasses={ElementConfigurator.class})
    public void writeElementConfiguratorBeanProperties(ApiDocWriteEvent<ApiDocNode> event) throws SAXException {
        this.printBeanProperties(event.getWriter(), event.getEvent().getUserData());
    }
}

