* $$ JOB JNM=HOBLAPID,DISP=D,CLASS=C
* $$ LST DISP=D,CLASS=Q
* $$ PUN DISP=I,DEST=*,PRI=9,CLASS=C
// JOB HOBLAPID    CICS TRANSLATE
// ASSGN SYSIPT,SYSRDR
// LIBDEF *,SEARCH=(PRD2.SCEEBASE,PRD1.BASE)
// EXEC IESINSRT
$ $$ LST DISP=D,CLASS=F,DEST=(,AFTPCC)
// JOB HOBLAPID    ASSEMBLE PROGRAM SOURCE
// LIBDEF *,SEARCH=(PRD2.SCEEBASE,PRD1.BASE)
// LIBDEF SOURCE,SEARCH=(PRD1.BASE,PRD1.MACLIB)
// LIBDEF PHASE,SEARCH=(PRD1.BASE,PRD2.SCEEBASE)
// OPTION ERRS,SXREF,SYM,CATAL,NODECK
   PHASE HOBLAPID,*
   INCLUDE DFHEAI
// EXEC ASMA90,SIZE=(ASMA90,64K),PARM='EXIT(LIBEXIT(EDECKXIT)),SIZE(MAXC
               -200K,ABOVE)'
* $$ END
// OPTION ERRS,SXREF,SYM,LISTX,DECK
// EXEC DFHEAP1$,SIZE=512K
*ASM XOPTS(CICS)
*ASM XOPTS(NOEPILOG)
*ASM XOPTS(EDF,SP)
         PRINT GEN
* --------------------------------------------------------------------*
*                                                                     *
*  HOBLAPID: Read or write VSE librarian members in a VSE Library     *
*            based on the COMMAREA passed.                            *
*                                                                     *
*            The COMMAREA includes the following parameters:          *
*                READ/WRITE   CL8                                     *
*                LIBRARY      CL8                                     *
*                SUBLIBRARY   CL8                                     *
*                MEMBER NAME  CL8                                     *
*                MEMBER TYPE  CL8                                     *
*                TS QUEUE     CL8                                     *
*                                                                     *
*            The member in the library/sublibrary indicated is read   *
*            or written as determined in the first parameter.  The    *
*            data is read from/written to the TS Queue.               *
*                                                                     *
*            This program is inspired from code originally written    *
*            by David Wakser of Ibfocrossing.                         *
*                                                                     *
*            Original release: 12/02/2005 - RKS.                      *
*                        V1.1: 03/08/2007 - RKS                       *
*            Added library/sublibrary/member name, ts queue options.  *
*                                                                     *
*             Important: this must run with key CICS - not USER!      *
*                                                                     *
* --------------------------------------------------------------------*
DFHEISTG DSECT                                                           0000706
LBRSAVSC DC    F'0'                     Severity code from Reg 15
LBRSAVRC DC    F'0'                     Reason code from Reg 0
* --------------------------------------------------------------------*
*        SAVE AREA DECLARATIONS                                       *
* --------------------------------------------------------------------*
LBRGVISA DC    F'0'                     GETVIS LDCB ADDRESS
LBRGVISL DC    F'0'                     GETVIS LDCB LENGTH
LBRSAVIL DC    F'0'                     SAVE DIRINF LENGTH
LEN1     DC    F'0'                     Temporary length field
* --------------------------------------------------------------------*
*        WORKFIELDS                                                   *
* --------------------------------------------------------------------*
MEMBERIO DS    CL80                     MEMBER IO BUFFER
TSDATA   DS    CL80                    TS QUEUE IO AREA
CICSRESP DC    F'0'                    EXEC CICS RESPONSE CODE
LBRRETCD DC    F'0'                     SAVED RETURN CODE (REG 15)
LBRFEDBK DC    F'0'                     WORK AREA FOR FEEDBACK CODE
LBRRCPAK DC    D'00'                    CVD area
MEMNAME  DS    CL8'        '
MEMTYPE  DS    CL8'        '           MEMBER TYPE COMES FROM APPLID
COMMAREA DSECT
CACMD    DS    CL8                     COMMAREA COMMAND
CALNAME  DS    CL8                     COMMAREA LIBRARY NAME
CASNAME  DS    CL8                     COMMAREA SUBLIBRARY NAME
CAMNAME  DS    CL8                     COMMAREA MEMBER NAME
CAMTYPE  DS    CL8                     COMMAREA MEMBER TYPE
CATSQUE  DS    CL8                     COMMAREA TEMP STORAGE QUEUE
         USING COMMAREA,R9             ADDRESSABILITY
* --------------------------------------------------------------------*
*  BEGIN PROGRAM CODE
* --------------------------------------------------------------------*
HOBLAPID AMODE 24
HOBLAPID RMODE 24
HOBLAPID DFHEIENT CODEREG=(R8),DATAREG=(R10),EIBREG=(R11)
*        USING CONSTS,R10              ADDRESSABILITY
         L     R9,DFHEICAP             SET UP COMMAREA
*        LTORG
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*        Get LDCB map and get length of area needed for LDCB          *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
         LIBRDCB FUNC=MAP
         LIBRM  SHOWCB,CB=LDCB,CBLEN=LEN1  Get length into LEN1
         L      R4,LEN1                Save in R4
         GETVIS ADDRESS=(5),LENGTH=(4) GET STORAGE OF THE CORRECT SIZE
* --------------------------------------------------------------------*
*                 GENERATE LDCB                                       *
* --------------------------------------------------------------------*
         LIBRDCB FUNC=GEN,                                             *
               AREA=(5)
* --------------------------------------------------------------------*
*        SET MEMBER TYPE AND CHECK PASSED FUNCTION                    *
* --------------------------------------------------------------------*
         CLC   CACMD,=C'READ    '      CHECK FOR READ   OPTION
         BE    READMEM                 GO PROCESS
         CLC   CACMD,=C'WRITE   '      CHECK FOR WRITE  OPTION
         BE    WRITEMEM                GO PROCESS
* INVALID OPTION, JUST GO BACK.
         B     GOBACK                  ...FOR NOW
* --------------------------------------------------------------------*
* READ THE MEMBER INDICATED INTO THE TS QUEUE                         *
* --------------------------------------------------------------------*
READMEM  EQU *
* --------------------------------------------------------------------*
*        INVOKE STATE MEMBER SERVICE                                  *
* --------------------------------------------------------------------*
         MVC   LBRFUNC,=C'STATE '      MOVE LIBR FUNCTION TO MESSAGE
         LIBRM STATE,                  CHECK MEMBER EXISTENCE          *
               ENTITY=MEMBER,                                          *
               LDCB=(5),                                               *
               LIB=CALNAME,                                            *
               SUBLIB=CASNAME,                                         *
               MEMBER=CAMNAME,                                         *
               TYPE=CAMTYPE,                                           *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         ST    R1,LBRSAVIL             SAVE R1
         CLI   LBRRETCD+3,0            CHECK IT FOR ZERO
         BNE   LIBRERR                 ERROR DURING STATE PROCESSING
* --------------------------------------------------------------------*
* RC=0 FROM STATE, OPEN THE MEMBER
* --------------------------------------------------------------------*
         MVC   LBRFUNC,=C'OPENI '      MOVE LIBR FUNCTION TO MESSAGE
         LIBRM OPEN,                                                   *
               LDCB=(5),                                               *
               TYPEFLE=INPUT,                                          *
               BUFFER=MEMBERIO,                                        *
               BUFSIZE=80,                                             *
               RECFM=F,                                                *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         CLI   LBRRETCD+3,0            CHECK IT FOR ZERO
         BNE   LIBRERR                 ERROR DURING OPEN PROCESSING
* --------------------------------------------------------------------*
* RC=0 FROM STATE, LOAD MEMBER INTO TS
* --------------------------------------------------------------------*
         MVC   LBRFUNC,=C'GET   '      MOVE LIBR FUNCTION TO MESSAGE
GETLOOP  LIBRM GET,                    GET MEMBER CONTENTS             *
               LDCB=(5),                                               *
               UNITS=1,                                                *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         CLI   LBRRETCD+3,4            CHECK FOR GREATER THAN 4
         BH    LIBRERR                 ERROR DURING GET PROCESSING
         EXEC  CICS WRITEQ TS QUEUE(CATSQUE) FROM(MEMBERIO)            *
              LENGTH(MEMIOLEN)
         CLI   LBRRETCD+3,4            RC=4 MEANS END OF FILE
         BE    CLOSE
         B     GETLOOP                 GET THE NEXT RECORD
* --------------------------------------------------------------------*
* Write the data from the TS queue into the member indicated.         *
* --------------------------------------------------------------------*
WRITEMEM EQU *
* --------------------------------------------------------------------*
* Open the output member
* --------------------------------------------------------------------*
         MVC   LBRFUNC,=C'OPENO '      MOVE LIBR FUNCTION TO MESSAGE
         LIBRM OPEN,                                                   *
               LDCB=(5),                                               *
               TYPEFLE=(OUTPUT,REPLACE),                               *
               LIB=CALNAME,                                            *
               SUBLIB=CASNAME,                                         *
               MEMBER=CAMNAME,                                         *
               TYPE=CAMTYPE,                                           *
               BUFFER=MEMBERIO,                                        *
               BUFSIZE=80,                                             *
               RECFM=F,                                                *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         CLI   LBRRETCD+3,0            CHECK IT FOR ZERO
         BNE   LIBRERR                 ERROR DURING OPEN PROCESSING
*        EXEC  CICS WRITEQ TS QUEUE(HOBOUT) FROM(MSG1)               *
*             LENGTH(M1LEN)
         MVI   MEMBERIO,C' '
         MVC   MEMBERIO+1(79),MEMBERIO
* --------------------------------------------------------------------*
* RC=0 FROM OPEN, GET DATA FROM QUEUE AND WRITE IT OUT
* --------------------------------------------------------------------*
PUTLOOP  MVC   CICSFUNC,=C'READQ '
         EXEC  CICS READQ TS QUEUE(CATSQUE) INTO(TSDATA) NEXT          *
              LENGTH(HOBCILEN) RESP(CICSRESP)
         CLC   CICSRESP,DFHRESP(ITEMERR)
         BE    CLOSE                   END OF MEMBER, CLOSE IT
         CLC   CICSRESP,DFHRESP(NORMAL)
         BE    LIBRPUT                 NORMAL RESPONSE, CONTINUE
         B     CICSERR                 CICS READQ ERROR
LIBRPUT  EQU   *                       MOVE LIBR FUNCTION TO MESSAGE
         MVC   MEMBERIO,TSDATA         MOVE DATA FROM TS QUEUE
         MVC   LBRFUNC,=C'PUT   '      MOVE LIBR FUNCTION TO MESSAGE
         LIBRM PUT,                    GET MEMBER CONTENTS             *
               LDCB=(5),                                               *
               UNITS=1,                                                *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         CLI   LBRRETCD+3,0            CHECK FOR GREATER THAN 0
         BH    LIBRERR                 ERROR DURING PUT PROCESSING
*        EXEC  CICS WRITEQ TS QUEUE(HOBOUT) FROM(MSG2)               *
*             LENGTH(M2LEN)
         B     PUTLOOP
* --------------------------------------------------------------------*
*        GENERIC CLOSE                                                *
* --------------------------------------------------------------------*
CLOSE    MVC   LBRFUNC,=C'CLOSE '      MOVE LIBR FUNCTION TO MESSAGE
         LIBRM CLOSE,                  CLOSE MEMBER                    *
               LDCB=(5),                                               *
               EROPT=RET
         ST    R15,LBRRETCD            SAVE RETURN CODE
         ST    R0,LBRFEDBK             SAVE FEEDBACK CODE
         CLI   LBRRETCD+3,0            CHECK FOR GREATER THAN 0
         BH    LIBRERR                 ERROR DURING PUT PROCESSING
         B     FREEIT                  DONE...
* --------------------------------------------------------------------*
* HANDLE LIBRARIAN ACCESS ERROR
* --------------------------------------------------------------------*
LIBRERR  EQU   *
         CLI   LBRRETCD+3,8            CHECK IT FOR 8
         BE    NOTFOUND                MEMBER NOT FOUND
         L     R15,LBRRETCD            RESTORE RETURN CODE
         CVD   R15,LBRRCPAK            TRANSLATE RETURN CODE
         MVC   LBERRC,ERCDMASK
         ED    LBERRC,LBRRCPAK+6       MOVE TO ERROR MESSAGE
         L     R0,LBRFEDBK             RESTORE FEEDBACK CODE
         CVD   R0,LBRRCPAK             TRANSLATE FEEDBACK CODE
         MVC   LBERREAS,ERCDMASK
         ED    LBERREAS,LBRRCPAK+6     MOVE TO ERROR MESSAGE
         USING INLCIALC,R5             ADDRESSABILITY FOR IALC
         EXEC  CICS WRITEQ TS QUEUE(CATSQUE) FROM(LIBRERRM)            *
              LENGTH(LBERLEN)
         B     CLOSE
* --------------------------------------------------------------------*
* HANDLE CICS CALL ERROR
* --------------------------------------------------------------------*
CICSERR  EQU   *
         L     R15,CICSRESP            RESTORE RETURN CODE
         CVD   R15,LBRRCPAK            TRANSLATE RETURN CODE
         MVC   CICSRSP,ERCDMASK
         ED    CICSRSP,LBRRCPAK+6      MOVE TO ERROR MESSAGE
         EXEC  CICS WRITEQ TS QUEUE(CATSQUE) FROM(CICSERRM)            *
              LENGTH(CICERLEN)
         B     CLOSE
NOTFOUND EQU   *
         MVC   NFNDLNAM,CALNAME        MOVE LIBRARY NAME TO MESSAGE
         MVC   NFNDSNAM,CASNAME        MOVE SUB-LIB NAME TO MESSAGE
         MVC   NFNDMNAM,CAMNAME        MOVE MEMBER NAME TO MESSAGE
         MVC   NFNDMTYP,CAMTYPE        MOVE MEMBER TYPE TO MESSAGE
         EXEC  CICS WRITEQ TS QUEUE(CATSQUE) FROM(NFNDMSG)             *
              LENGTH(NFNDLEN)
         B     FREEIT
* --------------------------------------------------------------------*
*        EOJ EXIT                                                     *
* --------------------------------------------------------------------*
FREEIT   EQU   *
         FREEVIS ADDRESS=(5),LENGTH=(4)   RELEASE GETVIS
GOBACK   EXEC  CICS RETURN
         LTORG
         DFHEIRET
* --------------------------------------------------------------------*
* MESSAGES AND STATIC DATA                                            *
* --------------------------------------------------------------------*
*
NFNDMSG  DC    C'Error: '
NFNDLNAM DS    CL8
         DS    C'.'
NFNDSNAM DS    CL8
         DS    C'.'
NFNDMNAM DS    CL8
         DS    C'.'
NFNDMTYP DS    CL8
         DC    C' not found.'
NFNDLEN  DC    H'53'                 LENGTH OF NOT FOUND MESSAGE
*
LIBRERRM DC    C'Error: Librarian '
LBRFUNC  DS    CL6
         DC    C' error, RC='
LBERRC   DS    CL4
         DC    C', reas='
LBERREAS DS    CL4
LBERLEN  DC    H'49'
*
CICSERRM DC    C'Error: CICS '
CICSFUNC DS    CL6
         DC    C' error, Resp='
CICSRSP  DS    CL4
CICERLEN DC    H'35'
*
MSG1     DC    C'Open complete.'
M1LEN    DC    H'14'
*
MSG2     DC    C'Put complete.'
M2LEN    DC    H'13'
*
MEMIOLEN DC    H'80'
HOBCILEN DC    H'80'
LIBRMLEN DC    H'120'                LENGTH OF LIBR MESSAGE FROM IALC
ERCDMASK DC    X'40202020'           ERROR CODE MASK                    SCA03260
FWZERO   DC    F'0'                  FULLWORD ZERO
FWEIGHT  DC    F'8'                  FULLWORD EIGHT
* --------------------------------------------------------------------*
* REGISTER EQUATES                                                    *
* --------------------------------------------------------------------*
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7   Address of LDCB area
R8       EQU   8   Used for COMMAREA
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         END
/*
// EXEC IESINSRT
/*
// LIBDEF *,CATALOG=LOCAL.LIB
// EXEC LNKEDT,SIZE=256K
/. NOLNK
#&
$ $$ EOJ
* $$ END
/&
* $$ EOJ
