<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Included file for info action service */
require_once(dirname(__FILE__) . "/../env.php");
require_once(dirname(__FILE__) . "/AService.php");
require_once($_MODELS_DIR . "/ApplicationDescriptor.php");
require_once($_MODELS_DIR . "/AttributesMask.php");

class UpdateService extends AService {

	public function __construct() {
		$this->name = "update";
	}


	public function run() {
		global $server, $header, $response, $input, $aLocales;
		// Check and get app id
		if (!isset($input['id']) || $input['id'] == "") {
			$this->reportBadRequest("Missing id parameter");
			return;
		}
		$appId = $input['id'];
		// Check and get current version code
		if (!isset($input['version']) || $input['version'] == "") {
			$this->reportBadRequest("Missing version parameter");
			return;
		}
		$version = $input['version'];
		// Get branch if any
		$branch = NULL;
		if (isset($input['branch']) && $input['branch'] != "") {
			$branch = $input['branch'];
		}
		// Set attributes mask, use ALL if not set
		$iAttrMask = NULL;
		if (!isset($input['attributes'])) {
			$iAttrMask = AttributesMask::ATTR_ALL;
		} else {
			$iAttrMask = AttributesMask::getMask($input['attributes']);
		}

		// Get decriptor service
		$appDescGetter = $server->getDescriptorsModule();
		if ($appDescGetter === NULL) {
			$this->reportInternalError("Unable to get descriptors service");
			return;
		}
		// Get data
		$appDesc = $appDescGetter->getApplication($appId, 0);
		if ($appDesc == NULL) {
			$this->reportBadRequest("Application not found");
			return;
		}
		$hasUpdate = false;
		$latestVersion = NULL;
		if ($branch != NULL) {
			$branchFound = false;
			// Search requested branch
			foreach ($appDesc->getBranches() as $appBranch) {
				if ($appBranch->getIdentifier() == $branch) {
					$branchFound = true;
					$latestVersion = $appBranch->getLatestVersion();
					if ($latestVersion == NULL) {
						$this->reportInternalError("Requested branch is empty");
						return;
					}
					if ($latestVersion->getCode() > $version) {
						$hasUpdate = true;
					}
				}
			}
			if (!$branchFound) {
				$this->reportBadRequest("Branch not found");
				return;
			}
		} else {
			// Search in all branches
			foreach ($appDesc->getBranches() as $appBranch) {
				$branchLatestVersion = $appBranch->getLatestVersion();
				if ($latestVersion == NULL 
						|| $branchLatestVersion->getCode() >
								$latestVersion->getCode()) {
					$latestVersion = $branchLatestVersion;
				}
			}
			if ($latestVersion != NULL
					&& $latestVersion->getCode() > $version) {
				$hasUpdate = true;
			}
		}
		if ($latestVersion == NULL) {
			// No version found
			$this->reportIntenalError("No version found");
			return;
		}
		$response = '{"has_update":' . json_encode($hasUpdate) . "}";
		$header = "HTTP/1.0 200 Ok; Content-Type: application/json;"
				. " Content-Length: " . strlen($response);
	}

}

$update_service = new UpdateService();
$update_service->run();
?>