<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Interface for server setup. */
interface IConfigLoader {

	/** Create an IAppDescGetter.
	 * @param String $sDefaultLocale The default locale to use.
	 * @return IAppDescGetter The configurated descriptors module.
	 */
	public function loadDescriptorsModule($sDefaultLocale);

	/** Create an IDataGetter.
	 * @return IDataGetter The configurated data module.
	 */
	public function loadDataModule();

	/** Create an ILogger.
	 * @return ILogger The configurated logger module.
	 */
	public function loadLoggerModule();


	/** Load server description.
	 * @return array Associative Array of array of read configuration.
	 * First index is key name, second index is locale.
	 */
	public function getDescriptions();

	/** Load locales configuration.
	 * @return array Associative array of read configuration.
	 */
	public function getLocalesConf();

	/** Load status configuration.
	 * @return array Associative array of read configuration.
	 */
	public function getStatusConf();

}

?>
