<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config['module_id']['blog']);
$comment->module_id = $core_config['module_id']['blog'];


// SETUP TAGS ------------------------------------------------------------
require_once('components/core/class/Tag.class.php');
$tag = new Tag($db);


// FORMAT BLOG ENTRY -------------------------------------------------------
if (!empty($output_blog)) {
	// get authors
	$output_authors = $participation->selParticipants(null, $blog_config['role']['author']);
				
	if (!empty($output_authors)) {
		foreach ($output_authors as $key => $i):
			$user->identity_ids[] = $i['identity_id'];
		endforeach;
		
		$user->identity_ids = array_unique($user->identity_ids);
		
		if (!empty($user->identity_ids)) {
			$output_identities = $user->selUserIdentities();
			
			// we place the identities against the participants
			if (!empty($output_identities)) {
				foreach ($output_authors as $keyp => $p):
					foreach ($output_identities as $keyi => $i):
						if ($p['identity_id'] == $i['identity_id']) {
							$output_authors[$keyp]['identity'] = $i;
							break;
						}
					endforeach;
				endforeach;
			}
			
			$body->set('authors', $output_authors);
		}
	}	
	
	
	if (!empty($output_entry)) {
		// get author
		$author_participation = $participation->selParticipation($output_entry['user_id']);
		$output_identity = $user->selUserIdentity(null, $author_participation['identity_id']);
	
		
		// get latest entries
		$blog->limit = 6;
		$output_entries = $blog->selEntries($output_blog['blog_id']);
		$body->set('entries', $output_entries);
	}
		
	
	if (!empty($_SESSION['md5'])) {
		// FAVOURITES -----------------------------------------
		// note, we bookmark the entire blog and not the entries alone
		require_once('components/core/class/Bookmark.class.php');
		$bookmark = new Bookmark($db, $core_config['module_id']['blog']);
		$bookmark->item_id = $output_blog['blog_id'];
		$bookmark->user_id = $_SESSION['user_id'];	
		$bookmark->inner_item_id = $output_blog['blog_id'];	
		$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
		
		// 0=unset, 1=set
		if (isset($_POST['mark_0_x'])) {
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['mark_1_x'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_POST['mark_2_x'])) {
			$bookmark->insertBookmark(1);
		}
		elseif (isset($_POST['recommend_0_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['recommend_1_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->insertBookmark();
		}
		
		
// 		// bookmarks
// 		if (isset($_POST['mark'])) {
// 			// 0=unset, 1=set, 2=set and track
// 			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
// 			
// 			if ($_POST['mark'] == 2) {
// 				$bookmark->insertBookmark(1);
// 			}
// 			elseif ($_POST['mark'] == 1) {
// 				$bookmark->insertBookmark();
// 			}
// 			else {
// 				$bookmark->deleteBookmark();
// 			}
// 		}
// 		elseif (isset($_POST['recommend'])) {
// 			// 0=unset, 1=set
// 			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
// 			
// 			if ($_POST['recommend'] == 1) {
// 				$bookmark->insertBookmark();
// 			}
// 			else {
// 				$bookmark->deleteBookmark();
// 			}
// 		}
		
		
		// GET BOOKMARK --------------------------------------------------
		if (isset($bookmark)) {
			$bookmark->item_id = $output_blog['blog_id'];
			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_blog['bookmark']['watch'] = 1;
			}
			
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_blog['bookmark']['recommend'] = 1;
			}
		}
		
		
		// GET RATINGS -----------------------------------------------------
		if (!empty($output_entry)) {
			// note: ratings are done on an entry and not the blog
			require_once('components/core/class/Rate.class.php');
			$rate = new Rate($db, $core_config['module_id']['blog']);
			$rate->item_id = $output_blog['blog_id'];
			$rate->inner_item_id = $output_entry['entry_id'];
			$rate->user_id = $_SESSION['user_id'];	
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			
			// 0=unset, 1=set
			if (isset($_POST['relevent_0_x'])) {
				$rate->deleteRating();
				$rate->insertRating(0);
			}
			elseif (isset($_POST['relevent_1_x'])) {
				$rate->deleteRating();
				$rate->insertRating(1);
			}
			elseif (isset($_POST['accurate_0_x'])) {
				$rate->rate_type = $core_config['rate']['type']['accurate'];
				$rate->deleteRating();
				$rate->insertRating(0);
			}
			elseif (isset($_POST['accurate_1_x'])) {
				$rate->rate_type = $core_config['rate']['type']['accurate'];
				$rate->deleteRating();
				$rate->insertRating(1);
				
			}
			
// 			if (isset($_POST['relevent'])) {
// 				// 0=unset, 1=set
// 				$rate->rate_type = $core_config['rate']['type']['relevent'];
// 				
// 				$rate->deleteRating();
// 				
// 				if ($_POST['relevent'] == 1) {
// 					$rate->insertRating(1);
// 				}
// 				else {
// 					$rate->insertRating(0);
// 				}
// 			}
// 			elseif (isset($_POST['accurate'])) {
// 				// 0=unset, 1=set
// 				$rate->rate_type = $core_config['rate']['type']['accurate'];
// 				
// 				$rate->deleteRating();
// 				
// 				if ($_POST['accurate'] == 1) {
// 					$rate->insertRating(1);
// 				}
// 				else {
// 					$rate->insertRating(0);
// 				}
// 			}
// 			
			// select my ratings on this page
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			$output_rating_relevent = $rate->selRating();
			
			if (isset($output_rating_relevent)) {
				if (isset($output_rating_relevent[0]['rate_value'])) {
					$output_entry['rate']['relevent']['value'] = $output_rating_relevent[0]['rate_value'];
				}
			}
			
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$output_rating_accurate = $rate->selRating();
			
			if (isset($output_rating_accurate)) {
				if (isset($output_rating_accurate[0]['rate_value'])) {
					$output_entry['rate']['accurate']['value'] = $output_rating_accurate[0]['rate_value'];
				}
			}
			
			unset($rate->user_id);
			
			// statistics
			if (isset($output_rating_relevent)) {
				$rate->rate_type = $core_config['rate']['type']['relevent'];
				$output_entry['rate']['relevent']['total'] = $rate->countRating();
				$output_entry['rate']['relevent']['positive'] = $rate->countRating(1);
				
				if (!empty($output_entry['rate']['relevent']['total'])) {
					$percentage = round((100 / $output_entry['rate']['relevent']['total']) * $output_entry['rate']['relevent']['positive']);
				}
				else {
					$percentage = "0";
				}
				
				$lang['txt_relevent_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_relevent_summary']);
			}
			
			if (isset($output_rating_accurate)) {
				$rate->rate_type = $core_config['rate']['type']['accurate'];
				$output_entry['rate']['accurate']['total'] = $rate->countRating();
				$output_entry['rate']['accurate']['positive'] = $rate->countRating(1);
				
				if (!empty($output_entry['rate']['accurate']['total'])) {
					$percentage = round((100 / $output_entry['rate']['accurate']['total']) * $output_entry['rate']['accurate']['positive']);
				}
				else {
					$percentage = "0";
				}
				
				$lang['txt_accurate_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_accurate_summary']);
			}
		
		
			// select tags
			// note: tags are done on an entry and not the blog
			require_once('components/core/class/Tag.class.php');
			$tag = new Tag($db, $core_config['module_id']['blog'], $blog_config['tag']['blg']['entry']);
			$tag->item_id = $output_blog['blog_id'];
			$tag->inner_item_id = $output_entry['entry_id'];
			$tag->user_id = $_SESSION['user_id'];	
			
			if (isset($_POST['insert_tag']) && !empty($_POST['tag_body'])) {
				if (empty($_POST['tag_id'])) { // we insert
					$tag->insertTag($_POST['tag_body']);
				}
				elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
					$tag->deleteTag($_POST['tag_id']);
				}
				else { // we update tag
					$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
				}
			}
			elseif (isset($_POST['delete_tag']) && !empty($_POST['tag_id'])) {
				$tag->deleteTag($_POST['tag_id']);
			}
			elseif (isset($_REQUEST['edit_tag'])) {
				$output_tag = $tag->selTag($_REQUEST['edit_tag']);
			
				if (!empty($output_tag)) {
				$body->set('tag', $output_tag);
				}
			}
			
			$output_tags = $tag->selTags();				
			
			if (!empty($output_tags)) {
				$body->set('tags', $output_tags);
			}
		
			$body->set('entry', $output_entry);
	
			$body->set('blog', $output_blog);
	
	
			// SET AND GET COMMENTS ----------------------------------------------
			if (isset($_POST['insert_comment'])) {
				$comment->user_id = $_SESSION['user_id'];
				$comment->item_id = $output_blog['blog_id'];
				$comment->inner_item_id = $output_entry['entry_id'];
				$comment->item_user_id = $output_entry['user_id'];
				
				require_once('components/core/class/Kses/kses.php');
		
				$_POST['comment_body'] = kses_parse($_POST['comment_body'], 'min');
		
				$comment->insertComment($_POST);
				
				// insert statistics ------------------------------
				require_once('components/core/class/Statistic.class.php');
				$statistic = new Statistic($db, $blog_config['statistic']);
				$statistic->module_id = $core_config['module_id']['blog'];
				$statistic->user_id = $_SESSION['user_id'];
				
				// insert blog statistic - blog comments
				$statistic->statistic_type_id = $blog_config['statistic']['total_comments'];
				$statistic->item_id = $output_blog['blog_id'];
				$statistic->setStatistic($comment->countComments());
				
				unset($statistic->module_id, $comment->item_id, $comment->inner_item_id);
				
				// insert user statistic - total comments
				$statistic->item_id = $_SESSION['user_id'];
				$statistic->statistic_type_id = $core_config['statistic']['user']['total_comments'];
				$statistic->setStatistic($comment->countComments());
					
			}
			elseif (isset($_POST['preview_comment'])) {
				$output_comment = $_POST;
				$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
				$output_comment['comment_body'] = htmlspecialchars($output_comment['comment_body']);
		
				$output_comment['display_comment_body'] = $output_comment['comment_body'];
				
				$body->set('comment', $output_comment);
				$body->set('display', 'preview_comment');
			}
			elseif (isset($_POST['edit_comment_again'])) {
				$output_comment = $_POST;
				$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
			
				$body->set('comment', $output_comment);
			}
			
			unset ($comment->user_id);
			
			$comment->item_id = $output_blog['blog_id'];
			
			$output_comments = $comment->selComments($output_entry['entry_id']);
			
			$body->set('comments', $output_comments);
		
		
			// GET AND SET RELATIONSHIP -----------------------------------------------
			if (isset($output_participation) && $output_entry['user_id'] != $_SESSION['user_id']) {
				require_once ("components/core/class/Tie.class.php");
				$tie = new Tie($db, $core_config);
				$tie->module_id = $core_config['module_id']['blog'];
				$tie->item_id = $output_blog['blog_id'];
				
				$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
				
				if (empty($output_relationship) && !empty($_REQUEST['respect'])) {
					
					$tie->user_id = $_SESSION['user_id'];
					
					$data['identity_id'] = $output_participation['identity_id'];
					$data['identity_id_relation'] = $output_identity['identity_id'];
					
					$tie->insertRelation($data);
					
					$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
				}		
				
				
				if (!empty($output_relationship)) {
					if ($tie->isMutual($output_identity['identity_id'], $output_participation['identity_id'])) {
						$output_relationship['mutual'] = 1;
					}
					
					$body->set('relationship', $output_relationship);
				}
				
				
				// GET THEIR MATRIX ---------------------------------------
				$output_common_ties = $tie->selCommonTies($output_identity['identity_id'], $output_participation['identity_id']);
				$output_common_ties['identity_id'] = $output_participation['identity_id'];
				$output_common_ties['identity_id_relation'] = $output_identity['identity_id'];
	
				$body->set('common_ties', $output_common_ties);
				
				// GET THEIR TESTIMONIAL COUNT ---------------------------
				require_once ("components/core/class/Testimonial.class.php");
				$testimonial = new Testimonial($db);
				$testimonial->identity_id = $output_identity['identity_id'];
				$testimonial->testifier_identity_id = $output_participation['identity_id'];
	
				// count testimonials
				$output_identity['testimonial_count'] = $testimonial->countTestimonials();
			}
	
			$body->set('identity', $output_identity);
		}
	}
	
	// blogroll
	$output_blogroll = $blog->selBlogRoll($output_blog['blog_id']);
	
	if (!empty($output_blogroll)) {
		$body->set('blogroll', $output_blogroll);
	}
	
	$body->set('blog', $output_blog);
}
else {
	header("Location: index.php?amn=blg_overview&" . strip_tags(SID));
	exit;
}

?>