<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Library {



	// Library --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 18th May 2004
	//
	function Library($db, $library_config) {
		$this->db = $db;
		$this->library_config = $library_config;
	}//EO Library
	
	
	
	// selSets --------------------------------------------------------------------
	// Return a list of library sets
	// tom calthrop - 20th June 2006
	//
	function selSets() {

	    $query = "
			SELECT DISTINCT s.set_id, s.set_title, s.set_synopsis, 
			s.default_page_id, s.user_id, s.file_id, s.set_type, 
			s.set_create_datetime, s.set_permission, s.status_id, 
			s.level_id 
			FROM " . $this->db->prefix . "_library_set s 

			LEFT JOIN " . $this->db->prefix . "_mem_type_access mt ON s.set_id=mt.item_id and mt.module_id=" . $this->library_config['module_id'] . " 
			WHERE "
		;
		
		if (isset($this->status_id)) {
		    $query .= "s.status_id=" . $this->status_id . " AND ";
		}
		
		if (isset($this->level_id)) {
		    $query .= "s.level_id=" . $this->level_id . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->set_ids)) {
			$set_ids = "";
			foreach($this->set_ids as $key => $i):
				$set_ids .= $i;
				if (count($this->set_ids) > $key+1) {
				    $set_ids .=",";
				}
			endforeach;
			$query .="s.set_id in (" . $set_ids . ") AND ";
		}
		
		$query .= "(s.set_type!=4 OR ";
		$query .= "(s.set_type=4 AND mt.membership_type_id=". $this->membership_type_id . ")) AND ";
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by s.set_title";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					
					if (isset($temp1['file_id'])) {
	 					$temp1['image'] = $this->file->selFile($temp1['file_id'], "t2");
	 				}
	 				else {
	 					$temp1['image']['file_title'] = "";
	 					$temp1['image']['file_md5_name_view'] = "0-" . $this->file->no_image;
	 				}
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selSets class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selSets();



	// selPage --------------------------------------------------------------------
	// select a library page
	// tom calthrop - 21st June 2006
	//
	function selPage($page_id=null, $page_name=null) {

		$query = "
			SELECT page_id, page_title, page_synopsis, set_id, 
			page_name, page_permission, current_revision_id 
			FROM " . $this->db->prefix . "_library_page 
			WHERE "
		;
		
		if (isset($page_id)) {
			$query .= "page_id=" . $page_id . " AND ";
		}
		
		if (isset($page_name)) {
			$query .= "page_name=" . $this->db->qstr($page_name, get_magic_quotes_gpc()) . " AND 
			set_id=" . $this->set_id . " AND ";
		}
		
		$query .="1=1";
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selPage class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}

	}//EO selPage



	// selRevision --------------------------------------------------------------------
	// select a library revision
	// tom calthrop - 21st June 2006
	//
	function selRevision($revision_id) {

		$query = "
			SELECT revision_id, page_id, revision_body, user_id, 
			revision_create_datetime, revision_note 
			FROM " . $this->db->prefix . "_library_revision 
			WHERE 
			revision_id=" . $revision_id
		;
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selRevision class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}

	}//EO selRevision
	
	
	
	// selRevisions --------------------------------------------------------------------
	// select revision list
	// tom calthrop - 21st November 2006
	//
	function selRevisions($page_id=null, $unique_page=null) {
		if (isset($page_id)) {
			$query = "
				SELECT r.revision_id, r.user_id, 
				r.revision_create_datetime 
				FROM " . $this->db->prefix . "_library_revision r 
				WHERE 
				r.page_id=" . $page_id . " AND "
			;
		}
		else { // used in overview page
			$query = "
				SELECT r.revision_id, r.user_id, p.page_title, p.page_id, p.page_synopsis, 
				r.revision_create_datetime 
				FROM " . $this->db->prefix . "_library_revision r, " . $this->db->prefix . "_library_page p "
			;
			
			if (isset($this->level_id)) {
		   		$query .= ", " . $this->db->prefix . "_library_set s";
			}
			
			$query .= "
				WHERE 
				r.page_id=p.page_id AND "
			;
			
			if (isset($this->level_id)) {
		   		$query .= "p.page_id=s.default_page_id AND s.level_id=" . $this->level_id . " AND ";
			}
		
		}
		
		if (isset($unique_page)) {
		    $query .= "r.page_id=p.current_revision_id AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "r.user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by r.revision_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selRevisions class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selRevisions();
	
	
	
	// selPages --------------------------------------------------------------------
	// used to list the page_names held in this library against a library set
	// tom calthrop - 21st June 2006
	//
	function selPages($set_id=null, $full=null) {
		if (isset($full)) {
		    $query = "SELECT page_name, page_title, page_synopsis, page_id ";
		}
		else {
		    $query = "SELECT DISTINCT page_name ";
		}
		
		$query .= "
			FROM " . $this->db->prefix . "_library_page 
			WHERE " 
		;
		
		if (isset($set_id)) {
			$query .= "set_id=" . $set_id . " AND ";
		}
		
		if (isset($this->page_ids)) {
			$page_ids = "";
			foreach($this->page_ids as $key => $i):
				$page_ids .= $i;
				if (count($this->page_ids) > $key+1) {
				    $page_ids .=",";
				}
			endforeach;
			$query .="page_id in (" . $page_ids . ") AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by page_name";
		}
				
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				if (isset($full)) {
					$temp1 = $result->fields;
				}
				else {
					$temp1 = $result->fields['page_name'];
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selPages class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selPages();
	
	
	
	// selSet --------------------------------------------------------------------
	// Return a list of library sets
	// tom calthrop - 20th June 2006
	//
	function selSet($set_id) {

	    $query = "
			SELECT set_id, set_title, set_synopsis, set_type, 
			default_page_id, user_id, file_id, language_id, 
			set_create_datetime, set_permission, status_id, 
			default_user_permission, level_id 
			FROM " . $this->db->prefix . "_library_set 
			WHERE 
			set_id=" . $set_id
		;
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "method=selSet class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selSet();
	
	
	// checkWikiPageName --------------------------------------------------
	// returns true if page name is StudyCapsFormat
	// tom calthrop - 18th May 2006
	//
	function checkWikiPageName($wikipagename) {
		$upper = "A-Z";
		$lower = "a-z0-9";
		$either = "A-Za-z0-9";
		
		$regex =
			"(!?" .            // START WikiPage pattern (1)
			"[$upper]" .       // 1 upper
			"[$either]*" .     // 0+ alpha or digit
			"[$lower]+" .      // 1+ lower or digit
			"[$upper]" .       // 1 upper
			"[$either]*" .     // 0+ or more alpha or digit
			")"
		;
		
		if (preg_match($regex, $wikipagename)) {
			return true;
		}
		else {
			return false;
		}
	} // EO checkWikiPageName
}
?>
