<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// this include file is used in the core and in the event
// if it receives either a item_id or a event_id it gets the event
// if it returns the event it checks your participation in that

$menu_section = "library";

// SETUP LIBRARY ---------------------------------------------------------
$library_config['module_id'] = $core_config['module_id']['library'];

require_once('components/lbr/class/Library.class.php');
$library = new Library($db, $library_config);

if (empty($_SESSION['md5'])) {
	$library->level_id = $library_config['level']['public'];
	$library->membership_type_id = 0;
}
else {
	$library->membership_type_id = $_SESSION['membership_type_id'];
}

require_once('components/core/class/Participation.class.php');
$participation = new Participation($db, $core_config);
$participation->module_id = $core_config['module_id']['library'];


// GET PAGE ----------------------------------------------------------
if (!empty($_REQUEST['page_id'])) {
	$output_page = $library->selPage($_REQUEST['page_id']);
	$output_revision = $library->selRevision($output_page['current_revision_id']);
	$output_set = $library->selSet($output_page['set_id']);
}
elseif (!empty($_REQUEST['revision_id'])) {
	$output_revision = $library->selRevision($_REQUEST['revision_id']);
	$output_page = $library->selPage($output_revision['page_id']);
	$output_set = $library->selSet($output_page['set_id']);
}
elseif (!empty($_REQUEST['page_name']) && !empty($_REQUEST['set_id'])) {
	$library->set_id = $_REQUEST['set_id'];
	$output_page = $library->selPage(null, $_REQUEST['page_name']);
	
	if (!empty($output_page)) { // empty if it is a new page
		$output_revision = $library->selRevision($output_page['current_revision_id']);
		$output_set = $library->selSet($output_page['set_id']);
	}
	else {
		$output_set = $library->selSet($_REQUEST['set_id']);
	}
}
elseif (!empty($_REQUEST['set_id'])) {
	$output_set = $library->selSet($_REQUEST['set_id']);
	$output_page = $library->selPage($output_set['default_page_id']);
	$output_revision = $library->selRevision($output_page['current_revision_id']);
}
elseif (!empty($_REQUEST['item_id'])) {
	$output_set = $library->selSet($_REQUEST['item_id']);
	$output_page = $library->selPage($output_set['default_page_id']);
	$output_revision = $library->selRevision($output_page['current_revision_id']);
}

// set up menu system
if (!empty($output_page)) {
	$output_library['set_id'] = $output_page['set_id'];
	$output_library['page_id'] = $output_set['default_page_id'];
	$output_library['user_id'] = $output_set['user_id'];
	
}

if (isset($output_set)) {
	// a participant is a contributor; someone who has edited a page revision
	$participation->item_id = $output_set['set_id'];
	
	if (isset($_SESSION['user_id'])) {
		$output_participation = $participation->selParticipation($_SESSION['user_id']);
	}
	else { // we are not logged in
		if ($output_set['level_id'] == $library_config['level']['public']) {
			$output_participation = array();
		}
		else {
			header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
			exit;
		}
	}
	
	if (!empty($output_participation)) {
		$tpl->set('participation', $output_participation);
		$body->set('participation', $output_participation);
	}
	else {
		unset($output_participation);
	}
	
	$tpl->set('set', $output_set);
	$body->set('set', $output_set);
}



// we authenticate the user
if (isset($output_set['set_id']) && $script_name != "participation_edit") {
	//check status	
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $library_config['user']['status']['barred']) {
		header("Location: index.php?amn=lbr_participate&" . strip_tags(SID));
		exit;
	}
	elseif ($output_set['level_id'] < $library_config['level']['public'] && $output_set['set_type'] == $library_config['type']['membership_type'] && $output_set['user_id'] != $_SESSION['user_id']) {
		// we need to check that my membership_type corresponds to those that can access the set
		if (!$participation->checkSetMembershipTypeAccess($_SESSION['membership_type_id'])) {
			header("Location: index.php?amn=lbr_overview&" . strip_tags(SID));
			exit;
		}
	}
}

$tpl->set("library_config", $library_config);
$body->set("library_config", $library_config);


// FULLSCREEN MODE ------------------------------------------
// there is no full screen mode for the library
unset ($_SESSION['fullscreen']);

?>
