<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section= "library";

// the stylesheet editor allows library owners to create a set of styles
// which can be applied to their library. We define the
// tags that can be set and include a function to write the stylesheet 
// to the library table


// which custom styles do we allow (remove var if none)
$allowable_custom_styles = array(
	'background-image',
	'background-color',
	'color',
	'border-top',
	'border-left',
	'border-right',
	'border-bottom',
	'border-style',
	'margin-top',
	'margin-left',
	'margin-right',
	'margin-bottom',
	'padding-top',
	'padding-left',
	'padding-right',
	'padding-bottom',
	'float'
);


// function to apply stylesheet to the library set 
function setStyleSheet_lbr($set_id, $css) {
	
	global $db;
	
	$query = "
		SELECT set_id, set_css
		FROM " . $db->prefix . "_library_set 
		WHERE 
		set_id=" . $set_id
	;
	
	$result = $db->SelectLimit($query, 1);
		
	if (isset($result->fields)) {
		$rec = array();
		$rec['set_css'] = $css;
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}

// select a stylesheet from the library set 
function selItem_lbr($set_id) {
	
	global $db;
	
	$query = "
		SELECT set_id, set_css, set_title
		FROM " . $db->prefix . "_library_set
		WHERE 
		set_id=" . $set_id
	;
	
	$result = $db->SelectLimit($query, 1);
		
	if (isset($result->fields)) {
		$item['item_id'] = $result->fields['set_id'];
		$item['item_title'] = $result->fields['set_title'];
		$item['item_css'] = $result->fields['set_css'];
			
		return $item;
	}
}


?>