# This file is part of aroundme
#  
# Copyright (C) 2003, 2004 Barnraiser
# http://www.barnraiser.org/
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with program; see the file COPYING. If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
# 

# Table structure for table `am_abuse`
CREATE TABLE `am_abuse` (
  `abuse_id` int(11) NOT NULL auto_increment,
  `abuse_url` varchar(255) default NULL,
  `abuse_source` text,
  `reportee_user_id` int(11) default NULL,
  `assigned_user_id` int(11) default NULL,
  `abuse_note` text,
  `reportee_language_id` int(11) default NULL,
  `report_datetime` datetime default NULL,
  `report_status_id` int(11) default NULL,
  PRIMARY KEY  (`abuse_id`)
) TYPE=MyISAM COMMENT='record of all instances of reported abuse';


# Table structure for table `am_acs_group_role`
CREATE TABLE `am_acs_group_role` (
  `role_id` int(11) NOT NULL auto_increment,
  `role_name` varchar(255) default NULL,
  `group_id` int(11) default NULL,
  PRIMARY KEY  (`role_id`)
) TYPE=MyISAM COMMENT='access control system - roles';


# Table structure for table `am_acs_permission`
CREATE TABLE `am_acs_permission` (
  `section_id` int(11) default NULL,
  `role_id` int(11) default NULL,
  `privilege_id` int(11) default NULL,
  `resource_id` int(11) default NULL
) TYPE=MyISAM COMMENT='access control system - roles';


# Table structure for table `am_activity`
CREATE TABLE `am_activity` (
  `activity_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `event_id` int(11) default NULL,
  `activity_title` varchar(255) default NULL,
  `activity_description` text,
  `activity_start_datetime` datetime default NULL,
  `activity_end_datetime` datetime default NULL,
  `activity_create_datetime` datetime default NULL,
  `activity_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `activity_total_required` int(11) default NULL,
  `activity_approved` int(11) default NULL,
  PRIMARY KEY  (`activity_id`)
) TYPE=MyISAM;


# Table structure for table `am_activity_user`
CREATE TABLE `am_activity_user` (
  `activity_user_id` int(11) NOT NULL auto_increment,
  `activity_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `activity_user_create_datetime` datetime default NULL,
  `activity_user_edit_datetime` datetime default NULL,
  `activity_user_status` int(11) default NULL,
  `user_id_edit` int(11) default NULL,
  PRIMARY KEY  (`activity_user_id`)
) TYPE=MyISAM;


# Table structure for table `am_blog`
CREATE TABLE `am_blog` (
  `blog_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `blog_title` varchar(255) default NULL,
  `blog_synopsis` varchar(255) default NULL,
  `blog_body` text,
  `blog_publish` int(11) default NULL,
  `language_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `blog_create_datetime` datetime default NULL,
  `blog_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `genre_id` int(11) default NULL,
  `blog_image_id` int(11) default NULL,
  `blog_total_views` int(11) default '0',
  PRIMARY KEY  (`blog_id`)
) TYPE=MyISAM;


# Table structure for table `am_blog_bookmark`
CREATE TABLE `am_blog_bookmark` (
  `blog_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `bookmark_type` int(11) default NULL
) TYPE=MyISAM COMMENT='user bookmarks for blog content';


# Table structure for table `am_blog_rate`
CREATE TABLE `am_blog_rate` (
  `blod_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `rate` int(11) default NULL,
  `rate_type` int(11) default NULL
) TYPE=MyISAM;


# Table structure for table `am_event`
CREATE TABLE `am_event` (
  `event_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `event_create_datetime` datetime default NULL,
  `event_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `event_start_datetime` datetime default NULL,
  `event_start_day` int(11) default NULL,
  `event_start_month` int(11) default NULL,
  `event_start_year` int(11) default NULL,
  `event_start_hour` int(11) default NULL,
  `event_start_minute` int(11) default NULL,
  `event_start_weekday` int(11) default NULL,
  `event_end_datetime` datetime default NULL,
  `event_end_day` int(11) default NULL,
  `event_end_month` int(11) default NULL,
  `event_end_year` int(11) default NULL,
  `event_end_hour` int(11) default NULL,
  `event_end_minute` int(11) default NULL,
  `event_end_weekday` int(11) default NULL,
  `event_title` varchar(255) default NULL,
  `event_type_id` int(11) default NULL,
  `event_description` text,
  `event_body` text,
  `event_location` varchar(255) default NULL,
  `event_frequency` int(11) default NULL,
  `forum_subject_id` int(11) default NULL,
  `event_image_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `publish_id` int(11) default NULL,
  PRIMARY KEY  (`event_id`)
) TYPE=MyISAM;


# Table structure for table `am_event_bookmark`
CREATE TABLE `am_event_bookmark` (
  `event_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `bookmark_type` int(11) default NULL
) TYPE=MyISAM;


# Table structure for table `am_forum_reply`
CREATE TABLE `am_forum_reply` (
  `reply_id` int(11) NOT NULL auto_increment,
  `subject_id` int(11) default NULL,
  `reply_body` text,
  `reply_create_datetime` datetime default NULL,
  `reply_edit_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  `user_id_edit` int(11) default NULL,
  PRIMARY KEY  (`reply_id`)
) TYPE=MyISAM;


# Table structure for table `am_forum_section`
CREATE TABLE `am_forum_section` (
  `section_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `section_title` varchar(255) default NULL,
  `section_create_datetime` datetime default NULL,
  `section_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`section_id`)
) TYPE=MyISAM;


# Table structure for table `am_forum_subject`
CREATE TABLE `am_forum_subject` (
  `subject_id` int(11) NOT NULL auto_increment,
  `topic_id` int(11) default NULL,
  `subject_title` varchar(255) default NULL,
  `poll_id` int(11) default NULL,
  `subject_image_id` int(11) default NULL,
  `reply_total` int(11) default NULL,
  `user_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `subject_body` text,
  `subject_create_datetime` datetime default NULL,
  `subject_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `subject_locked` int(11) default NULL,
  `subject_sticky` int(11) default NULL,
  PRIMARY KEY  (`subject_id`)
) TYPE=MyISAM;


# Table structure for table `am_forum_subject_movement`
CREATE TABLE `am_forum_subject_movement` (
  `subject_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `recommend` int(11) default NULL,
  `watch` int(11) default NULL,
  `lastview_datetime` datetime default NULL
) TYPE=MyISAM COMMENT='user bookmarks for forum content';


# Table structure for table `am_forum_topic`
CREATE TABLE `am_forum_topic` (
  `topic_id` int(11) NOT NULL auto_increment,
  `section_id` int(11) default NULL,
  `topic_title` varchar(255) default NULL,
  `topic_body` text NOT NULL,
  `level_id` int(11) default NULL,
  `topic_image_id` int(11) default NULL,
  `subject_total` int(11) default NULL,
  `topic_create_datetime` datetime default NULL,
  `topic_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `user_id` int(11) default NULL,
  `topic_locked` int(11) default NULL,
  `topic_sticky` int(11) default NULL,
  PRIMARY KEY  (`topic_id`)
) TYPE=MyISAM;


# Table structure for table `am_forum_topic_movement`
CREATE TABLE `am_forum_topic_movement` (
  `topic_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `recommend` int(11) default NULL,
  `watch` int(11) default NULL,
  `lastview_datetime` datetime default NULL
) TYPE=MyISAM COMMENT='user bookmarks for forum content';


# Table structure for table `am_group`
CREATE TABLE `am_group` (
  `group_id` int(11) NOT NULL auto_increment,
  `group_title` varchar(255) default NULL,
  `group_synopsis` varchar(255) default NULL,
  `group_rules` text,
  `group_election_date` date default NULL,
  `language_id` int(11) default NULL,
  `group_create_datetime` datetime default NULL,
  `group_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `group_type` int(11) default NULL,
  `group_from_age` int(11) default NULL,
  `group_to_age` int(11) default NULL,
  `genre_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `group_image_id` int(11) default NULL,
  `group_status` int(11) default NULL,
  `group_image_allocation` int(11) default NULL,
  PRIMARY KEY  (`group_id`)
) TYPE=MyISAM PACK_KEYS=0;


# Table structure for table `am_group_bookmark`
CREATE TABLE `am_group_bookmark` (
  `group_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `bookmark_type` int(11) default NULL
) TYPE=MyISAM COMMENT='users recommended and watched groups';


# Table structure for table `am_group_image`
CREATE TABLE `am_group_image` (
  `image_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `image_filename` varchar(50) default NULL,
  `image_mime` varchar(50) default NULL,
  `image_create_datetime` datetime default NULL,
  `image_title` varchar(255) default NULL,
  `image_size` varchar(20) default NULL,
  `image_edit_datetime` int(11) default NULL,
  `user_id_edit` int(11) default NULL,
  PRIMARY KEY  (`image_id`)
) TYPE=MyISAM;


# Table structure for table `am_group_library`
CREATE TABLE `am_group_library` (
  `library_id` int(11) NOT NULL auto_increment,
  `library_page_name` varchar(100) default NULL,
  `group_id` int(11) default NULL,
  `library_default` int(11) default NULL,
  `library_title` varchar(255) default NULL,
  `library_synopsis` text,
  `library_body` text,
  `forum_subject_id` int(11) default NULL,
  `library_image_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `library_create_datetime` datetime default NULL,
  `library_edit_datetime` datetime default NULL,
  `user_edit_id` int(11) default NULL,
  `library_total_views` int(11) default NULL,
  PRIMARY KEY  (`library_id`)
) TYPE=MyISAM;


# Table structure for table `am_group_library_bookmark`
CREATE TABLE `am_group_library_bookmark` (
  `library_page_name` varchar(100) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  `group_id` int(11) default NULL,
  `bookmark_type` int(11) default NULL
) TYPE=MyISAM COMMENT='user bookmarks for library content';


# Table structure for table `am_group_member`
CREATE TABLE `am_group_member` (
  `member_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) default NULL,
  `level_id` int(11) default NULL,
  `member_create_datetime` datetime default NULL,
  `member_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `user_id` int(11) default NULL,
  `node_id` int(11) default NULL,
  PRIMARY KEY  (`member_id`)
) TYPE=MyISAM;


# Table structure for table `am_group_member_statistic`
CREATE TABLE `am_group_member_statistic` (
  `group_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `statistic_type_id` int(11) default NULL,
  `total` int(11) default NULL
) TYPE=MyISAM;


# Table structure for table `am_group_statistic`
CREATE TABLE `am_group_statistic` (
  `group_id` int(11) default NULL,
  `statistic_type_id` int(11) default NULL,
  `total` int(11) default NULL
) TYPE=MyISAM;


# Table structure for table `am_guestbook`
CREATE TABLE `am_guestbook` (
  `guestbook_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `user_id_guestbook` int(11) default NULL,
  `guestbook_body` text,
  `guestbook_comment_body` text,
  `guestbook_create_datetime` datetime default NULL,
  PRIMARY KEY  (`guestbook_id`)
) TYPE=MyISAM;


# Table structure for table `am_poll`
CREATE TABLE `am_poll` (
  `poll_id` int(11) NOT NULL auto_increment,
  `poll_question` varchar(255) default NULL,
  `poll_start_datetime` datetime default NULL,
  `poll_end_datetime` datetime default NULL,
  `poll_anon` int(11) default NULL,
  `user_id` int(11) default NULL,
  `poll_create_datetime` datetime default NULL,
  `poll_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  `vote_required` int(11) default NULL,
  PRIMARY KEY  (`poll_id`)
) TYPE=MyISAM;


# Table structure for table `am_poll_answer`
CREATE TABLE `am_poll_answer` (
  `answer_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `poll_id` int(11) default NULL,
  `option_id` int(11) default NULL,
  `current_answer` int(11) default NULL,
  `answer_create_datetime` datetime default NULL,
  PRIMARY KEY  (`answer_id`)
) TYPE=MyISAM;


# Table structure for table `am_poll_option`
CREATE TABLE `am_poll_option` (
  `option_id` int(11) NOT NULL auto_increment,
  `poll_id` int(11) default NULL,
  `option_body` varchar(255) default NULL,
  `option_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  `option_edit_datetime` datetime default NULL,
  `user_id_edit` int(11) default NULL,
  PRIMARY KEY  (`option_id`)
) TYPE=MyISAM;


# Table structure for table `am_relation`
CREATE TABLE `am_relation` (
  `user_id` int(11) default NULL,
  `user_id_friend` int(11) default NULL,
  `node_id` int(11) default NULL,
  `relation_create_datetime` datetime default NULL,
  `type` int(11) default NULL
) TYPE=MyISAM;


# Table structure for table `am_shoutbox`
CREATE TABLE `am_shoutbox` (
  `shoutbox_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `shoutbox_body` varchar(200) default NULL,
  `shoutbox_create_datetime` datetime default NULL,
  PRIMARY KEY  (`shoutbox_id`)
) TYPE=MyISAM COMMENT='shoutbox';


# Table structure for table `am_template`
CREATE TABLE `am_template` (
  `template_id` int(11) NOT NULL auto_increment,
  `template_title` varchar(50) default NULL,
  PRIMARY KEY  (`template_id`)
) TYPE=MyISAM;


# Table structure for table `am_user`
CREATE TABLE `am_user` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_firstname` varchar(255) default NULL,
  `user_surname` varchar(255) default NULL,
  `user_email` varchar(255) NOT NULL default '',
  `user_hometown` varchar(255) default NULL,
  `user_birthtown` varchar(255) default NULL,
  `user_dob` date default NULL,
  `user_summary` text,
  `user_gender` enum('F','M') default NULL,
  `user_nic` varchar(255) default NULL,
  `language_id` int(11) default NULL,
  `user_ms_messenger` varchar(100) default NULL,
  `user_yahoo_messenger` varchar(100) default NULL,
  `user_icq` varchar(100) default NULL,
  `template_id` int(11) default NULL,
  `user_homepage` varchar(50) default NULL,
  `level_id` int(11) default NULL,
  `user_password` varchar(32) NOT NULL default '',
  `user_locked` int(11) default NULL,
  `user_create_datetime` datetime default NULL,
  `user_edit_datetime` datetime default NULL,
  `active_time` timestamp(14) NOT NULL,
  `user_image_id` int(11) default NULL,
  `user_image_allocation` int(11) default NULL,
  PRIMARY KEY  (`user_id`)
) TYPE=MyISAM PACK_KEYS=0;


# Table structure for table `am_user_blocked`
CREATE TABLE `am_user_blocked` (
  `user_id_blocker` int(11) default NULL,
  `user_id_blocked` int(11) default NULL,
  `block_datetime` datetime default NULL,
  `block_description` varchar(200) default NULL
) TYPE=MyISAM;


# Table structure for table `am_user_image`
CREATE TABLE `am_user_image` (
  `image_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `image_filename` varchar(50) default NULL,
  `image_mime` varchar(50) default NULL,
  `image_create_datetime` datetime default NULL,
  `image_title` varchar(255) default NULL,
  `image_size` varchar(20) default NULL,
  `image_edit_datetime` int(11) default NULL,
  `user_id_edit` int(11) default NULL,
  PRIMARY KEY  (`image_id`)
) TYPE=MyISAM;


# Table structure for table `am_user_invited`
CREATE TABLE `am_user_invited` (
  `invited_email` varchar(100) default NULL,
  `invitee_user_id` int(11) default NULL,
  `invite_create_datetime` datetime default NULL
) TYPE=MyISAM COMMENT='logs pending invites';


# Table structure for table `am_user_language`
CREATE TABLE `am_user_language` (
  `user_id` int(11) default NULL,
  `language_id` int(11) default NULL
) TYPE=MyISAM COMMENT='contains users languages';


# Table structure for table `am_user_library`
CREATE TABLE `am_user_library` (
  `library_id` int(11) NOT NULL auto_increment,
  `library_page_name` varchar(100) default NULL,
  `library_default` int(11) default NULL,
  `library_title` varchar(255) default NULL,
  `library_synopsis` varchar(255) default NULL,
  `library_body` text,
  `library_image_id` int(11) default NULL,
  `library_publish` int(11) default NULL,
  `language_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  `library_create_datetime` datetime default NULL,
  `library_edit_datetime` datetime default NULL,
  `user_edit_id` int(11) default NULL,
  `library_total_views` int(11) default NULL,
  PRIMARY KEY  (`library_id`)
) TYPE=MyISAM;


# Table structure for table `am_user_message`
CREATE TABLE `am_user_message` (
  `message_id` int(11) NOT NULL auto_increment,
  `owner_user_id` int(11) default NULL,
  `from_user_id` int(11) default NULL,
  `to_user_id` int(11) default NULL,
  `message_status` int(11) default NULL,
  `message_box` int(11) default NULL,
  `message_subject` varchar(50) default NULL,
  `message_body` text,
  `message_create_datetime` datetime default NULL,
  `message_type` int(11) default NULL,
  PRIMARY KEY  (`message_id`)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='user mail table';


# Table structure for table `am_user_session`
CREATE TABLE `am_user_session` (
  `session_id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `session_md5` varchar(32) default NULL,
  `session_lastused` timestamp(14) NOT NULL,
  `session_firstused` timestamp(14) NOT NULL,
  `session_ip` varchar(15) default NULL,
  PRIMARY KEY  (`session_id`)
) TYPE=MyISAM;


# Table structure for table `am_user_statistic`
CREATE TABLE `am_user_statistic` (
  `user_id` int(11) default NULL,
  `statistic_type_id` int(11) default NULL,
  `total` int(11) default NULL
) TYPE=MyISAM;



# INSERT DEFAULTS -----------------------------------------

INSERT INTO `am_template` VALUES (1, 'am_default');