<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


// Include the Message class so that the message functionality is obtained

class Calendar {
	//Note setlocale(); is set in the User.class.php at login
	//this will affect date output.

	var $id;             // Group or user id
	var $db;             // Database connection
	var $tables;         // Head table to use
	var $calendar;       // The aray that contains everything in the calendar
	var $daysinmonth;    // Number of days in month
	var $firstdaynumber; // First day of the month (0 = sun, 6 = sat)

	var $mh, $da, $yr;

	function Calendar($db, $now, $id="", $type="") {
		$this->db = $db;
		$this->id  = $id;

		// Tables differ for groups and users ?
		$this->tables["events"]   = "br_events";
		$this->tables["activity"] = "br_activity";

		if(empty($type))
		{
			$this->tables["events"]   = $this->tables["events"]."_user";
			$this->tables["activity"] = $this->tables["activity"]."_user";
		}

		$this->mh  = $now['mon'];
		$this->da  = $now['mday'];
		$this->yr  = $now['year'];

		$this->calendar = array(); // Initialize calendar

	}

	function setCalendarBase()
	{
		//setup calendar array
		$this->daysinmonth = date("t",mktime(0, 0, 0, $this->mh, 1, $this->yr));

		//get first day of the month (0 = sun, 6 = sat)
		$this->firstdaynumber = date("w",mktime(0,0,0,$this->mh,1,$this->yr));

		//populate the calendar array with dates
		//fill the calendar
		for ($i=0; $i < $this->daysinmonth; $i++) {
			$temp = array(
				'today' => date("d-M-Y",mktime(0,0,0,$this->mh,$i+1,$this->yr)),
				'daynumber' => $i+1,
				'content' => array()
			);

			array_push($this->calendar, $temp);
		}

	}

	function setBlankDays()
	{
		//work out how many blank calendar spaces to put at the start of the calendar
		$blankdays = 7-(7-$this->firstdaynumber);

		for ($i=0; $i < $blankdays; $i++) {
			array_unshift($this->calendar, array());
		}

		//work out the blank to fill the calendar
		$blankdays = count($this->calendar);
		while($blankdays > 7){
			$blankdays = $blankdays-7;
		} // while
		$blankdays = 7-$blankdays;


		for ($i=0; $i < $blankdays; $i++) {
			array_push($this->calendar, array());
		}

	}

	function getCalendar()
	{
		return $this->calendar;
	}

	function getToDay($time)
	{
		// Checks if the view is the current month
		$date = getdate($time);
		$mh  = $date['mon'];
		$yr  = $date['year'];

		if($mh == $this->mh & $yr == $this->yr)
			return date("j",mktime());
		else
			return "";
	}

	function getDayContent($day)
	{
		return $this->calendar[$day-1+$this->firstdaynumber]['content'];
	}

	// Recalculate the dates so that the matches up
	// the structure of the populating algortihm
	// Erik Sundelöf, June 3, 2004
	//-----------------------------

	function modifyEventDate($event) {
		$event_date = $this->calculateDate($event);

		if(!empty($event_date[0])) {
			$event[5] = $event_date[0];
			$event["event_start_datetime"] = $event_date[0];
		}

		if(!empty($event_date[1])) {
			$event[6] = $event_date[1];
			$event["event_end_datetime"] = $event_date[1];
		}

		return $event;
	}

	function populateEvent($event)
	{
		if(!empty($event["event_start_datetime"]))
			$start = strtotime($event["event_start_datetime"]);
	    else
			$start = 0;

		if(!empty($event["event_end_datetime"]))
			$end = strtotime($event["event_end_datetime"]);
	    else
			$end = 0;

		// Defines the next month
		if($this->mh+1>12)
		{
			$next_mh = 1;
			$next_yr = $this->yr+1;
		}
		else
		{
			$next_mh = $this->mh+1;
			$next_yr = $this->yr;
		}

		// Defines useful dates
		$time_start      = mktime(0, 0, 0, $this->mh, 1, $this->yr);
		$time_end        = strtotime("+1 month -1 day", $time_start);

		if($start>=$time_start & $start<=$time_end)
		{
			if($end<=$time_end)
			{
				$ds = date("d", $start);
				$de = date("d", $end);
			}
			else
			{
				$ds = date("d", $start);
				$de = $this->daysinmonth;
			}

		}
		elseif($end>=$time_start & $end<=$time_end)
		{
			$ds = 1;
			$de = date("d", $end);
		}
		elseif($start<$time_start & $end>$time_end)
		{
			$ds = 1;
			$de = $this->daysinmonth;
		}

		if(isset($ds) & isset($de))
		{
			for($d = $ds; $d <= $de; $d++)
			{
				if(!empty($event["event_frequency"]))
				{
					if($event["event_frequency"]==3) // Weekly
					{
						$weekday        = date("w", mktime(0, 0, 0, $this->mh, $d, $this->yr))+1;
						$start_weekday = $event["event_start_weekday"];

						if(empty($event["event_end_weekday"]))
							$end_weekday = $event["event_start_weekday"];
						else
							$end_weekday = $event["event_end_weekday"];

						if($start_weekday<=$weekday & $end_weekday>=$weekday)
							array_push($this->calendar[$d-1]['content'], $event);
					}
					elseif ($event["event_frequency"]==9) { // Monthly
						$start_day = $event["event_start_day"];

						if(empty($event["event_end_day"]))
							$end_day = $event["event_start_day"];
						else
							$end_day = $event["event_end_day"];

						if($start_day<=$d & $end_day>=$d)
							array_push($this->calendar[$d-1]['content'], $event);
					}
					elseif ($event["event_frequency"]==10) { // Yearly
						$start_day = $event["event_start_day"];

						if(empty($event["event_end_day"]))
							$end_day = $event["event_start_day"];
						else
							$end_day = $event["event_end_day"];

						if($start_day<=$d & $end_day>=$d & $event["event_start_month"]<=$this->mh & $event["event_end_month"]>=$this->mh)
							array_push($this->calendar[$d-1]['content'], $event);
					}
					else // Daily
						array_push($this->calendar[$d-1]['content'], $event);
				}
				else
					array_push($this->calendar[$d-1]['content'], $event);
			}
		}
	}

	// Calculate starting date
	function calculateDate($event){
		$sec[0] = (!empty($event['event_start_sec'])) ? $event['event_start_sec'] : "01";
		$min[0] = (!empty($event['event_start_min'])) ? $event['event_start_min'] : "01";
		$hour[0] = (!empty($event['event_start_hour'])) ? $event['event_start_hour'] : "01";
		$day[0] = (!empty($event['event_start_day'])) ? $event['event_start_day'] : 1;
		$month[0] = (!empty($event['event_start_month'])) ? $event['event_start_month'] : $this->mh;
		$year[0] = (!empty($event['event_start_year'])) ? $event['event_start_year'] : $this->yr;

		$sec[1] = (!empty($event['event_end_sec'])) ? $event['event_end_sec'] : "01";
		$min[1] = (!empty($event['event_end_min'])) ? $event['event_end_min'] : "01";
		$hour[1] = (!empty($event['event_end_hour'])) ? $event['event_end_hour'] : "01";
		$day[1] = (!empty($event['event_end_day'])) ? $event['event_end_day'] : $this->daysinmonth;
		$month[1] = (!empty($event['event_end_month'])) ? $event['event_end_month'] : $this->mh;
		$year[1] = (!empty($event['event_end_year'])) ? $event['event_end_year'] : $this->yr;

		for($i = 0; $i<=1; $i++)
			$event_date[$i] = mktime($hour[$i], $min[$i], $sec[$i], $month[$i], $day[$i], $year[$i]);

		// Redefining the end date so that it matches the events
		if(isset($event["event_frequency"]) && $event["event_frequency"]>0) {

			$freq = $event["event_frequency"];
			if($freq==3 || $freq==1) {
				$event_date[0] = mktime(0, 0, 0, $this->mh, 1, $this->yr);
				$event_date[1] = strtotime("+1 month -1 day", $event_date[0]);
			}
		}

		if(!empty($event["event_start_datetime"]))
			$event_date[0] = ($event_date[0]>=strtotime($event["event_start_datetime"])) ? $event_date[0] : strtotime($event["event_start_datetime"]);

		if(!empty($event["event_end_datetime"]))
			$event_date[1] = ($event_date[1]>=strtotime($event["event_end_datetime"])) ? $event_date[1] : strtotime($event["event_end_datetime"]);

		$event_date[0] = ($event_date[0]<=mktime(0, 0, 0, $this->mh, 1, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, 1, $this->yr)) : date("Y-n-j G:i:s", $event_date[0]);
		$event_date[1] = ($event_date[1]<=strtotime("+1 month", $event_date[0])) ? date("Y-n-j G:i:s", strtotime("+1 month", $event_date[0])) : date("Y-n-j G:i:s", $event_date[1]);

		if(empty($event['event_frequency']) && isset($event)) {
			$event_date[0] = $event[5];//$event["event_start_datetime"];
			$event_date[1] = $event[12];//$event["event_end_datetime"];
		}

		return $event_date;

	}
}
