<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Event {

	var $event_id, $db, $query, $result, $temp, $event_activity_type, $date;

	function Event($event_id = null) {
		$this->event_id = $event_id;
	}

	/*
	* getEvent
	* Tom Calthrop 7th April 2004
	*/
	function getEvent() {

		$query = "
			SELECT e.*, u.user_nic, u.user_id, u.user_hometown,
			u.user_create_datetime
			FROM " . $this->db->prefix . "_event e
			LEFT join " . $this->db->prefix . "_user u ON e.user_id=u.user_id
			where
			e.event_id=" . $this->event_id
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = $result->fields;

			$temp['display_event_start_datetime'] = $this->date->formatDate($temp['event_start_datetime']);
			$temp['display_event_end_datetime'] = $this->date->formatDate($temp['event_end_datetime']);
			$temp['display_user_create_datetime'] = $this->date->formatDate($temp['user_create_datetime']);

			if (!isset($this->thumb)) {
			    $this->thumb = "";
			}

			if (isset($temp['event_image_id'])) {
				$temp['image'] = $this->image->getImage($temp['event_image_id'], $this->thumb);
			}

			$result->Close();
			return $temp;

		}
	} //EO getEvent


	/*
	* getLatestEvent
	* Erik Sundelöf 3 June 2004
	*/
	function getLatestEvent() {

		$query = "
				SELECT e.*, u.user_nic, u.user_id, u.user_hometown,
				u.user_create_datetime
				FROM " . $this->db->prefix . "_event e
				LEFT join " . $this->db->prefix . "_user u ON e.user_id=u.user_id
				ORDER BY e.event_create_datetime DESC LIMIT 0, 1"
				;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = $result->fields;

			$temp['display_event_start_datetime'] = $this->date->formatDate($temp['event_start_datetime']);
			$temp['display_event_end_datetime'] = $this->date->formatDate($temp['event_end_datetime']);
			$temp['display_user_create_datetime'] = $this->date->formatDate($temp['user_create_datetime']);

			if (!isset($this->thumb)) {
			    $this->thumb = "";
			}

			if (isset($temp['event_image_id'])) {
				$temp['image'] = $this->image->getImage($temp['event_image_id'], $this->thumb);
			}

			$result->Close();
			return $temp;

		}
	} //EO getLatestEvent



	/*
	* getActivities
	* Tom Calthrop 7th April 2004
	*/
	function getActivities() {

		$query = "
			SELECT a.activity_id, a.activity_description, a.activity_start_datetime,
			a.activity_title, a.activity_total_required, a.event_id
			FROM " . $this->db->prefix . "_activity a
			WHERE
			a.event_id=" . $this->event_id . "
			order by a.activity_title"
			;

		if (isset($this->limit)) {
		    $query .= "limit " . $this->limit;
		}
		//echo $query;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['activity_start_datetime'] = $this->date->formatDate($temp1['activity_start_datetime']);

				$temp1['activity_applicants'] = $this->countActivityApplicants($temp1['activity_id']);

				$temp1['activity_confirmed'] = $this->countActivityConfirmed($temp1['activity_id']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
	} //EO getActivities();


	/*
	* getActivity
	* Tom Calthrop 7th April 2004
	*/
	function getActivity($activity_id) {

		$query = "
			SELECT a.*
			FROM " . $this->db->prefix . "_activity a
			WHERE
			a.activity_id=" . $activity_id
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = $result->fields;

			$temp['display_activity_start_datetime'] = $this->date->formatDate($temp['activity_start_datetime']);

			$temp['activity_applicants'] = $this->countActivityApplicants($temp['activity_id']);

			$temp['activity_confirmed'] = $this->countActivityConfirmed($temp['activity_id']);


			$result->Close();

			return $temp;
		}
	} //EO activityDetails();


	/*
	* countActivityApplicants
	* Tom Calthrop 7th April 2004
	*/
	function countActivityApplicants($activity_id) {

		$query = "
			SELECT count(au.activity_user_id) as total
			FROM " . $this->db->prefix . "_activity_user au
			WHERE
			au.activity_id=" . $activity_id
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();

			return $result->fields['total'];

		}
	} //EO countActivityApplicants();


	/*
	* countActivityConfirmed
	* Tom Calthrop 7th April 2004
	*/
	function countActivityConfirmed($activity_id) {

		$query = "
			SELECT count(au.activity_user_id) as total
			FROM " . $this->db->prefix . "_activity_user au
			WHERE
			au.activity_user_status=" . $this->event_activity_type['confirmed'] . " and
			au.activity_id=" . $activity_id
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$result->Close();

			return $result->fields['total'];

		}
	} //EO countActivityConfirmed();




	/*
	* eventList
	* Tom Calthrop 27th April 2004
	*/
	function getEvents($type, $id) {

		if ($type == "user") {

			$query = "
				SELECT e.*
				FROM " . $this->db->prefix . "_event e
				WHERE
				e.group_id is NULL and
				e.user_id=" . $id
			;
		}
		elseif ($type == "group") {

			$query = "
				SELECT e.*
				FROM " . $this->db->prefix . "_event e
				WHERE
				e.group_id=" . $id
			;
		}
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['event_start_datetime'] = $this->date->formatDate($temp1['event_start_datetime']);
				$temp1['event_end_datetime'] = $this->date->formatDate($temp1['event_end_datetime']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
	} //EO eventList();


	/*
	* updateEvent
	* Tom Calthrop 2nd May 2004
	*/
	function updateEvent($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (isset($data['event_frequency']) && $data['event_frequency'] > 0) {
			$frequency = $data['event_frequency'];
		}
		else {
			$frequency = "null";
		}

		if (empty($_POST["no_start_datetime"]))
		    $event_start_datetime = "'" . $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00'";
		else
			$event_start_datetime = "null";

		if (empty($_POST["no_end_datetime"]))
			$event_end_datetime = "'" . $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00'";
		else
			$event_end_datetime = "null";


		if (isset($data['event_image_id'])) {
			$event_image_id = $data['event_image_id'];
		}
		else {
			$event_image_id = "null";
		}

		if (isset($data['group_id']) && $data['group_id'] > 0) {
			$group_id = $data['group_id'];
		}
		else {
			$group_id = "null";
		}

		if (isset($data['event_type_id'])) {
			$event_type_id = $data['event_type_id'];
		}
		else {
			$event_type_id = "null";
		}

		if (isset($data['forum_subject_id']) && $data['forum_subject_id'] > 0) {
			$forum_subject_id = $data['forum_subject_id'];
		}
		else {
			$forum_subject_id = "null";
		}

		if (isset($data['publish_id'])) {
			$publish_id = $data['publish_id'];
		}
		else {
			$publish_id = "null";
		}

		if (isset($data['level_id'])) {
			$level_id = $data['level_id'];
		}
		else {
			$level_id = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_event SET
			group_id=" . $group_id . ",
			event_edit_datetime =" . $datetime . ",
			user_id_edit ='" . $user_id . "',
			event_start_datetime=" . $event_start_datetime . ",
			event_end_datetime =" . $event_end_datetime . ",
			event_frequency =" . $frequency . ",
			event_title='" . $data['event_title'] . "',
			event_type_id=" . $event_type_id . ",
			event_description='" . $data['event_description'] . "',
			event_body='" . $data['event_body'] . "',
			event_location='" . $data['event_location'] . "',
			forum_subject_id=" . $forum_subject_id . ",
			event_image_id=" . $event_image_id . ",
			level_id=" . $level_id . ",
			publish_id=" . $publish_id . "
			WHERE event_id=" . $data['event_id']
		;

		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;

	}


	/*
	* setEventRepeat
	* Erik Sundelöf 3nd June 2004
	*/
	function setEventRepeat($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if($_POST["event_frequency"]==9) {
			$_POST['event_start_month'] = 0;
			$_POST['event_end_month']   = 0;
			$data['event_start_weekday'] = 0;
			$data['event_end_weekday']  = 0;
		}
		elseif($_POST["event_frequency"]==10) {
			$data['event_start_weekday'] = 0;
			$data['event_end_weekday']  = 0;
		}
		elseif($_POST["event_frequency"]==3) {
			$_POST['event_start_day'] = 0;
			$_POST['event_end_day']   = 0;
			$_POST['event_start_month'] = 0;
			$_POST['event_end_month']   = 0;
		}

		if (empty($_POST["no_start_datetime"]))
		    $event_start_datetime = "'" . $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00'";
		else
			$event_start_datetime = "null";

		if (empty($_POST["no_end_datetime"]))
			$event_end_datetime = "'" . $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00'";
		else
			$event_end_datetime = "null";

		$query = "
			UPDATE " . $this->db->prefix . "_event SET
			event_edit_datetime =" . $datetime . ",
			user_id_edit ='" . $user_id . "',
			event_start_datetime=" . $event_start_datetime . ",
			event_end_datetime =" . $event_end_datetime . ",
			event_start_day=" . (int) $_POST['event_start_day'] . ",
			event_start_month=" . (int) $_POST['event_start_month'] . ",
			event_end_day=" . (int) $_POST['event_end_day'] . ",
			event_end_month=" . (int) $_POST['event_end_month'] . ",
			event_start_weekday='" . $data['event_start_weekday'] . "',
			event_end_weekday='" . $data['event_end_weekday'] . "'
			WHERE event_id=" . $data['event_id']
		;

		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;

	}

	/*
	* insertEvent
	* Tom Calthrop 11th April 2004
	*/
	function insertEvent ($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (isset($data['event_frequency']) && $data['event_frequency'] > 0) {
			$frequency = $data['event_frequency'];
		}
		else {
			$frequency = "null";
		}

		if (empty($_POST["no_start_datetime"]))
		    $event_start_datetime = "'" . $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00'";
		else
			$event_start_datetime = "null";

		if (empty($_POST["no_end_datetime"]))
			$event_end_datetime = "'" . $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00'";
		else
			$event_end_datetime = "null";

		if (isset($data['event_image_id'])) {
			$event_image_id = $data['event_image_id'];
		}
		else {
			$event_image_id = "null";
		}

		if (isset($data['group_id']) && $data['group_id'] > 0) {
			$group_id = $data['group_id'];
		}
		else {
			$group_id = "null";
		}

		if (isset($data['event_type_id'])) {
			$event_type_id = $data['event_type_id'];
		}
		else {
			$event_type_id = "null";
		}

		if (isset($data['forum_subject_id'])) {
			$forum_subject_id = $data['forum_subject_id'];
		}
		else {
			$forum_subject_id = "null";
		}

		if (isset($data['publish_id'])) {
			$publish_id = $data['publish_id'];
		}
		else {
			$publish_id = "null";
		}

		if (isset($data['level_id'])) {
			$level_id = $data['level_id'];
		}
		else {
			$level_id = "null";
		}

		$query = "
			INSERT INTO " . $this->db->prefix . "_event
			(group_id, event_create_datetime, user_id, event_start_datetime,
			event_end_datetime, event_frequency, event_title, event_type_id, event_description,
			event_body, event_location, forum_subject_id, event_image_id,
			level_id, publish_id
			) VALUES (
			" . $group_id . ",
			" . $datetime . ",
			" . $user_id . ",
			" . $event_start_datetime . ",
			" . $event_end_datetime . ",
			" . $frequency . ",
			'" . $data['event_title'] . "',
			" . $event_type_id . ",
			'" . $data['event_description'] . "',
			'" . $data['event_body'] . "',
			'" . $data['event_location'] . "',
			" . $forum_subject_id . ",
			" . $event_image_id . ",
			" . $level_id . ",
			" . $publish_id . "
			)"
		;
		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 2);
			$result->Close();
		}

		return $state;
	}//insertEvent



	/*
	* deleteEvent
	* Tom Calthrop 11th April 2004
	*/
	function deleteEvent ($event_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_event
			WHERE event_id=" .  $event_id
		;

		//echo $query;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 4);
			$result->Close();
		}

		return $state;
	}//EO deleteEvent


	/*
	* insertActivity
	* Tom Calthrop 3rd May 2004
	*/
	function insertActivity ($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$activity_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$activity_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";

		if (isset($data['activity_approved'])) {
			$activity_approved  = $data['activity_approved'];
		}
		else {
			$activity_approved  = "null";
		}

		if (isset($data['activity_total_required'])) {
			$activity_total_required = $data['activity_total_required'];
		}
		else {
			$activity_total_required = "0";
		}

		$query = "
			INSERT INTO " . $this->db->prefix . "_activity
			(user_id, event_id, activity_title, activity_description, activity_start_datetime,
			activity_end_datetime, activity_create_datetime, activity_approved,
			activity_total_required
			) VALUES (
			'" . $user_id . "',
			" . $data['event_id'] . ",
			'" . $data['activity_title'] . "',
			'" . $data['activity_description'] . "',
			'" . $activity_start_datetime . "',
			'" . $activity_end_datetime . "',
			" . $datetime . ",
			" . $activity_approved . ",
			" . $activity_total_required . "
			)"
		;
		//echo "<br>" . $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 2);
			$result->Close();
		}

		return $state;
	}//insertActivity




	/*
	* updateActivity
	* Tom Calthrop 2nd May 2004
	*/
	function updateActivity($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$activity_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$activity_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";

		if (isset($data['activity_approved'])) {
			$activity_approved  = $data['activity_approved'];
		}
		else {
			$activity_approved  = "null";
		}

		if (isset($data['activity_total_required'])) {
			$activity_total_required = $data['activity_total_required'];
		}
		else {
			$activity_total_required = "0";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_activity SET
			user_id_edit='" . $user_id . "',
			activity_title='" . $data['activity_title'] . "',
			activity_description='" . $data['activity_description'] . "',
			activity_start_datetime='" . $activity_start_datetime . "',
			activity_end_datetime='" . $activity_end_datetime . "',
			activity_edit_datetime=" . $datetime . ",
			activity_approved=" . $activity_approved . ",
			activity_total_required=" . $activity_total_required . "
			WHERE activity_id=" . $data['activity_id']
		;
		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;

	}//EO updateActivity();



	/*
	* deleteActivity
	* Tom Calthrop 11th April 2004
	*/
	function deleteActivity ($activity_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_activity
			WHERE activity_id=" .  $activity_id
		;
		//echo $query;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 4);
			$result->Close();
		}

		return $state;
	}//EO deleteActivity


	/*
	* getActivityApplicants
	* Tom Calthrop 7th April 2004
	*/
	function getActivityApplicants($activity_id) {

		$query = "
			SELECT au.*, u.user_nic, u.user_hometown, u.user_create_datetime
			FROM " . $this->db->prefix . "_activity_user au, " . $this->db->prefix . "_user u
			WHERE
			au.user_id=u.user_id and
			au.activity_id=" . $activity_id
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['user_create_datetime'] = $this->date->formatDate($temp1['user_create_datetime']);
				$temp1['activity_user_create_datetime'] = $this->date->formatDate($temp1['activity_user_create_datetime']);



				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
	} //EO getActivityApplicants();



	/*
	* updateActivityApplicants
	* Tom Calthrop 7th April 2004
	*/
	function updateActivityApplicants($activity_id, $user_arr, $activity_user_status_arr)
	{
		$rownums = count ($user_arr);

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				UPDATE " . $this->db->prefix . "_activity_user SET
				activity_user_status=" . $activity_user_status_arr[$i] . "
				WHERE
				user_id = " . $user_arr[$i] . " and
				activity_id=" . $activity_id
			;

			$result = $this->db->Execute($query);

			if (!$result) {
				$state  = array('error', 1, $this->db->ErrorMsg());
			}
		}

		if (!isset($state)) {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;
	}//EO updateActivityApplicants();



	/*
	* confirmNoActivityUsersConfirmed
	* check whether any activities are set to confirmed status. If they are not, return true
	* Tom Calthrop 2nd May 2004
	*/
	function confirmNoActivityUsersConfirmed($activities, $activity_user_status) {

		foreach($activities as $key => $r):
			$activity_users = $this->getActivityApplicants($r['activity_id']);

			foreach($activity_users as $key => $i):
				if ($i['activity_user_status'] == $activity_user_status) {
					return false;
				    break;

				}
			endforeach;

			unset($activity_users);

		endforeach;

		return true;
	}//EO confirmNoActivityUsersConfirmed



	/*
	* getUserActivity
	* Tom Calthrop 7th April 2004
	*/
	function getUserActivity($activity_id, $user_id) {

		$query = "
			SELECT au.*
			FROM " . $this->db->prefix . "_activity_user au
			WHERE
			au.user_id=" . $user_id . " and
			au.activity_id=" . $activity_id
			;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$temp = $result->fields;
			$temp['activity_user_create_datetime'] = $this->date->formatDate($temp['activity_user_create_datetime']);

			$result->Close();

			return $temp;
		}
	} //EO getUserActivity();



	/*
	* updateActivityApplicants
	* Tom Calthrop 7th April 2004
	*/
	function updateActivityUserStatus($activity_user_id, $user_id, $activity_user_status) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			UPDATE " . $this->db->prefix . "_activity_user SET
			activity_user_status=" . $activity_user_status . ",
			activity_user_edit_datetime=" . $datetime . ",
			user_id_edit=" . $user_id . "
			WHERE
			activity_user_id=" . $activity_user_id
		;
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;
	}//EO updateActivityApplicants();




	/*
	* insertActivityUserStatus
	* Tom Calthrop 7th April 2004
	*/
	function insertActivityUserStatus($activity_id, $user_id, $activity_user_status) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_activity_user
			(activity_id, activity_user_status, activity_user_create_datetime, user_id) VALUES (
			" . $activity_id . ",
			" . $activity_user_status . ",
			" . $datetime . ",
			" . $user_id . "
			)"
		;
		//echo $query;
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 2);
			$result->Close();
		}

		return $state;
	}//EO insertActivityUserStatus();

	
	/*
	* updateBookmark
	* bookmark this item or recommend this item
	* Tom Calthrop 23rd Nov 2004
	*/
	function updateBookmark($bookmark_type) {
	
		if ($bookmark_type == "watch") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_event_bookmark 
				(user_id, event_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->event_id . ", 
				" . $this->node_id . ", 
				1)"
			;
		}
		elseif ($bookmark_type == "recommend") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_event_bookmark 
				(user_id, event_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->event_id . ", 
				" . $this->node_id . ", 
				2)"
			;
		}
		elseif ($bookmark_type == "unwatch") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_event_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				event_id=" . $this->event_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=1"
			;
		}
		elseif ($bookmark_type == "unrecommend") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_event_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				event_id=" . $this->event_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=2"
			;
		}
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$result->Close();
		}
	} //EO updateBookmark();
	
	
	/*
	* GET BOOKMARKS
	* Tom Calthrop 23rd Nov 2004
	*/
	function getBookmarks () {
	
		$query = "
			SELECT bookmark_type  
			FROM " . $this->db->prefix . "_event_bookmark
			WHERE
			event_id=" . $this->event_id . " and
			user_id=" . $this->user_id . " and
			node_id=" . $this->node_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			while (!$result->EOF) {
				if ($result->fields['bookmark_type'] == 1) {
				    $temp['watch'] = 1;
				}
				
				if ($result->fields['bookmark_type'] == 2) {
				    $temp['recommend'] = 1;
				}

				$result->MoveNext();
			}
		
			$result->Close();
			
			if (isset($temp)) {
			    return $temp;
			}
			
		}
	} //EO getBookmarks();
}

?>
