<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
$core = "group";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Poll.class.php');


//append language setup
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');


//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$search_genre_id = $_POST['search_genre_id'];
	$output_search_results = searchItems($search, $search_genre_id, $c_node['group_status']['active']);
	$display = "search";
}
elseif (isset($_REQUEST['my_groups'])) {
	$output_my_groups = getMyGroups($c_node['group_status']['active']);
	$display = "mygroups";
}
elseif (isset($_REQUEST['discussions'])) {
	$discussions_recommended = getRecommendedSubjects($c_node['group_status']['active'], $c_node['group_type']['node_home']);
	$discussions_latest = getLatestSubjects($c_node['group_status']['active']);

	$display = "discussions";
}
else {
	$lastest_groups = getLatestGroups($c_node['group_status']['active']);

	if (isset($lastest_groups) && count($lastest_groups) > 2) {
	    $groups_featured = array_slice($lastest_groups, 0, 2);
		$lastest_groups = array_slice($lastest_groups, 2);
	}

	$recommended_groups = getRecommendedGroups($c_node['group_status']['active'], $c_node['group_type']['node_home']);
}


//get featured images
if (isset($groups_featured[0])) {
	if ($groups_featured[0]['group_image_id']) {
		$groups_featured[0]['image'] = $image->getImage($groups_featured[0]['group_image_id'], 't2', 'group', $groups_featured[0]['group_id']);
	}
	else {
		$groups_featured[0]['image']['image'] = "group/no_group_t2.gif";
		$groups_featured[0]['image']['image_title'] = $groups_featured[0]['group_title'];
	}
}

if (isset($groups_featured[1])) {
	if ($groups_featured[1]['group_image_id']) {
		$groups_featured[1]['image'] = $image->getImage($groups_featured[1]['group_image_id'], 't2', 'group', $groups_featured[1]['group_id']);
	}
	else {
		$groups_featured[1]['image']['image'] = "group/no_group_t2.gif";
		$groups_featured[1]['image']['image_title'] = $groups_featured[1]['group_title'];;
	}

}

//move to template
if (isset($discussions_latest)) {
	$body->set('discussions_latest', $discussions_latest);
}

if (isset($discussions_recommended)) {
	$body->set('discussions_recommended', $discussions_recommended);
}

if (isset($lastest_groups)) {
	$body->set('latest_groups', $lastest_groups);
}

if (isset($groups_featured)) {
	$body->set('groups_featured', $groups_featured);
}

if (isset($recommended_groups)) {
	$body->set('recommended_groups', $recommended_groups);
}

if (isset($output_my_groups)) {
	$body->set('my_groups', $output_my_groups);
}

if (isset($output_search_results)) {
	$body->set('search_results', $output_search_results);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (isset($search_genre_id)) {
	$body->set('search_genre_id', $search_genre_id);
}


$template_pageLink = "groups";
include "inc/footer.inc.php";


/*
* searchItems
* Tom Calthrop 7th April 2004
*/
function searchItems ($search, $search_genre_id, $group_status) {

	global $db, $c_node, $me, $image, $parser, $log;

	$query = "
		SELECT g.group_id, g.group_title, g.group_synopsis, g.genre_id,
		g.group_image_id, g.group_from_age, g.group_to_age
		FROM " . $db->prefix . "_group g
		WHERE
		(g.group_title like '%" . $search . "%' or
		g.group_synopsis like '%" . $search . "%') and
		g.group_status=" . $group_status . " and
		(g.group_type=" . $c_node['group_type']['open'] . " or
		g.group_type=" . $c_node['group_type']['registration_required'] . ")"
		;

	if($search_genre_id != 0) {

		$query .= "and g.genre_id=" . $search_genre_id;
	}

	$query .= " order by g.group_title";

	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if (isset($temp1['group_image_id'])) {
			    $temp1['image'] = $image->getImage($temp1['group_image_id'], 't2', 'group', $temp1['group_id']);
			}

			//format search results
			$temp1['group_synopsis'] = searchTextFormat($search, $temp1['group_synopsis']);
			$temp1['group_title'] = searchTextFormat($search, $temp1['group_title']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}
} //EO searchItems();


/*
* getMyGroups
* Tom Calthrop 7th April 2004
*/
function getMyGroups ($group_status) {

	global $db, $me, $image, $c_node, $log;

	$query = "
		SELECT gm.level_id, g.group_title, g.group_synopsis,
		g.group_id, g.group_image_id, g.group_type, g.genre_id 
		FROM " . $db->prefix . "_group_member gm
		LEFT JOIN " . $db->prefix . "_group g on gm.group_id=g.group_id
		WHERE
		gm.user_id =" . $me['user_id'] . " and
		g.group_status=" . $group_status . " and
		gm.level_id>=". $c_node['user_level_id']['member'] . "
		order by g.group_title"
		;
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if (isset($temp1['group_image_id'])) {
			    $temp1['image'] = $image->getImage($temp1['group_image_id'], 't2', 'group', $temp1['group_id']);
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();
		return $temp;
		
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}
}


/*
* getLatestGroups
* Tom Calthrop 7th April 2004
*/
function getLatestGroups ($group_status) {

	global $db, $me, $c_node, $log;

	$query = "
		SELECT g.group_title, g.group_synopsis, g.group_id, g.genre_id, g.group_type,
		g.group_create_datetime, g.group_image_id, g.group_from_age, g.group_to_age
		FROM " . $db->prefix . "_group g
		WHERE
		g.group_status=" . $group_status . " and
		(g.group_type=" . $c_node['group_type']['open'] . " or
		g.group_type=" . $c_node['group_type']['registration_required'] . ")
		order by g.group_create_datetime desc limit 20"
		;

	$result = $db->Execute($query);
	
	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();
		return $temp;
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}
}//EO getLatestGroups();



/*
* getRecommendedGroups
* Tom Calthrop 7th April 2004
*/
function getRecommendedGroups ($group_status, $group_level) {

	global $db, $me, $c_node, $log;

	$query = "
		SELECT g.group_title, g.group_synopsis, g.group_id, g.genre_id,
		g.group_create_datetime, g.group_image_id, g.group_from_age, g.group_to_age
		FROM " . $db->prefix . "_group g
		WHERE
		g.group_status=" . $group_status . " and
		(g.group_type=" . $c_node['group_type']['open'] . " or
		g.group_type=" . $c_node['group_type']['registration_required'] . ") and
		g.level_id=" . $group_level . "
		order by g.group_create_datetime, g.group_title desc limit 20"
		;

	$result = $db->Execute($query);
	
	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();
		return $temp;
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}

}//EO getRecommendedGroups();




/*
* getRecommendedSubjects
* Tom Calthrop 7th April 2004
*/
function getRecommendedSubjects ($group_status, $level_id) {

	global $db, $me, $image, $c_node, $poll, $log;
	$query = "
				SELECT s.subject_title, s.subject_id, s.subject_body,
				s.poll_id, t.topic_body, t.topic_id, g.group_id
				FROM " . $db->prefix . "_forum_subject s
				RIGHT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
				RIGHT JOIN " . $db->prefix . "_forum_section fs ON t.section_id=fs.section_id
				RIGHT JOIN " . $db->prefix . "_group g ON fs.group_id=g.group_id
				where
				g.group_status=" . $group_status . " and
				(g.group_type=" . $c_node['group_type']['open'] . " or
				g.group_type=" . $c_node['group_type']['registration_required'] . ") and
				s.level_id=" . $level_id . "
				order by s.subject_title desc"
				;

	$result = $db->SelectLimit($query, 20);
	
	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['display_subject_body'] = nl2br($temp1['subject_body']);

			if (isset($temp1['poll_id']) && $temp1['poll_id']>0) {
				$poll->poll_id = $temp1['poll_id'];
		    	$temp1['poll'] = $poll->getPoll();
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();
		return $temp;
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}
} //EO recommendedSubjects();



/*
* getLatestSubjects
* Tom Calthrop 7th April 2004
*/
function getLatestSubjects ($group_status) {

	global $db, $me, $image, $c_node, $poll, $log;
	$query = "
		SELECT s.subject_title, s.subject_id, s.subject_body, s.poll_id,
		t.topic_body, t.topic_id, s.subject_create_datetime, g.group_id
		FROM " . $db->prefix . "_forum_subject s
		RIGHT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
		RIGHT JOIN " . $db->prefix . "_forum_section fs ON t.section_id=fs.section_id
		RIGHT JOIN " . $db->prefix . "_group g ON fs.group_id=g.group_id
		where
		g.group_status=" . $group_status . " and
		(g.group_type=" . $c_node['group_type']['open'] . " or
		g.group_type=" . $c_node['group_type']['registration_required'] . ")
		order by s.subject_create_datetime desc"
	;
	//echo $query;
	$result = $db->SelectLimit($query, 20);
	
	if (isset($result->fields)) {
	    
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['display_subject_body'] = nl2br($temp1['subject_body']);

			if (isset($temp1['poll_id']) && $temp1['poll_id'] > 0) {
				$poll->poll_id = $temp1['poll_id'];
		    	$temp1['poll'] = $poll->getPoll();
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();
		return $temp;
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}
} //EO getLatestSubjects();

?>
