<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
$section = "message";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Wiki/Wiki.php');


// Setting statistics
$im->setStatistics();
$output_message_statistics = $im->getStatistics();


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");

//stop WIKI style links in the Blog
$wiki->disableRule('wikilink');




// Handling the message choices
if (!isset($_REQUEST['message_id'])) {
	header("Location: msg_list.php?". $_SERVER["QUERY_STRING"] . "&amp;" . SID);
	exit;
}
else {
	if (isset($_POST['delete_messages'])) {
		$im->deleteMessages(array($_POST['message_id']));
		header("Location: msg_list.php?". $_SERVER["QUERY_STRING"] . "&amp;" . SID);
		exit;
	}
	elseif (isset($_REQUEST['reply'])) {
		header("Location: msg_compose.php?reply=1&amp;message_id=" . $_REQUEST['message_id'] . "&amp;" . SID);
		exit;
	}
	else
	{

		$message = new Message($db, $_REQUEST['message_id']); // create message

		// Getting the status from "query_string"....
		if (isset($_REQUEST['set_unread_messages'])) {
			$status = $c_node['message_status_unread'];
		}
		else {
			$status = $c_node['message_status_read'];
		}
		$message->user_id=$user_id; //added by tom to stop message class complaining 21st april 2004

		$message->setStatus($status);                    // set status of the message
		$message->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);
		$output_message = $message->getMessage();        // get message

		$output_message['message_body'] = $wiki->transform($output_message['message_body'], 'Xhtml');
	}
}

//move to template
$body->set('message', $output_message);
if(isset($message))
	$body->set('message_box', $message->getMessageBox($output_message["message_box"]) );
$body->set('message_statistics', $output_message_statistics);
$body->set('message_status_read', $c_node['message_status_read']);
$body->set('message_status_unread', $c_node['message_status_unread']);

$template_pageLink = "message";
include "inc/footer.inc.php";

?>
