<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";


if (isset($_REQUEST['library_id'])) {
	$library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}


require_once($c_node['class_dir'] . 'Library/Library.class.php');
require_once($c_node['class_dir'] . 'Wiki/Wiki.php');


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_user_publish.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


$user_id = $me['user_id'];


//setup Image
$image->thumb = "t1";


//setup Library
$library = new Library();
$library->type = "user";
$library->db = $db;
$library->image = $image;
$library->user_id = $me['user_id'];
$library->library_publish = $c_node['user_publish']['all'];


//wiki setup
$wiki =& new Text_Wiki();
$wiki->rulePath = $c_node['class_dir'] . "Wiki/Rule/";
$wiki->setRuleConf('wikilink', 'view_url', 'my_library.php?user_id=' . $user_id . '&page=');
$wiki->setRuleConf('wikilink', 'new_url', 'my_library_edit.php?user_id=' . $user_id . '&page=');
$wiki->setRuleConf('image', 'base', $c_node['base_path'] . "user/" . $user_id . "/");



// set an array of pages that exist in the library
//$pages = array('HomePage', 'AnotherPage', 'SomeOtherPage');
$pages = $library->getPages();
$wiki->setRuleConf('wikilink', 'pages', $pages);


//get images for default image selections
$output_images = $image->getImages('user', $user_id, 't2');


if (isset($_POST['data'])) {//post data received
    $data = $_POST['data'];

	$data['library_body'] = stripslashes($data['library_body']);
	$data['library_body_display'] = $wiki->transform($data['library_body'], 'Xhtml');

	$data['library_synopsis'] = stripslashes(htmlspecialchars($data['library_synopsis']));

	$data['library_title'] = stripslashes(htmlspecialchars($data['library_title']));

	$data['library_page_name'] = $page;

	if (isset($_POST['preview_library'])) {
		$data['library_body'] = htmlspecialchars($data['library_body']);

		$output_library = $data;

		$display = "preview_library";
	}
	elseif (isset($_POST['edit_library_again'])) {
		$output_library = $data;

		$display = "add_library";

	}
	elseif (isset($_POST['insert_library'])) {
		$insert = $library->insertLibrary($data);
		if ($insert[0][0] == "success") {
			header("Location: my_library.php?page=" . $data['library_page_name'] . "&amp;" . SID);
			exit;
		}
		else {
		    $error = $insert;

			$output_library = $data;

			$display = "add_library";
		}
	}

}
elseif (isset($library_id)) {//if we have a library id we retrieve it
    $output_library = $library->getPageID($library_id);


	$display = "add_library";
}
elseif (isset($page)) {//else we assign the new page name
	$output_library = $library->getPageName($page);

	if (empty($output_library)) {
	    $output_library['library_page_name'] = $page;
		$output_library['library_default'] = null;
	}


	$display = "add_library";
}
else {
	$output_library = $library->getPageDefault();
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	$display = "view_library";
}


//handle new libraries - we've deleted all library items and now adding new one
if (empty($output_library['library_page_name'])) {
	$output_library['library_page_name'] = $lang['txt_wiki_default'];
	$output_library['library_default'] = 1;
}


$output_user['language_ids'] = $me['language_ids'];

//move to template
if (isset($output_library)) {
	$body->set('library', $output_library);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_images)) {
	$body->set('images', $output_images);
}

if (isset($pages)) {
	$body->set('pages', $pages);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

include "inc/footer.inc.php";

?>
