<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Guestbook.class.php');


//append language setup
require_once($languageArrayPath . 'arr_activity_user_status.lang.php');
require_once($languageArrayPath . 'arr_user_statistics.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');



//get my actvities
$output_today_events = getTodayEvents();

//setup statistics
$output_statistic = getStatistics();
$output_node_statistics = getNodeStatistics();


//setup guestbook
$guestbook = new Guestbook($me['user_id'], $db, $date, $image);
$guestbook->limit = 2;
$output_guestbooks = $guestbook->getGuestbooks();


//get user image
if (isset($output_user['user_image_id'])) {
	$output_user['image'] = $image->getImage($output_user['user_image_id'], 't1', 'user', $user_id);
}else {
	$output_user['image']['image'] = "user/no_user_t1.gif";
	$output_user['image']['image_title'] = $lang['err_no_image'];
}


//get lastest aquaintance
//setup social network
require_once($c_node['class_dir'] . 'User/Socialnetwork.class.php');
$sn = new Socialnetwork($me['user_id'], $db, $me['node_id']);
$sn->sn_arr = $_SESSION['s_social_network'];
$output_acquaintance = getAcquaintance();


//move to template
if (isset($output_today_events)) {
	$body->set('today_events', $output_today_events);
}

if (isset($output_guestbooks)) {
	$body->set('guestbooks', $output_guestbooks);
}

if (isset($output_node_statistics)) {
	$body->set('node_statistics', $output_node_statistics);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}

if (isset($output_acquaintance)) {
	$body->set('acquaintance', $output_acquaintance);
}

$template_pageLink = $lang['txt_my_overview'];
include "inc/footer.inc.php";


/*
* getStatistics
* Tom Calthrop 11th April 2004
*/
function getStatistics () {

	global $db, $me, $log;

	$query = "
		SELECT us.statistic_type_id, us.total
		FROM " . $db->prefix . "_user_statistic us
		where
		us.user_id=" . $me['user_id'] . "
		order by us.statistic_type_id"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getStatistics();


/*
* getNodeStatistics
* Tom Calthrop 11th April 2004
*/
function getNodeStatistics () {

	global $db, $me, $date, $error;

	$temp = array();

	//total users
	unset ($query,$result);
	$query = "
		SELECT count(user_id) as total_users
		FROM " . $db->prefix . "_user
		WHERE user_locked=2"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {
		$temp['total_users'] = $result->fields['total_users'];
		$result->Close();
	}

	//total groups
	unset ($query,$result);
	$query = "
		SELECT count(group_id) as total_groups 
		FROM " . $db->prefix . "_group"
	;
	
	$result = $db->Execute($query);

	if (isset($result->fields)) {
		$temp['total_groups'] = $result->fields['total_groups'];
		$result->Close();
	}
	else {
		$log[]  = array('error', 1, $query . "-" . $db->ErrorMsg(), null);
	}

	//total online now
	unset ($query,$result);
	$timestamp = $db->UserTimeStamp(mktime()-(60*15), "YmdHis"); //last 15 minutes

	$query = "
		SELECT count(user_id) as total_online_users
		FROM " . $db->prefix . "_user
		WHERE
		active_time > " . $timestamp
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {
		$temp['total_online_users'] = $result->fields['total_online_users'];
		$result->Close();
	}
	$datetime = date("Y-m-d H:i:s");
	$datetime = $date->formatDate($datetime);
	$temp['today'] = $datetime;

	return $temp;

}//EO getNodeStatistics();





/*
* getGuestbooks
* Tom Calthrop 7th April 2004
*/
function getGuestbooks ($user_id) {

	global $db, $date, $log;

	$query = "
		SELECT g.*, u.user_nic
		FROM br_guestbook g
		LEFT JOIN " . $db->prefix . "_user u on g.user_id=u.user_id
		WHERE g.user_id_guestbook=" . $user_id . "
		order by g.guestbook_create_datetime limit 2"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			//format date
			$temp1['guestbook_create_datetime'] = $date->formatDate($temp1['guestbook_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getGuestbooks();




/*
* getTodayEvents
* Tom Calthrop 11th April 2004
*/
function getTodayEvents () {

	global $db, $me, $image, $date, $error;

	$query = "
		SELECT a.activity_id, a.activity_title, a.activity_description,
		au.activity_user_status, a.activity_start_datetime, a.event_id
		FROM " . $db->prefix . "_activity_user au, " . $db->prefix . "_activity a
		where
		au.activity_id=a.activity_id and
		au.user_id=" . $me['user_id'] . "
		order by a.activity_start_datetime"
	;


	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			$temp1['activity_start_datetime'] = $date->formatDate($temp1['activity_start_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getTodayEvents();





/*
* getAcquaintance
* from social network array find newest registered user
* return it, their image and their relationship to me
* Tom Calthrop 11th April 2004
*/
function getAcquaintance () {

	global $db, $me, $sn, $image, $user, $lang;

	$newest_acquaintance_id = $sn->getNewestAcquaintance();


	if ($newest_acquaintance_id > 0) {
		$temp = $user->userDetails($newest_acquaintance_id);

		if ($temp['user_image_id']) {
			$temp['image'] = $image->getImage($temp['user_image_id'], 't1', 'user', $newest_acquaintance_id);
		}
		else {
			$temp['image']['image'] = "user/no_user_t1.gif";
			$temp['image']['image_title'] = $lang['err_no_image'];
		}

		$temp['online_status'] = $user->getStatus($newest_acquaintance_id);

		$temp['relationship'] = $sn->verifySocialNetwork($newest_acquaintance_id);

		if (isset($temp['relationship']['path'])) {
			foreach ($temp['relationship']['path'] as $key => $r):
				unset($temp1);
				$key_r = $key;
				$temp1 = $user->userDetails($r['user_id']);
				$temp['relationship']['path'][$key_r]['user_firstname'] = $temp1['user_firstname'];
			endforeach;
		}
		return $temp;
	}
}//EO getAcquaintance();

?>
