<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

//check user is node_admin
if ($output_user['level_id'] < $c_node['user_level_id']['node_administrator']) {
    header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');


if (isset($_POST['send_newsletter'])) {
	//to, language_id, message, subject
	
	//setup email
	require_once($c_node['class_dir'] . '/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 				$c_node['mail']['host'];
	$mail->Mailer = 			$c_node['mail']['mailer'];
	$mail->From = 				$c_node['mail']['default_address'];
	$mail->FromName = 			$c_node['mail']['from_name'];
	$mail->WordWrap = 			$c_node['mail']['wordwrap'];
	$mail->AddReplyTo($c_node['mail']['default_address'], $c_node['mail']['from_name']);
	$mail->language = 			"en";
	$mail->Mail->Priority = 	3;
	$mail->Mail->Encoding = 	"8bit";
	$mail->Mail->CharSet = 		"iso-8859-1";
    $mail->Mail->Subject =		$data['subject'];
	
	//send newsletter
	$sent_newletters = sendNewsletter($data);

	if ($sent_newletters[0][0] == "success") {
	    $success = $sent_newletters;

		if (isset($success[0][2])) {
		    $total_emails_sent = $success[0][2];
			unset($success[0][2]);
		}
	}
	else {
	    $error = $sent_newletters;
	}
}






//move to template
if (isset($total_emails_sent)) {
    $body->set('total_emails_sent', $total_emails_sent);
}

$body->set('language_id', $me['language_id']);

$body->set('total_members', getCountUsers(2));
$body->set('total_pending_members', getCountUsers(1));
$body->set('total_invited', getCountUsers());

include "inc/footer.inc.php";




/*
* sendInvite
* Tom Calthrop 7th April 2004
*/
function sendNewsletter($data) {

	global $db, $mail;

	$total_emails_sent = 0;
	
	//get the email addresses and firstnames
	if (isset($data['to']) && $data['to'] > 0) {
		//"to" level - 1=pending, 2=member - 
		$query = "
			SELECT u.user_firstname, u.user_email 
			FROM  " . $db->prefix . "_user u 
			WHERE 
			u.language_id=". $data['language_id'] . " and 
			u.user_locked=". $data['to']
		;
	}
	else {
		//if not 1 or 2 we go to the invite table
		$query = "
			SELECT u.invited_email 
			FROM " . $db->prefix . "_user_invited u "
		;
	}
	//echo $query;
	$result = $db->Execute($query);
	
	if (!isset($result)) {
		$state[] = array('error', 1, $this->db->ErrorMsg());
	}
	else {
		while (!$result->EOF) {
			//format message
			if (isset($data['to']) && $data['to'] > 0) {
				$message = str_replace("FIRSTNAME", $result->fields['user_firstname'], $data['message']);
			}
			else {
				$message = $data['message'];
			}
			
			$mail->Body = nl2br($message);
			$mail->ClearAddresses();
			$mail->AddAddress($result->fields['user_email'], '');

			if(!$mail->Send()) {
				$state[]  = array('error', 18, $mail->ErrorInfo); //Mailer Error
			}
			else {
				$total_emails_sent++;
			}
			
			$result->MoveNext();
		}

		$result->Close();
	}
		
	

	if (!isset($state)) {
		$state[]  = array('success', 7, $total_emails_sent);

	}

	return $state;

}//EO sendNewsletter();


/*
* sendInvite
* Tom Calthrop 7th April 2004
*/
function getCountUsers($lock_id = null) {

	global $db;
	
	//get the email addresses and firstnames
	if (isset($lock_id) && $lock_id > 0) {
		//"to" level - 1=pending, 2=member - 
		$query = "
			SELECT count(user_id) as total  
			FROM " . $db->prefix . "_user 
			WHERE 
			user_locked=". $lock_id
		;
	}
	else {
		//if not 1 or 2 we go to the invite table
		$query = "
			SELECT count(invited_email) as total 
			FROM " . $db->prefix . "_user_invited"
		;
	}
	//echo $query;
	$result = $db->Execute($query);
	
	$total = 0;
	
	if (isset($result)) {
		$total = $result->fields['total'];
	}
	
	return $total;
}

?>
