<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

if (empty($_SESSION['report_abuse_url'])) {
    //we error and go back a page
	return header("Location: " . $me['homepage'] . "?" . SID);
	exit;
}


//format report abuse url
$report_abuse_url = $_SESSION['report_abuse_url'];
$report_abuse_url = str_replace('&abuse_report=1', '', $report_abuse_url);

//format report abuse body
$report_abuse_body = $_SESSION['report_abuse_body'];
//remove href's
$report_abuse_body = preg_replace("/href=\"(.*)\"/", "href=\"#\"", $report_abuse_body);
//remove form
$report_abuse_body = preg_replace("/action=\"(.*)\"/", "action=\"#\"", $report_abuse_body);
$report_abuse_body_stripped = htmlspecialchars($report_abuse_body);


if (isset($_POST['send_report'])) {
	$data['user_id'] = $me['user_id'];
	$data['language_id'] = $me['language_id'];
	
	//setup email
	require_once($c_node['class_dir'] . '/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 				$c_node['mail']['host'];
	$mail->Mailer = 			$c_node['mail']['mailer'];
	$mail->From = 				$c_node['mail']['default_address'];
	$mail->FromName = 			$c_node['mail']['from_name'];
	$mail->WordWrap = 			$c_node['mail']['wordwrap'];
	$mail->AddReplyTo($c_node['mail']['default_address'], $c_node['mail']['from_name']);
	$mail->language = 			"en";
	$mail->Mail->Priority = 	3;
	$mail->Mail->Encoding = 	"8bit";
	$mail->Mail->CharSet = 		"iso-8859-1";
	
	unset ($_SESSION['report_abuse_url'], $_SESSION['report_abuse_body']);
	
	insertReport($data);
}





//move to template
$body->set('report_abuse_url', $report_abuse_url);
$body->set('report_abuse_body', $report_abuse_body);

include "inc/footer.inc.php";




/*
* sendInvite
* Tom Calthrop 8th November 2004
*/
function insertReport($data) {

	global $db, $mail, $im, $languageTextPath, $me, $c_node, $lang, 
	$report_abuse_url, $report_abuse_body, $report_abuse_body_stripped;

	$datetime = $db->DBTimeStamp(mktime());

	$query = "
		INSERT INTO " . $db->prefix . "_abuse
		(
		abuse_url, 
		abuse_source, 
		reportee_user_id, 
		abuse_note, 
		reportee_languauge_id, 
		report_datetime, 
		report_status_id
		) values (
		'" . $report_abuse_url . "', 
		'" . $report_abuse_body_stripped . "', 
		" . $data['user_id'] . ", 
		'" . $data['message'] . "',
		" . $data['language_id'] . ", 
		" . $datetime . ", 
		" . $c_node['arr_abuse_status']['unallocated'] . "
		)"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$insertID = $db->Insert_ID();
		
		//prepare content to send
		$im_admin_file_txt = readTxtFile($languageTextPath . "im_abuse_reported.txt.php");
		$im_admin_file_txt = str_replace("\\\"", "\"", $im_admin_file_txt);
		$im_admin_file_txt = str_replace("ID_OF_REPORT", $insertID, $im_admin_file_txt);
		$im_admin_file_txt = str_replace("NOTE", $data['message'], $im_admin_file_txt);
		
		
		$mail_admin_file_txt = readTxtFile($languageTextPath . "mail_abuse_reported.txt.php");
		$mail_admin_file_txt = str_replace("\\\"", "\"", $mail_admin_file_txt);
		$mail_admin_file_txt = str_replace("NOTE", $data['message'], $mail_admin_file_txt);
		$url = "http://" . $_SERVER['HTTP_HOST'];
	
		if (dirname ($_SERVER['PHP_SELF']) != "/") {
		    $url .= dirname ($_SERVER['PHP_SELF']);
		}
		$mail_admin_file_txt = str_replace("URL", $url, $mail_admin_file_txt);
	
		
		$im_reportee_file_txt = readTxtFile($languageTextPath . "im_abuse_reported_thanks.txt.php");
		$im_reportee_file_txt = str_replace("\\\"", "\"", $im_reportee_file_txt);
		$im_reportee_file_txt = str_replace("NAME", $me['firstname'], $im_reportee_file_txt);
		$im_reportee_file_txt = str_replace("REF_NUMBER", "REF-" . $insertID, $im_reportee_file_txt);
		

		//get node admins and send message and EMAIL.
		 $query = "
			SELECT user_id, user_email 
			FROM " . $db->prefix . "_user
			WHERE
			level_id>=" . $c_node['user_level_id']['node_administrator']
		;
		$result = $db->Execute($query);

		if (isset($result->fields)) {

			while (!$result->EOF) {
				//send instant message to node admins
				$im->sendMessage($result->fields['user_id'], $lang['mail_subject_abuse_txt'], $im_admin_file_txt);
				
				//send email to email address
				$mail->Subject = $lang['mail_subject_abuse_txt'];
				$mail->Body = $mail_admin_file_txt;
				$mail->ClearAddresses();
				$mail->AddAddress($result->fields['user_email'], '');
	
				if(!$mail->Send()) {
					$log[] = array('error', 18, $mail->ErrorInfo); //Mailer Error
				}
				
				$result->MoveNext();
			}

			$result->Close();
		}
		
		//SEND THANK YOU MESSAGE TO REPORTER
		$im->sendMessage($me['user_id'], $lang['mail_subject_thanks_txt'], $im_reportee_file_txt);
	}
	
	//CLEAN UP
	return header("Location: http://" . $report_abuse_url . SID);
	exit;

}//EO insertReport();

?>
