<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


/*
* check access code (registered random password)
* if ok, verify new password. If ok, update user password
* add friends
* move to welcome.php
*/

include "inc/header.inc.php";
include $c_node['aroundme_dir'] . "inc/functions.inc.php";
include $c_node['aroundme_dir'] . "config/config_aroundme.inc.php";

//include error handling files from aroundme
$languagePath = $c_node['aroundme_dir'] . "language/" . $language_id . "/" . $c_node['template_default_name'];
$languageArrayPath = $languagePath . "/arrays/";
$languageTextPath = $languagePath . "/texts/";
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_error_success.lang.php');


//database setup and connect
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//set up user
require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->date = $date;
$user->db= $db;
$user->aroundme_dir = $c_node['aroundme_dir'];
$user->node_id = $c_node['node_id'];


//form processing
if (isset($_POST['setup'])) {

	$data = $_POST['data'];
   	$output_user = getUser($data['user_id']);

	$formcheck = formCheck($data);

	if (!isset($formcheck)) {
		//setup the user
		$setup = setupUser($_POST['data']);

		//send the invites
		if (!empty($data['to'])) {
	    	$sendInvites = sendInvites($output_user, $data);
		}
	}
	else {
		//return vars to form
		$output_data = $data;

		$error = $formcheck;
		$display = "setup";
	}

	if (empty($error)) {
	   	$user->relation_type = $c_node['relation_type']['approved'];
		$user->total_login_stat_id = $c_node['user_statistic_type_id']['total_logins'];
		$user->stat_type_id_friends = $c_node['user_statistic_type_id']['total_friends'];
		$user->stat_type_id_aqaintances = $c_node['user_statistic_type_id']['total_aqaintances'];

		$login = $user->loginUser($output_user['user_email'],$data['user_password1'], $c_node['node_id']);

		if (isset($login)) {
			$error = $login;
		}
		//header("Location: index.php");
	}

}
elseif (isset($_REQUEST['em'])) {
	//get user
	$output_user = getUserEmail($_REQUEST['em']);

	if ($output_user['user_locked'] == 2) {
		//you have already setup.
		$display = "setup_already";
	}
	elseif (isset($output_user['user_id']) && $output_user['user_id'] > 0 && $output_user['user_locked'] == 1) {
		//we can set up
		$display = "setup";
	}


}
else {
	//we error becuase we did not get the right vars passed to the page
	header("Location: index.php?".SID);
	exit;
}



//TEMPLATE
if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($error)) {
    $body->set('error', $error);
}
elseif (isset($success)) {
    $body->set('success', $success);
}

if (isset($output_data)) {
    $body->set('formdata', $output_data);
}


//MOVE VARS TO TEMPLATE
$body->set('lang', $lang);
echo $body->fetch("setup.tpl.php");
$db->Close();


function getUser($user_id) {

	global $db;

	$query = "
		SELECT u.*
		FROM " . $db->prefix . "_user u
		WHERE
		u.user_id =" . $user_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		header("Location: index.php?".SID);
	}
	else {
		$temp = $result->fields;

		return $temp;

	}

}


function getUserEmail($user_email) {

	global $db;

	$query = "
		SELECT u.*
		FROM " . $db->prefix . "_user u
		WHERE
		u.user_email ='" . $user_email . "'"
	;

	$result = $db->Execute($query);

	if (!$result) {
		header("Location: index.php?".SID);
	}
	else {
		$temp = $result->fields;

		return $temp;

	}

}

function setupUser ($data) {

	global $languageTextPath, $languageArrayPath, $languagePath,
	$c_node, $db, $output_user, $lang;

	require_once($languageTextPath . 'message.lang.php');
	//require_once($languagePath . 'verify_registration.lang.php');


	//update the user
	$query = "
		UPDATE " . $db->prefix . "_user set
		user_locked=2,
		user_password = '" . md5($data['user_password1']) . "'
		WHERE
		user_id = " . $data['user_id']
	;

	$result = $db->Execute($query);
	$result->Close();



	//setup instant messaging
	require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/IM.class.php');
	//changed to not be from smudge
	//$im = new IM($c_node['default_node_admin_id'], $db, $c_node['message_box_max_size']);
	$im = new IM($output_user['user_id'], $db, $c_node['message_box_max_size']);

	$im->setStatus($c_node['message_status_unread'], $c_node['message_status_read']);
	$im->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);

	//get text files
	$body_welcome_txt = readTxtFile($languageTextPath . "im_welcome.txt.php");


	//send welcome IM to user
	$body_welcome_txt = str_replace("NAME", $output_user['user_firstname'], $body_welcome_txt);
	$im->sendMessage($data['user_id'], $lang['subject_im_welcome'], $body_welcome_txt);



	//we check for who invitees
	$query2 = "
		SELECT DISTINCT invitee_user_id
		FROM " . $db->prefix . "_user_invited
		WHERE
		invited_email='" . $output_user['user_email'] . "'"
	;

	$result2 = $db->Execute($query2);

	if (isset($result2)) {
		require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/User.class.php');
		$user = new User();
		$user->db = $db;
		$user->node_id = $c_node['node_id'];
		$user->user_id = $data['user_id'];

		//we send an IM to each invitee and add this user to thie social network
		$body_invitee_txt = readTxtFile($languageTextPath . "im_invitee_joined.txt.php");

		while (!$result2->EOF) {
			$temp_invitees = $result2->fields;
			$invitee_id = $temp_invitees['invitee_user_id'];


			$relation = $user->insertRelation($invitee_id, $c_node['relation_type']['approved']);

			$body_invitee_txt1 = str_replace("NAME", $output_user['user_firstname'], $body_invitee_txt);
			$im->sendMessage($invitee_id, $lang['subject_im_joined'], $body_invitee_txt1);

			$result2->MoveNext();
		}

		$result2->Close();

	}

	//we delete those records
	$query3 = "
		DELETE FROM " . $db->prefix . "_user_invited
		WHERE
		invited_email='" . $output_user['user_email'] . "'"
	;

	$result3 = $db->Execute($query3);
	$result3->Close();

	//SETUP USER STUFF


	//make image directory
	if (ftpMkdir("user", $data['user_id'])) {
	    $dir_created = true;
	}


	$datetime = date("Y-m-d H:i:s");
	$datetime = $db->DBDate($datetime);

	//create default library item
	$query = "
		INSERT INTO " . $db->prefix . "_user_library
		(library_title, library_page_name , library_synopsis, library_body, library_create_datetime, user_id, library_default, library_publish)
		values (
		'" . $lang['txt_default_library_title'] . "',
		'" . $lang['txt_default_library_page_name'] . "',
		'" . $lang['txt_default_library_synopsis'] . "',
		'" . $lang['txt_default_library_body'] . "',
		" . $datetime . ",
		" . $data['user_id'] . ",
		1,
		" . $c_node['user_publish']['friends'] . "
		)"
	;
	//echo $query . "<br>";
	$result = $db->Execute($query);


	//Create membership of default help group
	$query = "
		INSERT INTO " . $db->prefix . "_group_member (
		group_id, level_id, member_create_datetime, user_id, node_id
		) values (
		" . $c_node['help_group_id'][$output_user['language_id']] . ",
		" . $c_node['user_level_id']['member'] . ",
		" . $datetime . ",
		" . $data['user_id'] . ",
		" . $c_node['node_id'] . "
		)"
	;
	$result = $db->Execute($query);

}



/*
* ftpMkdir
* Tom Calthrop 17th April 2004
*/
function ftpMkdir ($type, $newDir) {

	global $c_node;

	$path = $c_node['ftp']['asset_path'] . $type . "/";

	$connection = @ftp_connect($c_node['ftp']['server']);
	$username = $c_node['ftp']['user'];
	$pass = $c_node['ftp']['pass'];
	$login_result = @ftp_login($connection,$username,$pass);
	// check to make sure you're connected:
	if ((!($login_result)) or (!($connection))) {
	   // error....do something
	}
	else {
		// we're good to go -- the connection was made
		@ftp_chdir($connection,$path);

		if (@ftp_mkdir($connection,$newDir)) {
			//small hack - can swap for ftp_chmod in php5 / tom
			$chmod_cmd="CHMOD 777 /".$path . $newDir;
			$chmod=@ftp_site($connection, $chmod_cmd);
		}

		@ftp_close($connection);
	}
} //EO ftpMkdir();


function sendInvites($output_user, $data) {

	global $c_node, $lang, $languageTextPath, $db;

	//setup email
	require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . '/Mail/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->Host = 		$c_node['mail']['host'];
	$mail->Mailer = 	$c_node['mail']['mailer'];
	$mail->From = 		$output_user['user_email'];
	$mail->FromName = 	$output_user['user_firstname'] . " " . $output_user['user_surname'];
	$mail->WordWrap = 	$c_node['mail']['wordwrap'];
	$mail->AddReplyTo('support@barnraiser.org', $lang['subject_noreply']);
	$mail->language = 	"en";


	//setup IM
	require_once($c_node['aroundme_dir'] . $c_node['class_dir'] . 'User/IM.class.php');
	$im = new IM($output_user['user_id'], $db, $c_node['message_box_max_size']);
	$im->setStatus($c_node['message_status_unread'], $c_node['message_status_read']);
	$im->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);


	//get text files
	$body_file_mail_txt = readTxtFile($languageTextPath . "mail_invite.txt.php");
	$body_file_im_txt = readTxtFile($languageTextPath . "im_invite.txt.php");

	//prepare data
	$emails = trim($data['to']);
	$emails = preg_split("/[\s,]+/", $emails);

	//check each email
	foreach($emails as $key => $i):

		//check to see if user in User table
		$query1 = "SELECT user_id FROM " . $db->prefix . "_user WHERE user_email='" . $i . "'";
		$result1 = $db->Execute($query1);

		if(!empty($result1->fields['user_id']) && $result1->fields['user_id'] != $output_user['user_id']) {

			//send internal instant message to user
			$body_file_im_txt1 = "";
			$body_file_im_txt1 = str_replace("NAME", $me['firstname'], $body_file_im_txt);

			//we check that the user has not blocked me
			if($im->checkUserBlocked($result1->fields['user_id'])) {

				//check we do not already have a relation record
				// add a br_relation record with a level of "approval_pending"
				if ($relation = $user->insertRelation($result1->fields['user_id'], $c_node['relation_type']['approval_pending'])) {
				    //send IM
					$im->sendMessage($result1->fields['user_id'], $lang['subject_im_friendship_invite'], $body_file_im_txt1, 1);
				}
			}
		}
		else {
			//send email

			$body_file_mail_txt1 = "";
			$body_file_mail_txt1 = str_replace("USERMESSAGE", $lang['txt_invite'], $body_file_mail_txt);
			$body_file_mail_txt1 = str_replace("NAME", $output_user['user_firstname'], $body_file_mail_txt1);
			$url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . "/register.php?invitee=" . $data['user_id'] . "&email=" . htmlspecialchars($i) . "&language_id=" . $output_user['language_id'];
			$body_file_mail_txt1 = str_replace("URL", $url, $body_file_mail_txt1);
			$body_file_mail_txt1 = stripslashes($body_file_mail_txt1);

			//send email to email address
			$mail->Subject = $lang['txt_invite_message_txt'];
			$mail->Body = $body_file_mail_txt1;
			$mail->ClearAddresses();
			$mail->AddAddress($i, '');

			if(!$mail->Send()) {
			 	$state[]  = array('error', 18, $mail->ErrorInfo); //Mailer Error
			}

			//insert record into user invitee table.
			$datetime = date("Y-m-d H:i:s");
			$datetime = $db->DBDate($datetime);

			$query = "
				INSERT INTO " . $db->prefix . "_user_invited
				(invited_email, invitee_user_id, invite_create_datetime) VALUES (
				'" . $i ."',
				" . $data['user_id'] . ",
				" . $datetime . ")"
			;

			$result = $db->Execute($query);

		}
	endforeach;
}


function formCheck($data) {

	global $db;

	//check the access code
	$query = "
		SELECT user_id
		FROM " . $db->prefix . "_user
		WHERE
		user_id=" . $data['user_id'] . " AND
		user_password=MD5('" . $data['access_code'] . "')"
	;

	$result = $db->Execute($query);

	if(!isset($result->fields['user_id']) || $result->fields['user_id'] < 0) {
		$error[] = array('error', 27); //access code wrong
	}


	//check the new passwords
	if(isset($data['user_password1']) && isset($data['user_password2']) && $data['user_password1'] != $data['user_password2']) {
		$error[]  = array('error', 15);
	}

	if(isset($data['user_password1']) && strlen($data['user_password1']) < 5) {
		$error[]  = array('error', 16);
	}

	if (!empty($data['to'])) {
		//check for emails
		$emails = trim($data['to']);
		$emails = preg_split("/[\s,]+/", $emails);

		//check each email
		foreach($emails as $key => $i):

			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $i)) {
				$error[]  = array('error', 3, $i); //email invalid
			}
		endforeach;
	}

	if (isset($error)) {
	    return $error;
	}
}
?>

