<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$menu_section = "magazine";

include "inc/header.inc.php";
require_once($c_node['dir']['class_path'] . 'Cms.class.php');
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Blog.class.php');


if (isset($_REQUEST['search_genre_id']) && $_REQUEST['search_genre_id'] > 0) {
    $genre_id = $_REQUEST['search_genre_id'];
}
else {
	$genre_id = null;
}

if (!empty($_REQUEST['search_text'])) {
    $search = $_REQUEST['search_text'];
}
else {
	$search = null;
}


//append language setup
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_cms.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//setup cms
require_once($c_node['dir']['class_path'] . 'Cms.class.php');
$cms = new Cms($db, null);
$cms->level_id = $c_node['cms']['cms_level']['node'];
$cms->cms_status_id = $c_node['cms']['status']['live'];
$cms->language_ids = $me['language_ids'];
$cms->limit = 10;


//get blog ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_blog'];
$output_g_cms_blogs = $cms->getCmsItems();
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_blog'];
$output_u_cms_blogs = $cms->getCmsItems();
$output_cms_blogs = array_merge($output_g_cms_blogs, $output_u_cms_blogs);

foreach($output_cms_blogs as $key => $i):
	$cms_blog_ids[] = $i['item_id'];
endforeach;
//get forum subject ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_forum_subject'];
$output_cms_subjects = $cms->getCmsItems();

foreach($output_cms_subjects as $key => $i):
	$cms_subject_ids[] = $i['item_id'];
endforeach;
//get group poll ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_poll'];
$output_cms_polls = $cms->getCmsItems();

foreach($output_cms_polls as $key => $i):
	$cms_poll_ids[] = $i['item_id'];
endforeach;
//get library ids -----------------------------------------------------
$cms->cms_item_type_id = $c_node['cms']['item_type']['group_library'];
$output_g_cms_library_items = $cms->getCmsItems();
$cms->cms_item_type_id = $c_node['cms']['item_type']['user_library'];
$output_u_cms_library_items = $cms->getCmsItems();
$output_cms_library_items = array_merge($output_g_cms_library_items, $output_u_cms_library_items);

foreach($output_cms_library_items as $key => $i):
	$cms_library_item_ids[] = $i['item_id'];
endforeach;


//setup blog
$blog = new Blog($db, null, $date, $file);
$blog->genre_id = $genre_id;
//get blog items
if (!empty($cms_blog_ids)) {
	$blog->blog_ids = $cms_blog_ids;
	$output_blogs = $blog->getBlogs($search);
}

//setup forum
$forum = new Forum($db, null, $date, $file);
$forum->genre_id = $genre_id;
//get subjects
if (!empty($cms_subject_ids)) {
	$forum->subject_ids = $cms_subject_ids;
	$output_subjects = $forum->getSubjects($search);
}


// poll setup
$poll = new Poll($db, $c_acs['arr_section']['group'], $date);
$poll->order_by = "poll_start_datetime desc";
//get polls
if (!empty($cms_poll_ids)) {
	$poll->poll_ids = $cms_poll_ids;
	$output_polls = $poll->getPolls($search);
}


//library setup
$library = new Library($db, null, $date, $file);
$library->genre_id = $genre_id;
//get library items
if (!empty($cms_library_item_ids)) {
	$library->library_item_ids = $cms_library_item_ids;
	$output_library_items = $library->getLibraryItems($search);
}


//get the user details for the rss feed link
$user->user_id = $me['user_id'];
$output_user = $user->getUser();


//move to template
if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
	$body->set('cms_blogs', $output_cms_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
	$body->set('cms_subjects', $output_cms_subjects);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
	$body->set('cms_polls', $output_cms_polls);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('cms_library_items', $output_cms_library_items);
}

if (!empty($genre_id)) {
	$body->set('genre_id', $genre_id);
}

if (!empty($output_search_results)) {
	$body->set('search_results', $output_search_results);
}

if (!empty($search)) {
	$body->set('search', $search);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($display)) {
	$body->set('display', $display);
}

$template_pageLink = $lang['txt_magazine_name'];
include "inc/footer.inc.php";
?>
