<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


if (isset($_REQUEST['blog_id'])) {
	require_once($c_node['dir']['class_path'] . 'Blog.class.php');
    $blog_id = $_REQUEST['blog_id'];
}

if (isset($_REQUEST['subject_id'])) {
	require_once($c_node['dir']['class_path'] . 'Forum.class.php');
    $subject_id = $_REQUEST['subject_id'];
}

if (isset($_REQUEST['poll_id'])) {
	require_once($c_node['dir']['class_path'] . 'Poll.class.php');
    $poll_id = $_REQUEST['poll_id'];
}

if (isset($_REQUEST['library_id'])) {
	require_once($c_node['dir']['class_path'] . 'Library.class.php');
    $library_id = $_REQUEST['library_id'];
}

if (isset($_REQUEST['schedule_id'])) {
	require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
    $schedule_id = $_REQUEST['schedule_id'];
}

if (isset($_REQUEST['section_id'])) {
    $section_id = $_REQUEST['section_id'];
}

if (isset($_REQUEST['inc_comment'])) {
	require_once($c_node['dir']['class_path'] . 'Comment.class.php');
	$comment = new Comment($db, null, $date);
}

//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];

		
//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');


if (isset($blog_id)) {
	$blog = new Blog($db, null, $date, $file);
	$blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();
	
	
	if ($output_blog['section_id'] == $c_acs['arr_section']['user']) {
	    if (isset($comment)) {
	        $comment->rsp_item_type_id = $c_node['rsp']['item_type']['user_blog'];
	    }
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');
	}
	elseif ($output_blog['section_id'] == $c_acs['arr_section']['group']) {
	    if (isset($comment)) {
			$comment->rsp_item_type_id = $c_node['rsp']['item_type']['group_blog'];
		}
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');
	}
	
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');
	
	if (isset($comment)) {
		$comment->item_id = $blog_id;
		$comment->section_item_id = $output_blog['user_id'];
		$output_comments = $comment->getComments($blog_id);
	}
	
	if (isset($output_blog['user_id'])) {
		$user->user_id = $output_blog['user_id'];
    	$output_author = $user->getProfile();
	}
	
	if (!empty($output_author['profile_allow_comments']) && !empty($output_blog['blog_allow_comments'])) {
		$allow_add_comment = true;
	}
}


if (isset($subject_id)) {
	
	$forum = new Forum($db, null, $date, $file);
	$forum->subject_id = $subject_id;
	$output_subject = $forum->getSubject();
	
	if (isset($comment)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['group_forum'];
		$comment->item_id = $subject_id;
		$comment->section_item_id = $output_subject['user_id'];
		$output_comments = $comment->getComments($subject_id);
	}
	
	if (isset($output_subject['user_id'])) {
		$user->user_id = $output_subject['user_id'];
    	$output_author = $user->getProfile();
	}
	
	if (!empty($output_author['profile_allow_comments'])) {
		$allow_add_comment = true;
	}
}


if (isset($poll_id)) {
	
	$poll = new Poll($db, null, $date);
	$poll->poll_id = $poll_id;
	$output_poll = $poll->getPoll();
	$output_poll['current_answer'] = $poll->pollUserCurrentVote($me['user_id']);
	
	if (isset($output_poll)) {
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}
	
	if (isset($comment)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['group_poll'];
		$comment->item_id = $poll_id;
		$comment->section_item_id = $output_poll['section_item_id'];
		$output_comments = $comment->getComments($poll_id);
	}
	
	//get users vote for each comment
	if (isset($output_comments)) {
		foreach($output_comments as $key => $i):
			$output_comments[$key]['vote'] = $poll->pollUserVoteHistory($i['user_id']);
		endforeach;
	}
	
	if (isset($output_poll['user_id'])) {
		$user->user_id = $output_poll['user_id'];
    	$output_author = $user->getProfile();
	}
	
	if (!empty($output_author['profile_allow_comments'])) {
		$allow_add_comment = true;
	}
}


if (isset($library_id)) {
	
	$library = new Library($db, null, $date, $file);
	$library->library_id = $library_id;
	$output_library_item = $library->getPageID();
	
	if ($output_library_item['section_id'] == $c_acs['arr_section']['user']) {
	    if (isset($comment)) {
			$comment->rsp_item_type_id = $c_node['rsp']['item_type']['user_library'];
		}
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');
	}
	elseif ($output_library_item['section_id'] == $c_acs['arr_section']['group']) {
	    if (isset($comment)) {
			$comment->rsp_item_type_id = $c_node['rsp']['item_type']['group_library'];
		}
		$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'group/');
	}
	
	$output_library_item['library_body'] = $wiki->transform($output_library_item['library_body'], 'Xhtml');
	$output_library_item['display_library_create_datetime'] = $date->formatDate($output_library_item['library_create_datetime'], 1);
	
	if (isset($comment)) {
		$comment->item_id = $library_id;
		$comment->section_item_id = $output_library_item['user_id'];
		$output_comments = $comment->getComments($library_id);
	}
	
	if (isset($output_library_item['user_id'])) {
		$user->user_id = $output_library_item['user_id'];
    	$output_author = $user->getProfile();
	}
	
	if (!empty($output_author['profile_allow_comments']) && !empty($output_library_item['library_allow_comments'])) {
		$allow_add_comment = true;
	}
}


if (isset($schedule_id)) {
	//setup group+language
	require_once($languagePath . 'sch_item.lang.php');
	require_once($languageArrayPath . 'arr_schedule.lang.php');
	
	$schedule = new Schedule($db, null, $date, $file);
	$schedule->schedule_id = $schedule_id;
	$schedule->schedule_config = $c_node['schedule'];
	$schedule->user_id = $me['user_id'];
	$output_schedule = $schedule->selScheduleItem();
	
	if ($output_schedule['section_id'] == $c_acs['arr_section']['group']) {
	    if (isset($comment)) {
			$comment->rsp_item_type_id = $c_node['rsp']['item_type']['group_schedule'];
		}
	}
	else {
	    if (isset($comment)) {
			$comment->rsp_item_type_id = $c_node['rsp']['item_type']['user_schedule'];
		}
	}
	
	
	if (isset($comment)) {
		$comment->item_id = $schedule_id;
		$comment->section_item_id = $output_schedule['section_item_id'];
		$output_comments = $comment->getComments($schedule_id);
	}
	
	if (isset($output_schedule['user_id'])) {
		$user->user_id = $output_schedule['user_id'];
    	$output_author = $user->getProfile();
	}
}


//create link to user
$url = "http://" . $_SERVER['HTTP_HOST'];
$url .= dirname ($_SERVER['PHP_SELF']);
//sometimes the server adds / as the last characture - we need to check.
if (substr($url, -1, 1) != "/") {
    $url .= "/";
}

$output_author['profile_url'] = $url . "sn_profile.php?user_id=" . $output_author['user_id'];

if (!empty($output_comments)) {
    foreach($output_comments as $key => $i):
		$output_comments[$key]['profile_url'] = $url . "sn_profile.php?user_id=" . $i['user_id'];
	endforeach;
}





//move to template
if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_poll)) {
	$body->set('poll', $output_poll);
}

if (!empty($output_schedule)) {
	$body->set('schedule', $output_schedule);
}

if (!empty($output_library_item)) {
	$body->set('library', $output_library_item);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

$body->set('templatePath', $template_path);
$body->set('lang', $lang);



echo $body->fetch("print_item.tpl.php");
$db->Close();

?>
