<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


include "inc/header_group.inc.php";

//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['allow_acs'])) { //resourece_id, Priv_id
	header("Location: grp_view.php?group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}


$acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
$acs->group_id = $group_id;


//append language setup
require_once($languageArrayPath . 'arr_acs.lang.php');

//ROLES
$output_roles = $acs->getGroupRoles();

//RESOURCES
//get resource_id's from config and build the resources array
$config_resources = $c_acs['arr_acs']['resource']['group'];
$resource_privilege = $c_acs['resource_privilege'];
$arr_acs = $lang['arr_acs'];
$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);

if(isset($_POST["update_permissions"])){

	//deletes permission for each role
	if (!empty($output_roles)) {
	    foreach($output_roles as $key => $i):
			$acs->role_id = $i['role_id'];
			$acs->deletePermissions();
		endforeach;
	}
	
	// Resets all the permissions
	
	if(!empty($frmdata['ids'])){
		foreach($frmdata['ids'] as $key => $value){
			$ind = explode("-", $key);
			
			$resource_id = $ind[0]; // resource_id
			$privilege_id = $ind[1]; // privilege_id
			$role_id = $output_roles[$ind[2]]['role_id']; // role_id
			$acs->insertPermission($role_id, $resource_id, $privilege_id); // insert privileges
		}
	}
	
	$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);
}
elseif (isset($_POST['insert_role'])) {
	$acs->insertGroupRole($frmdata);
	$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: grp_acs.php?group_id=" . $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['update_role'])) {
	$acs->updateGroupRole($frmdata);
	$acs->role_id = $frmdata['role_id'];
	$output_role = $acs->getGroupRole();
	$output_roles = $acs->getGroupRoles();
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: grp_acs.php?group_id=" . $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['delete_role'])) {
	$acs->deleteGroupRole($frmdata);
	$output_roles = $acs->getGroupRoles();	
	$output_resources = $acs->getResources($config_resources, $resource_privilege, $arr_acs, $output_roles);
	
	if (empty($GLOBALS['am_error_log'])) {
		header("Location: grp_acs.php?group_id=" . $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['set_default']) && isset($frmdata['default_role_id'])) {
	$acs->updateGroupDefaultRole($frmdata['default_role_id']);
	$output_roles = $acs->getGroupRoles();
}
elseif (isset($_REQUEST['role_id'])) {
	$acs->role_id = $_REQUEST['role_id'];
	$output_role = $acs->getGroupRole();
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (!empty($output_role)) {
    $body->set('role', $output_role);
}

if (!empty($output_resources)) {
    $body->set('resources', $output_resources);
}

include "inc/footer.inc.php";

?>

