<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Library {
	// CLASS FUNCTIONS
	// Library
	// getPages
	// selLibraryItems
	// getPageName
	// getPageID
	// getPageDefault
	// getHistory
	// getContents
	// insertLibrary
	// getLibraryItemCount



	// Library --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 18th May 2004
	//
	function Library($db, $rsp_item_type_id, $file=null) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		
		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Library



	// getPages --------------------------------------------------------------------
	// used to list the page_names held in this library
	// tom calthrop - 18th May 2004
	//
	function getPages () {

	    $query = "
			SELECT DISTINCT l.library_page_name
			FROM " . $this->db->prefix . "_library l 
			WHERE "
		;
		
		if (isset($this->user_id)) {
			$query .= "l.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		else {
			$query .= "l.group_id is NULL AND ";
		}
		
		$query .="1=1 order by l.library_page_name";
		
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields['library_page_name'];
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getPages class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getPages();



	// selLibraryItems --------------------------------------------------------------------
	// get the library items for given ids
	// tom calthrop - 10th December 2004
	//
	function selLibraryItems($search = null) {
		$query = "
			SELECT DISTINCT l.library_id, l.library_page_name, l.library_title, l.library_synopsis,
			l.file_id, l.library_allow_comments, l.library_create_datetime, l.user_id, l.group_id "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", pr.profile_create_datetime, pr.profile_nic, pr.profile_hometown, rsp.rsp_sticky, rsp.rsp_featured ";
		}
			
		$query .= "FROM " . $this->db->prefix . "_library l ";
		
		if (isset($this->tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", " . $this->db->prefix . "_rsp rsp 
			LEFT JOIN " . $this->db->prefix . "_user_profile pr ON l.user_id=pr.user_id AND pr.profile_default=1 ";
		}
		
		$query .= "WHERE ";
		
		if (isset($this->tag)) {
			$query .= "
				l.library_id=t.item_id AND 
				t.user_id=" . $this->me['user_id'] . " AND 
				t.rsp_item_type_id=" . $this->item_types['library'] . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=l.library_id AND
				rsp.level_id=" . $this->rsp_level_id . " AND 
				rsp.rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->rsp_status_id . " AND ";
			}
			
			if (isset($this->rsp_featured)) {
				$query .= "rsp.rsp_featured=" . $this->rsp_featured . " AND ";
			}
		}
		
		if (isset($search)) {
			$query .= "
				(
				l.library_title like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				l.library_synopsis like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				l.library_body like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . "
				) and "
			;
		}
		
		if (isset($this->user_id)) {
			$query .= "l.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) { // group list
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
					$user_ids .=",";
				}
			endforeach;
			$query .="l.user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($this->library_ids)) { //used for bookmarks
			$library_ids = "";
			foreach($this->library_ids as $key => $i):
				$library_ids .= $i;
				if (count($this->library_ids) > $key+1) {
					$library_ids .=",";
				}
			endforeach;
			$query .= "l.library_id in (" . $library_ids . ") AND ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by l." . $this->order_by;
		}
		else {
			$query .= "order by l.library_page_name";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}
		//echo $query;
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($this->file)) {
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				//format search results
				if (isset($search)) {
					$temp1['library_synopsis'] = searchTextFormat($search, $temp1['library_synopsis']);
					$temp1['library_title'] = searchTextFormat($search, $temp1['library_title']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selLibraryItems class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selLibraryItems



	// getPageName --------------------------------------------------------------------
	// will get the newest page for $library_page_name
	// tom calthrop - 18th May 2004
	//
	function getPageName($library_page_name) {
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_library l 
			WHERE 
			l.library_page_name=" . $this->db->qstr($library_page_name, get_magic_quotes_gpc()) . " AND "
		;
		
		if (isset($this->user_id)) { // group list
			$query .= "l.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		
		$query .= "1=1 order by l.library_create_datetime desc";

		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			if (!empty($result->fields)) {
				$temp = $result->fields;
				$this->library_id = $temp['library_id'];
				return $temp;
			}
		}
		else {
			$error_info = "function=getPageName class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageName



	// getPageID --------------------------------------------------------------------
	// will get the newest page for $library_page_name
	// tom calthrop - 18th May 2004
	//
	function getPageID($library_id=null) {

		if (empty($library_id)) {
		    $library_id = $this->library_id;
		}

		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_library
			WHERE
			library_id=" . $library_id;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$this->library_id = $temp['library_id'];
			return $temp;
		}
		else {
			$error_info = "function=getPageID class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageID



	// getPageDefault --------------------------------------------------------------------
	// will get the default page for the library
	// tom calthrop - 18th May 2004
	//
	function getPageDefault() {
		$query = "
			SELECT l.library_id, l.library_page_name, l.library_title, l.library_synopsis,
			l.file_id, l.library_allow_comments, l.library_create_datetime,
			l.library_body, l.user_id, l.library_default, l.group_id  
			FROM " . $this->db->prefix . "_library l 
			WHERE 
			l.library_default is not null AND "
		;
		
		if (isset($this->user_id)) { // group list
			$query .= "l.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		else {
			$query .= "l.group_id is null AND ";
		}
		
		$query .= "1=1 order by l.library_create_datetime desc";
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows

		if (isset($result->fields)) {
			if (!empty($result->fields)) {
				$temp = $result->fields;
				$this->library_id = $temp['library_id'];
				return $temp;
			}
		}
		else {
			$error_info = "function=getPageDefault class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageDefault



	// getHistory --------------------------------------------------------------------
	// used to list the pages in the library item history
	// tom calthrop - 18th May 2004
	//
	function getHistory($history_library_id) {

		//we retrieve the pagename
		$temp = $this->getPageID($history_library_id);
		$pagename = $temp['library_page_name'];

		if (!empty($pagename)) {
			$query = "
				SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
				p.profile_nic, l.group_id, l.library_page_name 
				FROM " . $this->db->prefix . "_library l
				LEFT JOIN " . $this->db->prefix . "_user_profile p ON l.user_id=p.user_id
				WHERE
				p.profile_default=1 AND 
				l.library_page_name=" . $this->db->qstr($pagename, get_magic_quotes_gpc()) . " AND "
			;
			
			if (isset($this->user_id)) {
				$query .= "l.user_id=" . $this->user_id . " AND ";
			}
			
			if (isset($this->group_id)) {
				$query .= "l.group_id=" . $this->group_id . " AND ";
			}
			
			$query .= "1=1 order by l.library_create_datetime desc";
			
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$temp = array();

				while (!$result->EOF) {
					$temp1 = $result->fields;
					array_push($temp, $temp1);
					$result->MoveNext();
				}

				$result->Close();
				return $temp;
			}
			else {
				$error_info = "function=getHistory class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO getHistory



	// getContents --------------------------------------------------------------------
	// used to list the library contents
	// tom calthrop - 18th May 2004
	//
	function getContents() {
		//first we need to get the newest library_page_name id for each library_page_name
		$query = "
			SELECT l.library_page_name, l.library_id, l.library_create_datetime
			FROM " . $this->db->prefix . "_library l 
			WHERE "
		;
		
		if (isset($this->user_id)) {
			$query .= "l.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		
		$query .= "1=1 order by l.library_page_name, l.library_create_datetime desc";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$ids = 0;
			$old_library_page_name = "";

			while (!$result->EOF) {

				if ($old_library_page_name <> $result->fields['library_page_name']) {
				    $ids .= "," . $result->fields['library_id'];
					$old_library_page_name = $result->fields['library_page_name'];
				}
				$result->MoveNext();
			}

			$result->Close();

			//now we get the contents for the selected ids
			if (!empty($ids)) {
				$query = "
					SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
					p.profile_nic, l.library_default, l.library_synopsis,
					l.library_default, l.group_id 
					FROM " . $this->db->prefix . "_library l
					LEFT JOIN " . $this->db->prefix . "_user_profile p ON l.user_id=p.user_id
					WHERE
					p.profile_default=1 AND "
				;
				
				if (isset($this->user_id)) {
					$query .= "l.user_id=" . $this->user_id . " AND ";
				}

				$query .= "
					l.library_id in (" . $ids . ")
					order by l.library_default, l.library_title"
				;

				$result = $this->db->Execute($query);

				if (isset($result->fields)) {
					$temp = array();

					while (!$result->EOF) {
						$temp1 = $result->fields;
						
						array_push($temp, $temp1);
						$result->MoveNext();
					}

					$result->Close();
					return $temp;
				}
				else {
					$error_info = "function=getContents class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
		else {
			$error_info = "function=getContents class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}


	}//EO getContents



	// insertLibrary --------------------------------------------------------------------
	// This function is only used for group libraries (no user library search query required)
	// tom calthrop - 18th May 2004
	//
	function insertLibrary($data) {

		if(empty($data['library_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if(empty($data['library_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}
		
		if(empty($data['library_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(13, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
			
			if (empty($data['group_id'])) {
			    $data['group_id'] = "null";
			}
			
			if (empty($data['library_allow_comments'])) {
			    $data['library_allow_comments'] = "null";
			}

			if (isset($data['library_default']) && $data['library_default'] > 0) {
			    //we clear out all old default pages
				$query = "
					SELECT * FROM " . $this->db->prefix . "_library
					WHERE "
				;
				
				if (isset($this->user_id)) {
					$query .= "user_id=" . $this->user_id . " AND ";
				}
				
				if (!empty($data['group_id'])) {
					$query .= "group_id=" . $data['group_id'] . " AND ";
				}
				else {
					$query .= "group_id is NULL AND ";
				}
				
				$query .="1=1";
				
				$result = $this->db->Execute($query);
				
				$rec = array();
				$rec['library_default'] = "null";
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
			}
			else {
				$data['library_default'] = "null";
			}
			
			$rec = array();
			$rec['library_title'] = $data['library_title'];
			$rec['library_synopsis'] = $data['library_synopsis'];
			$rec['library_body'] = $data['library_body'];
			$rec['language_id'] = $data['language_id'];
			$rec['file_id'] = $data['file_id'];
			$rec['library_page_name'] = $data['library_page_name'];
			$rec['user_id'] = $this->user_id;
			$rec['group_id'] = $data['group_id'];
			$rec['library_create_datetime'] = time();
			$rec['library_allow_comments'] = $data['library_allow_comments'];
			$rec['library_default'] = $data['library_default'];
			
			$table = $this->db->prefix . "_library";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				
				$this->library_id = $this->db->Insert_ID();
				$this->library_page_name = $data['library_page_name'];
			}
			else {
				$error_info = "function=insertLibrary class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertLibrary




	// getLibraryItemCount --------------------------------------------------------------------
	// will get the count of unique page names
	// tom calthrop - 27th December 2004
	//
	function getLibraryItemCount($user_id = null) {
		$query = "
			SELECT DISTINCT l.library_page_name
			FROM " . $this->db->prefix . "_library l 
			WHERE "
		;
		
		if (isset($user_id)) {
			$query .= "l.user_id=" . $user_id . " AND ";
		}
		
		if (isset($this->group_id)) {
			$query .= "l.group_id=" . $this->group_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result)) {
			if (isset($result->fields['library_page_name'])) {
				return count($result->fields);
			}
			else {
				return 0;
			}
		}
		else {
			$error_info = "function=getLibraryItemCount class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getLibraryItemCount
}
?>
