<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (isset($_REQUEST['group_id'])) {
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	require_once($languagePath . 'grp_common.lang.php');
}
elseif (!isset($rss_access_granted) && (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['library'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);
$library->rsp_level_id = $rsp_level_id;

if (isset($_REQUEST['library_id'])) {
	$library->library_id = $_REQUEST['library_id'];
}
elseif (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');


// SETUP WIKI ------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['library']);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;


// SETUP TAGS ------------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['library']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['library'], $me['user_id']);
}


// PROCESS FORM ----------------------------------------------------------
if (isset($_REQUEST['view']) && $_REQUEST['view'] == "firstpage") {
	unset($_REQUEST['view']);
}

if (isset($_POST['update_tag'])) {
	$frmdata['item_name'] = $frmdata['library_page_name'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: lib_view.php?library_id=". $frmdata['library_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['preview'])) {
	unset($library->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$library->library_id = $_REQUEST['library_id'];
	
	$output_library = $library->selLibraryItem();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['library_id'];
	$comment->item_user_id = $frmdata['item_user_id'];
	$comment->insertComment($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db);
		
		if (isset($frmdata['group_id'])) {
			$comment->group_id = $frmdata['group_id'];
		}
		
		//update user stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (isset($frmdata['group_id'])) {
			$statistic->group_id = $frmdata['group_id'];
			
			//update group stats
			unset($comment->user_id, $statistic->user_id, $comment->rsp_item_type_id, $comment->item_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
			
			//group member comments
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$comment->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
		}
		
		// update bookmarks to trigger notification
		if (isset($me['user_id'])) {
			$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
			$bookmark->updateBookmarkNotification($frmdata['library_id'], 1);
		}

		return header("Location: lib_view.php?library_id=". $frmdata['library_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$library->library_id = $_REQUEST['library_id'];
	
	$output_library = $library->selLibraryItem();
}
elseif (isset($_REQUEST['bookmark']) && isset($me['user_id'])) { // bookmark options for this item
	$bookmark->item_id = $_REQUEST['library_id'];
	
	if ($_REQUEST['bookmark'] == "ins_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		
		if (!empty($_REQUEST['notify'])) {
			$bookmark->insertBookmark(1);
		}
		else {
			$bookmark->insertBookmark();
		}
	}
	elseif ($_REQUEST['bookmark'] == "del_mark") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->deleteBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "ins_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
	}
	elseif ($_REQUEST['bookmark'] == "del_tip") {
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->deleteBookmark();
	}
	
	header("Location: lib_view.php?library_id=". $_REQUEST['library_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_REQUEST['view'])) {
	if ($_REQUEST['view'] == "my_library" && isset($me['user_id'])) {
		//get my library_items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		$library->user_id = $me['user_id'];
		
		$output_library_items = $library->selLibraryItems();
		
		$menu_section = "my";
	}
	elseif ($_REQUEST['view'] == "marked_library_items" && isset($me['user_id'])) {
		//get my marked library items
		unset($library->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$watched_library_ids = $bookmark->getBookmarks();
		
		$library->user_id = $me['user_id'];
		
		if (!empty($watched_library_ids)) {
			$library->library_ids = $watched_library_ids;
			$output_library_items = $library->selLibraryItems();
		}
	}
	elseif ($_REQUEST['view'] == "contents") {
		//get the latest node library_items
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		if (isset($_REQUEST['group_id'])) {
			$library->group_id = $_REQUEST['group_id'];
			unset($library->rsp_item_type_id);
			
			$lang['txt_intro'] = $lang['txt_intro_contents_group'];

		}
		else {
			$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
			$library->rsp_status_id = $c_node['rsp']['status']['live'];
			$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			
			$lang['txt_intro'] = $lang['txt_intro_contents'];
		}
		
		$output_library_items = $library->selLibraryItems();
	}
	elseif ($_REQUEST['view'] == "history") {
		//get my library_items
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$library->file = $file;
		
		$output_library_items = $library->getHistory($_REQUEST['library_id']);
		
		$lang['txt_intro'] = $lang['txt_intro_history'];
	}
}
elseif (isset($_REQUEST['library_id'])) {
	
	$output_library = $library->getPageID($_REQUEST['library_id']);
	
	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}
	
	$library->library_id = $output_library['library_id'];
}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
elseif (!empty($_REQUEST['group_id'])) {
	$library->group_id = $_REQUEST['group_id'];
	
	unset($library->user_id);
	$output_library = $library->getPageDefault();
	$newest = true;
}
else {
	unset($library->user_id);
	$output_library = $library->getPageDefault();
	$newest = true;
	
	$menu_section = "magazine";
	
	$_REQUEST['view'] = "firstpage";
}


// CHECK PERMISSION TO VIEW LIBRARY ------------------------------------------
if (!empty($output_library)) {
	// Are we allowed to see this library?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['library']);
	$output_library['rsp'] = $rsp->selRspItem($output_library['library_id']);
	
	if (isset($me['user_id']) && $me['user_id'] == $output_library['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (isset($rss_access_granted)) { // RSS Feed link
		$allow_view = 1;
	}
	elseif (!empty($output_library['rsp'])) { // is the item set to public?
		foreach ($output_library['rsp'] as $key => $i):
			if ($i['level_id'] == $c_node['rsp']['rsp_level']['public']) {
				$allow_view = 1;
				break;
			}
			elseif (!empty($_SESSION['s_md5']) && $i['level_id'] == $c_node['rsp']['rsp_level']['node']) { // is the item set to node and the user logged in?
				$allow_view = 1;
				break;
			}
		endforeach;
	}
	
	if (!empty($output_library['group_id'])) {
		require_once('class/Group.class.php');
		require_once($languagePath . 'grp_common.lang.php');
		require_once($languageArrayPath . 'arr_group.lang.php');
		$group = new Group($db, null);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_id = $output_library['group_id'];
		$output_group = $group->getGroup();
		
		//setup acs
		$group_acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
		$group_acs->group_id = $output_library['group_id'];
		
		// if access not allowed so far, check that I have view permissions within group
		if (isset($me['user_id'])) {
			$group->user_id = $me['user_id'];
			$output_group['member'] = $group->getGroupMembership();
		}
		
		if (empty($output_group['member']['role_id'])) {
			// treat as a visitor to the group
			$output_group['member'] = $group_acs->getGroupRole(null, 1);
		}
		
		$group_acs->role_id = $output_group['member']['role_id'];
		
		
		if (!isset($allow_view) && $group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
			$allow_view = 1;
		}
		
		$library->group_id = $output_library['group_id'];
	}
	
	if (!isset($allow_view)) {
		unset($output_library);
	}
}


// IF WE HAVE NO ITEM WE LIST CONTENTS --------------------------------------
if (!isset($allow_view) && !isset($output_library_items)) {
	unset($output_library);
	
	
	// if we have no item or list we attempt to list the contents
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$library->file = $file;
	
	if (isset($_REQUEST['group_id'])) {
		$library->group_id = $_REQUEST['group_id'];
		unset($library->rsp_item_type_id);
		
		$lang['txt_intro'] = $lang['txt_intro_contents_group'];
	}
	else {
		$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$library->rsp_status_id = $c_node['rsp']['status']['live'];
		$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
		
		$lang['txt_intro'] = $lang['txt_intro_contents'];
	}
	
	$output_library_items = $library->selLibraryItems();
	
	$_REQUEST['view'] = "contents";
}


// FORMAT LIBRARY ENTRY -------------------------------------------------------
if (!empty($output_library)) {
	//wikify body
	$wiki_path = "lib_view.php?page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	
	// set an array of pages that exist in the library
	$pages = $library->getPages();
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);
	$output_library['library_body_display'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	
	// GET AUTHOR
	if (!empty($output_library['group_id'])) {
		$output_group['author'] = $group->getGroupMembership($output_library['user_id']);
		
		if (!empty($output_group['author']['profile_id'])) {
			$output_author = $user->selProfile($output_group['author']['profile_id'], null);
		}
	}
	else {
		$output_author = $user->selProfile(null, $output_library['user_id']);
	}
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $library->library_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_library['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_library['bookmark']['recommend'] = 1;
		}
	}
	
	//get comments
	unset($comment->user_id);
	if (!empty($output_library['group_id'])) {
		$comment->group_id = $output_library['group_id'];
	}
	// if Item comments is requested (&ico=1) we select only select comment for
	// this library_id, else we get the history and get comments for all 
	// versions of this wiki page
	if (empty($_REQUEST['ico'])) {
		$output_library_history = $library->getHistory($library->library_id);
		
		if (!empty($output_library_history)) {
			$comment->item_ids = array();
			foreach($output_library_history as $key => $i):
				array_push($comment->item_ids, $i['library_id']);
			endforeach;
		}
		
		$output_comments = $comment->selComments();
	}
	else {
		$output_comments = $comment->selComments($library->library_id);
	}
	
	//get library item image
	if (isset($output_library['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->file_id = $output_library['file_id'];
		$output_library['image'] = $file->getFileRecord();
	}
	
	// is it the default page?
	if (isset($output_library['library_default'])) {
		$_REQUEST['view'] = "firstpage";
	}
	
	//get tags
	$tag->item_name = $output_library['library_page_name'];
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags(1);
	
	
	//get the history of the library item
	$output_sidebar_items = $library->getHistory($output_library['library_id']);
	
	if (isset($output_library['group_id'])) {
		$menu_section = "group";
	}
	else {
		$menu_section = "magazine";
	}
}


if (!empty($output_library_items)) {
	unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
	$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	
	foreach($output_library_items as $key => $i):
		if (!empty($i['library_allow_comments'])) {
			$output_library_items[$key]['comment_total'] = $comment->getCommentCount($i['library_id']);
		}
	endforeach;
	
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	foreach ($output_library_items as $key => $i):
		$tag->item_id = $i['library_id'];
		$output_library_items[$key]['tags'] = $tag->selTags();
	endforeach;
}


// SETUP TEMPLATE ---------------------------------------------------------
if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($_REQUEST['view'])) {
	$body->set('view', $_REQUEST['view']);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
	$template_pageLinkNote = $output_library['library_title'];
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('rsp_config', $c_node['rsp']); 
}

if (!empty($output_sidebar_items)) {
	$body->set('sidebar_items', $output_sidebar_items);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

if (!empty($newest)) {
	$body->set('newest', $newest);
}

$body->set('batch_enabled', $c_node['batch']['enabled']);
$body->set('rspconfig', $c_node['rsp']);

$template_pageLink = $lang['txt_library'];

include "inc/footer.inc.php";

?>