<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['administration'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: grp_view.php?group_id=" . $output_group['group_id']."&". strip_tags(SID));
	exit;
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'grp_common.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//wiki setup
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'lib_view.php?page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'lib_view.php?page=');
$wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=');


if (isset($frmdata['save_overview']) || isset($frmdata['save_go_overview'])) {

	$frmdata['group_synopsis'] = htmlspecialchars($frmdata['group_synopsis']);
	$frmdata['group_title'] = htmlspecialchars($frmdata['group_title']);
	
	$group->updateGroup($frmdata);

	if (empty($GLOBALS['am_error_log'])) {

		if (isset($frmdata['save_go_overview'])) {
			header("Location: grp_structure.php?group_id=" . $frmdata['group_id'] . "&". strip_tags(SID));
			exit;
		}
		else {
			header("Location: grp_edit.php?group_id=" . $frmdata['group_id'] . "&". strip_tags(SID));
			exit;
		}
	}

}
elseif (isset($frmdata['save_rules']) || isset($frmdata['save_go_rules'])) {
	$frmdata['group_rules'] = htmlspecialchars($frmdata['group_rules']);

	$group->updateGroupRules($frmdata);

	if (empty($GLOBALS['am_error_log'])) {

		if (isset($frmdata['save_go_rules'])) {
			header("Location: grp_structure.php?group_id=" . $frmdata['group_id'] . "&". strip_tags(SID));
			exit;
		}
		else {
			header("Location: grp_edit.php?group_id=" . $frmdata['group_id'] . "&edit_group_rules=1&". strip_tags(SID));
			exit;
		}
	}
}
elseif (isset($_REQUEST['edit_group_rules'])) {
	$display = "edit_group_rules";
}
elseif (isset($frmdata['preview_overview'])) {
		$output_group['group_home_synopsis'] = stripslashes($frmdata['group_home_synopsis']);
		$output_group['group_home_synopsis_preview'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');
}
elseif (isset($frmdata['preview_rules'])) {
		$output_group['group_rules'] = stripslashes($frmdata['group_rules']);
		$output_group['group_rules_preview'] = $wiki->transform($output_group['group_rules'], 'Xhtml');
		$display = "edit_group_rules";
}
elseif (isset($_REQUEST['archive_group'])) {

	$display = "archive_group";
}
elseif (isset($_POST['archive_group_confirm'])) {
	require_once('class/GroupAdmin.class.php');
	$group = new GroupAdmin($db, $me);
	$group->group_id = $frmdata['group_id'];
	$group->setGroupStatus($c_node['group']['status']['inactive']);
	header("Location: grp_list.php?". strip_tags(SID));
	exit;
}

$output_user = $user->getUser($me['user_id']);


//setup file ----------------------------------------------------------------
$file->group_id = $group_id;
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//move to template
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('status_ids', $c_node['group']['status']);

include "inc/footer.inc.php";

?>
