<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// setup vars
$plotdata = array();
$chartheight = 100;
$chartwidth = 100;
$gdfontpath = "c:\/WINDOWS\/Fonts\/";


// overwrite the default with received data
if (!empty($_REQUEST['data'])) {
	$plotdata = explode(",", $_REQUEST['data']);
}

// overwrite the default with received height
if (!empty($_REQUEST['h'])) {
	$chartheight = $_REQUEST['h'];
}

// overwrite the default with received widht
if (!empty($_REQUEST['w'])) {
	$chartwidth = $_REQUEST['w'];
}


// define chart file type
header("Content-type: image/png");

// create image
$image=imagecreate($chartwidth, $chartheight);


// set background colour
$background_color = imagecolorallocate($image, 255, 255, 255);


// define colours (r,g,b)
$colour_border = imagecolorallocate($image, 91, 91, 91);
$colour_grid = imagecolorallocate($image, 220, 220, 220);
$colour_light = imagecolorallocate($image, 223, 223, 223);
$colour_dark = imagecolorallocate($image, 0, 190, 228);
$colour_text = imagecolorallocate($image, 91, 91, 91);






if (isset($_REQUEST['type']) && $_REQUEST['type']== "line") {
	// create the grid
	$gridspacingwidth = round(($chartwidth-10) / (count($plotdata)-1));
	$gridspacingheight = round(($chartheight-10) / (count($plotdata)-1));

	//create a line chart
	for ($i=0; $i<count($plotdata)-1; $i++){
		imageline($image, ($i*$gridspacingwidth)+10, ($chartheight-$plotdata[$i]), (($i+1)*$gridspacingwidth)+10, ($chartheight-$plotdata[$i+1]), $colour_dark);
	}
}
else { // default = create a bar chart
	// create the grid
	$gridspacingwidth = round(($chartwidth-10) / count($plotdata));
	$gridspacingheight = round(($chartheight-10) / count($plotdata));
	
	for ($i=0; $i<count($plotdata); $i++){
		imagefilledrectangle($image, (($i*$gridspacingwidth)+2)+10, ($chartheight-$plotdata[$i]), (($i+1)*$gridspacingwidth-2)+10, ($chartheight-10), $colour_dark);
	}
}

// Create border around image
imageline($image, 10, 0, 10, $chartheight-10, $colour_border);
imageline($image, 10, 0, $chartwidth, 0, $colour_border);
imageline($image, $chartwidth-1, 0, $chartwidth-1, $chartheight-10, $colour_border);
imageline($image, 10, $chartheight-10, $chartwidth, $chartheight-10, $colour_border);

$font = $gdfontpath . 'georgia.ttf';
$fontsize = "7"; //gd1= pixels, gd2=points

// write the header
imagettftext($image, $fontsize, 90, 8, 88, $colour_text, $font, 'hello');

$bbox = imagettfbbox ($fontsize, 0, $font, 'hello');
$textWidth = $bbox[2] - $bbox[0];
$x = $chartwidth - $textWidth - 2;
imagettftext($image, $fontsize, 0, $x, 99, $colour_text, $font, 'hello');



// Output graph and clear image from memory
imagepng($image);
imagedestroy($image);


?>
