<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";

$menu_section = "network";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['network'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resource_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}
elseif (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['network'], $c_acs['arr_acs']['privilege']['allow_network'])) { //resource_id, Priv_id
	// we just list the directory
	header("Location: sn_list.php?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'sn_common.lang.php');
require_once($languageArrayPath . 'arr_skill.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
$user->file = $file;


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// get latest three people in 1st degree network
require_once('class/SocialNetwork.class.php');
$sn = new SocialNetwork(null, $db, null);
$sn->relation_type_ids = $c_node['user']['relation_type'];
$sn->status_ids = $c_node['user']['status'];
$sn->order_by = "r.relation_create_datetime desc";
$sn->limit = 5;
$sn->user_id = $me['user_id'];
$latest_contacts = $sn->selRelations($me['user_id']);

if (!empty($latest_contacts)) {
	foreach($latest_contacts as $key => $i):
		$user->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$user->user_ids[] = 0;
}

$latest_contacts_list = $user->selUsers();

// sort them
$output_latest_contacts = array();

if (!empty($latest_contacts)) {
	foreach($latest_contacts as $key => $i):
		if (!empty($latest_contacts_list)) {
			foreach($latest_contacts_list as $key => $r):
				if ($i['user_id_relation'] == $r['user_id']) {
					array_push($output_latest_contacts, $r);
				}
			endforeach;
		}
	endforeach;
}



// latest recommendation ---------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, null, null);
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
$bookmark->rsp_item_type_ids = $c_node['rsp']['item_type']['blog'] . "," . $c_node['rsp']['item_type']['forum'] . "," . $c_node['rsp']['item_type']['library'];

if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$bookmark->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$bookmark->user_ids[] = 0;
}

$bookmark->order_by = "item_id desc";
$bookmark->limit = 1;
$recommended = $bookmark->getBookmarks(1);

//setup blog
require_once('class/Blog.class.php');
$blog = new Blog($db, null, null);


//setup forum
require_once('class/Forum.class.php');
$forum = new Forum($db, null, null);


// assetain type and select
if (!empty($recommended)) {
	if ($recommended[0]['rsp_item_type_id'] == $c_node['rsp']['item_type']['blog']) {
		$blog->blog_id = $recommended[0]['item_id'];
		$output_recommended_item = $blog->selBlog();
	}
	elseif ($recommended[0]['rsp_item_type_id'] == $c_node['rsp']['item_type']['forum']) {
		$forum->subject_id = $recommended[0]['item_id'];
		$output_recommended_item = $forum->selSubject();
	}
	elseif ($recommended[0]['rsp_item_type_id'] == $c_node['rsp']['item_type']['library']) {
		//library setup
		require_once('class/Library.class.php');
		$library = new Library($db, null, null);
		$output_recommended_item = $library->getPageID($recommended[0]['item_id']);
	}
	
	$output_recommended_item['rsp_item_type_id'] = $recommended[0]['rsp_item_type_id'];
	
	$output_recommended_item['user'] = $user->selProfile(null, $recommended[0]['user_id']);
	
	$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
	
	if (isset($output_recommended_item['user']['file_id'])) {
		$file->file_id = $output_recommended_item['user']['file_id'];
		$output_recommended_item['user']['image'] = $file->getFileRecord();
	}
	if (isset($output_recommended_item['user']) && empty($output_recommended_item['user']['image'])) {
		$output_recommended_item['user']['image']['file_title'] = "";
		$output_recommended_item['user']['image']['file'] = $file->noimage;
	}
}


// last 3 blog entries from network --------------------------------------
unset ($blog->blog_id);
if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$blog->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$blog->user_ids[] = 0;
}

$blog->limit = 3;
$output_blog_entries = $blog->selBlogs();

if (!empty($output_blog_entries)) {
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	
	foreach ($output_blog_entries as $key => $i):
		$output_blog_entries[$key]['user'] = $user->selProfile(null, $i['user_id']);
		
		if (isset($output_blog_entries[$key]['user']['file_id'])) {
			$file->file_id = $output_blog_entries[$key]['user']['file_id'];
			$output_blog_entries[$key]['user']['image'] = $file->getFileRecord();
		}
		if (isset($output_blog_entries[$key]['user']) && empty($output_blog_entries[$key]['user']['image'])) {
			$output_blog_entries[$key]['user']['image']['file_title'] = "";
			$output_blog_entries[$key]['user']['image']['file'] = $file->noimage;
		}
	endforeach;
}


// latest subject from network --------------------------------------
unset ($forum->subject_id);
if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$forum->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$forum->user_ids[] = 0;
}

$forum->limit = 1;
$forum->order_by = "s.subject_create_datetime desc";
$output_latest_subject = $forum->selSubjects();

if (!empty($output_latest_subject)) {
	$output_latest_subject[0]['user'] = $user->selProfile(null, $output_latest_subject[0]['user_id']);
	
	$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][2]['name'];
	
	if (isset($output_latest_subject[0]['user']['file_id'])) {
		$file->file_id = $output_latest_subject[0]['user']['file_id'];
		$output_latest_subject[0]['user']['image'] = $file->getFileRecord();
	}
	if (isset($output_latest_subject[0]['user']) && empty($output_latest_subject[0]['user']['image'])) {
		$output_latest_subject[0]['user']['image']['file_title'] = "";
		$output_latest_subject[0]['user']['image']['file'] = $file->noimage;
	}
}

// latest replies to subjects --------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['forum']);
$comment->wiki = $wiki;
$comment->no_user_id = $me['user_id'];
$comment->limit = 3;
$comment->order_by = "c.comment_create_datetime desc";

if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$comment->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$comment->user_ids[] = 0;
}

$output_comments = $comment->selComments();

if (!empty($output_comments)) {
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	
	foreach ($output_comments as $key => $i):
		$output_comments[$key]['user'] = $user->selProfile(null, $i['user_id']);
		
		if (isset($output_comments[$key]['user']['file_id'])) {
			$file->file_id = $output_comments[$key]['user']['file_id'];
			$output_comments[$key]['user']['image'] = $file->getFileRecord();
		}
		if (isset($output_comments[$key]['user']) && empty($output_comments[$key]['user']['image'])) {
			$output_comments[$key]['user']['image']['file_title'] = "";
			$output_comments[$key]['user']['image']['file'] = $file->noimage;
		}
	endforeach;
}


// NEWEST SKILLS IN YOUR NETWORK -------------------------------------------
require_once('class/Skill.class.php');
$skill = new Skill($db);
if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$skill->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$skill->user_ids[] = 0;
}

$skill->limit = 1;
$skill->order_by = "s.skill_id desc";
$output_skill = $skill->selSkills(null, 1);

if (!empty($output_skill)) {
	$output_skill[0]['user'] = $user->selProfile(null, $output_skill[0]['user_id']);
	
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	
	if (isset($output_skill[0]['user']['file_id'])) {
		$file->file_id = $output_skill[0]['user']['file_id'];
		$output_skill[0]['user']['image'] = $file->getFileRecord();
	}
	if (isset($output_skill[0]['user']) && empty($output_skill[0]['user']['image'])) {
		$output_skill[0]['user']['image']['file_title'] = "";
		$output_skill[0]['user']['image']['file'] = $file->noimage;
	}
}

// events attended and tasks undertaken by network --------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date, null);
$schedule->schedule_config = $c_node['schedule'];

if (!empty($me['relations'])) {
	foreach($me['relations'] as $key => $i):
		$schedule->user_ids[] = $i['user_id_relation'];
	endforeach;
}
else {
	$schedule->user_ids[] = 0;
}

$schedule->limit = 10;
$schedule->order_by = "schedule_allocation_create_datetime desc";
$schedule_ids = $schedule->selScheduleAllocations();
unset ($schedule->limit, $schedule->order_by, $schedule->user_ids);

if (!empty($schedule_ids)) {
	foreach($schedule_ids as $key => $i):
		$schedule->schedule_ids[] = $i['schedule_id'];
	endforeach;
}
else {
	$schedule->schedule_ids[] = 0;
}
$output_schedule_items = $schedule->selScheduleItems();

if (!empty($output_schedule_items)) {
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	
	foreach ($output_schedule_items as $key => $i):
		foreach ($schedule_ids as $keysi => $si):
			if ($i['schedule_id'] == $si['schedule_id']) {
				
				$output_schedule_items[$key]['user'] = $user->selProfile(null, $si['user_id']);
				
				if (isset($output_schedule_items[$key]['user']['file_id'])) {
					$file->file_id = $output_schedule_items[$key]['user']['file_id'];
					$output_schedule_items[$key]['user']['image'] = $file->getFileRecord();
				}
				if (isset($output_schedule_items[$key]['user']) && empty($output_schedule_items[$key]['user']['image'])) {
					$output_schedule_items[$key]['user']['image']['file_title'] = "";
					$output_schedule_items[$key]['user']['image']['file'] = $file->noimage;
				}
			}
		endforeach;
	endforeach;
}


// GET NETWORK STATISTICS -------------------------------------------------
// We select the network statistics. If the network degree 1 total does not
// match the count of the users relations we need to re-compute the statistics.
// If we have cron we flag cron to do that and warn the user that the stats are
// inaccurate
// Note: None cron installations only display first degree so we update the 
// total and continue.
if (isset($me['user_id'])) {
	$sn->user_id = $me['user_id'];
	$output_sn_statistics['degrees'] = $sn->selSnStatistics();
	
	if ($output_sn_statistics['degrees'][0]['sn_total'] != count($me['relations'])) {
		// recompute 
		$total = count($me['relations']);
		
		if (empty($total)) {
			$total = 0;
		}
			
		if ($c_node['batch']['enabled'] == true) {
			//flag for cron
			$sn->updateSnStatistic(1, $total, 1);
		}
		else {
			//reset degree 1 stats
			$sn->updateSnStatistic(1, $total, null);
		}
		
		$output_sn_statistics['degrees'] = $sn->selSnStatistics();
	}
	
	//get pending IM relations
	$output_pending = $sn->getPendingRelations();
	$output_sn_statistics['total_pending'] = count($output_pending);

	// total users
	$output_sn_statistics['total'] = 0;
	if (!empty($output_sn_statistics['degrees'])) {
		foreach ($output_sn_statistics['degrees'] as $key => $i):
			$output_sn_statistics['total'] = $output_sn_statistics['total'] + $i['sn_total'];
		endforeach;
	}
	
	$output_sn_statistics['total'] = $output_sn_statistics['total'] + count($output_sn_statistics['total_pending']);

}

// get total users and total users online
require_once('class/Statistic.class.php');
$statistic = new Statistic($db);
$statistic->user_status = $c_node['user']['status'];
$output_sn_statistics['statistics'] = $statistic->getAllUserStatistics();



//MOVE TO TEMPLATE
if (!empty($output_latest_contacts)) {
	$body->set('latest_contacts', $output_latest_contacts);
}

if (!empty($output_latest_subject)) {
	$body->set('latest_subject', $output_latest_subject[0]);
}

if (!empty($output_comments)) {
	$body->set('forum_comments', $output_comments);
}

if (!empty($output_blog_entries)) {
	$body->set('blog_entries', $output_blog_entries);
}

if (!empty($output_skill)) {
	$body->set('latest_skill', $output_skill[0]);
}


if (!empty($output_sn_statistics)) {
    $body->set('sn_statistics', $output_sn_statistics);
}

if (!empty($output_recommended_item)) {
    $body->set('recommended_item', $output_recommended_item);
}

if (!empty($output_schedule_items)) {
    $body->set('schedule_items', $output_schedule_items);
}

$body->set('rsp_item_type_ids', $c_node['rsp']['item_type']);
$body->set('schedule_config', $c_node['schedule']);

include "inc/footer.inc.php";

?>
