<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<form action="grp_create.php" method="post" name="frm" id="id_frm">

<div class="box">
	<div class="box_top">
		<?php echo $lang['section_create_group'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<?php
			if (isset($display) && $display == "group_select") {
			?>
			<p class="txt_item_title">
				<?php echo $lang['txt_intro'];?><br />
			</p>
			
			<p>
				<?php echo $lang['txt_intro_help'];?><br />
			</p>
			
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			
			<p>
				<b><?php echo $lang['hdr_group_setup_rules'];?></b><br />
				<?php echo $lang['txt_group_setup_rules'];?><br />
			</p>
			
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
			
			
			<table width="100%" cellpadding="2" cellspacing="0" border="0">
				<tr>
					<td valign="top">
						<input type="radio" name="group_visibility" value="1" checked="checked" /><br />
					</td>
					<td>
						<b><?php echo $lang['sub_visible_group_radio'];?></b><br />
						<?php echo $lang['txt_visible_group_intro'];?><br />
					</td>
				</tr>
				<tr>
					<td valign="top" width="1">
						<input type="radio" name="group_visibility" value="0" /><br />
					</td>
					<td>
						<b><?php echo $lang['sub_hidden_group_radio'];?></b><br />
						<?php echo $lang['txt_hidden_group_intro'];?><br />
					</td>
				</tr>
			</table>
			
			<p align="right">
				<input type="submit" name="create_group" value="<?php echo $lang['sub_apply'];?>" /><br />
			</p>
			
			<?php
			}
			elseif (isset($display) && $display == "group_setup") {
			?>

			<input type="hidden" name ="group_visibility" value="<?php echo $group['group_visibility'];?>">

			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_title'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<input type="text" class="input" name="group_title" size="42" value="<?php if (isset($group['group_title'])) { echo $group['group_title']; }?>" /><br />
					</td>
				</tr>
				<?php
				if (isset($insert_unix_title)) {
				?>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_unix_title'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<input type="text" class="input" name="group_unix_title" size="16" value="<?php if (isset($group['group_unix_title'])) { echo $group['group_unix_title']; }?>" /><br />
						<p><i><?php echo $lang['txt_group_unix_title_hint'];?></i><br /></p>
					</td>
				</tr>
				<?php }?>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_description'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<textarea name="group_synopsis" class="input" rows="2" cols="80"><?php if (isset($group['group_synopsis'])) { echo $group['group_synopsis']; }?></textarea><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<?php
				if (!empty($lang['arr_group']['custom_item'])) {
					foreach ($lang['arr_group']['custom_item'] as $key => $i):
				?>
				<tr>
					<td>
						<?php echo $i;?><br />
					</td>
					<td>
						<input type="text" class="input" name="group_custom_items[<?php echo $key;?>]" size="26" value="<?php if (isset($group['group_custom_items'][$key])) { echo $group['group_custom_items'][$key]; }?>" /><br />
					</td>
				</tr>
				
				
				<?php 
				endforeach;
				?>
				
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<?php }?>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_language'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
					<select name="language_id" size="1">
						<?php 
						if (isset($group['language_id'])) {
						    $language_id = $group['language_id'];
						}
						foreach($lang['arr_lang_name'] as $key => $i): ?>
						<option value="<?php echo $key;?>" <? if($language_id == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
						<?php endforeach; ?>
					</select>
					<br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<?php
				if ($group['group_visibility'] == "1") {
				?>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_registration_type'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<input type="radio" name="group_registration_type" value="<?php echo $group_registration_type['automatic'];?>" checked="checked" />&nbsp;<?php echo $lang['txt_group_registration_automatic'];?><br />
						<input type="radio" name="group_registration_type" value="<?php echo $group_registration_type['approved'];?>" <?php if (isset($group['group_registration_type']) && $group['group_registration_type'] == $group_registration_type['approved']) { echo "checked=\"checked\""; }?> />&nbsp;<?php echo $lang['txt_group_registration_approved'];?><br />
						<input type="radio" name="group_registration_type" value="<?php echo $group_registration_type['closed'];?>" <?php if (isset($group['group_registration_type']) && $group['group_registration_type'] == $group_registration_type['closed']) { echo "checked=\"checked\""; }?> />&nbsp;<?php echo $lang['txt_group_registration_closed'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_age'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php
						if (isset($group['group_from_age'])) {
						    $from_txt = $group['group_from_age'];
						}
						else {
							$from_txt = $lang['txt_age_any'];
						}
						?>
						<?php echo $lang['txt_age_from'];?> <input type="text" size="5" name="group_from_age" value="<?php echo $from_txt;?>">&nbsp;
						<?php
						if (isset($group['group_to_age'])) {
						    $to_txt = $group['group_to_age'];
						}
						else {
							$to_txt = $lang['txt_age_any'];
						}
						?>
						<?php echo $lang['txt_age_to'];?> <input type="text" size="5" name="group_to_age" value="<?php echo $to_txt;?>"><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_group_tags'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<textarea name="tags" rows="2" cols="80"><?php if (isset($group['tags'])) { echo $group['tags']; }?></textarea><br />
					</td>
				</tr>
				
				
				<tr>
					<td colspan="2">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
					</td>
				</tr>
				<?php }?>
				
				<?php
				if (($group['group_visibility'] != "1" && $group_setup['allow_auto_hidden_approval'] != "1") || ($group['group_visibility'] == 1 && $group_setup['allow_auto_visible_approval'] != "1")) {
				?>
				<tr>
					<td colspan="2">
						<?php echo $lang['txt_admin_note'];?><br />
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<textarea name="note" rows="2" cols="80"><?php if (isset($group['note'])) { echo $group['note']; }?></textarea><br />
					</td>
				</tr>
				<?php }?>
				<tr>
					<td align="right" colspan="2">
						<input type="submit" name="insert_group" value="<?php echo $lang['sub_create_group'];?>" /><br />
					</td>
				</tr>
			</table>

			<?php
			}
			elseif (isset($display) && $display == "completed") {
			?>
			<p class="txt_item_title">
				<?php echo $lang['hdr_group_setup'];?><br />
			</p>
			
			<p>
				<?php echo $lang['txt_group_completed'];?><br />
			</p>
			
			<p align="right">
				<a href="grp_view.php?group_id=<?php echo $group_id;?>"><?php echo $lang['href_new_group'];?></a><br />
			</p>

			<?php
			}
			elseif (isset($display) && $display == "completed_pending") {
			?>
			<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<tr>
					<td>
						<?php echo $lang['txt_group_completed_pending'];?><br />
					</td>
				</tr>
			</table>

			<?php }?>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>
