<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


/*
* writeLogFile
* writes output to a text file
* tom calthrop
* 14th June 2005
*/
function writeLogFile($content, $path=null) {
	
	$content = "\n" . date("Y-m-d H:i:s") . "\t " . $content;
	
	if (!isset($path)) {
		$path = "";
	}
	
	$path = $path . "log/";
	
	$filename = "am_" . date('Y_m_d') . ".txt";
	
	//open or make the file
	if(!$handle = fopen($path . $filename, 'a')) {
		$handle = fopen($path . $filename, 'x');
	}
	// Write to file.
	@fwrite($handle, $content);
	//close file
	@fclose($handle);
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);

	return $output;
}


// trimArray ---------------------------------------------------------------
// cuts an array down (used in lists)
// tom calthrop - 07 November 2005
//
function trimArray($arr) {
	
	global $core_config;
	
	if (count($arr) > $core_config['display']['max_list_rows']) {
		if (!isset($_REQUEST['_frm'])) {
			$_REQUEST['_frm'] = 0;
		}
		$new_arr = array_slice($arr, $_REQUEST['_frm'], $core_config['display']['max_list_rows']);
	}
	else {
		$new_arr = $arr;
	}
	
	return $new_arr;
}

// createArrayList ----------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function createArrayList($arr, $url_append=null) {
	
	global $core_config, $lang;
	
	if (isset($url_append)) {
		$url_append = "&" . $url_append;
	}
	else {
		$url_append = "";
	}
	
	if (count($arr) > $core_config['display']['max_list_rows']) {
		//build the url
		$args = array();
		
		foreach($_GET as $key => $i) {
			$args[$key] = $i;
		}
		
		if (isset($args['_frm'])) {
			$from = $args['_frm'];
			unset($args['_frm']);
		}
		else {
			$from = 0;
		}
		
		
		//start button
		$start_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
		if (0 == $from) {
			$start_html = "&lt;&lt;";
		}
		else {
			$start_html = "<a href='" . $start_url . "' title='" . $lang['txt_list_nav_start'] . "'>&lt;&lt;</a>";
		}
		
		//end button
		$num = count($arr)+1;
		while ($num > $core_config['display']['max_list_rows']):
			$num = $num - $core_config['display']['max_list_rows'];
		endwhile;
		
		$num = count($arr)+1 - $num;
		$args['_frm'] = $num;
		if ($from >= $num) {
			$end_html = "&gt;&gt;";
		}
		else {
			$end_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$end_html = "<a href='" . $end_url . "' title='" . $lang['txt_list_nav_end'] . "'>&gt;&gt;</a>";
		}
		
		//next button
		$args['_frm'] = $from + $core_config['display']['max_list_rows'];
		if ($args['_frm'] > count($arr)) {
			$next_html = "&gt;";
		}
		else {
			$next_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$next_html = "<a href='" . $next_url . "' title='" . $lang['txt_list_nav_next'] . "'>&gt;</a>";
		}
		
		//previous button
		$num = $from - $core_config['display']['max_list_rows'];
		
		if ($num < 0) {
			$num = 0;
		}
		$args['_frm'] = $num;
		if ($args['_frm'] == $from) {
			$prev_html = "&lt;";
		}
		else {
			$prev_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args) . $url_append;
			$prev_html = "<a href='" . $prev_url . "' title='" . $lang['txt_list_nav_prev'] . "'>&lt;</a>";
		}
		
		//pages
		$numrows = ceil(count($arr) / $core_config['display']['max_list_rows']);
		$pages_html = "";
		for ($i = 0; $i < $numrows; $i++) {
			$args['_frm'] = $i * $core_config['display']['max_list_rows'];
			$page_url = $_SERVER['SCRIPT_NAME'] . "?" . arrayToString($args);
			
			if ($args['_frm'] == $from) {
				$pages_html .= ($i+1) . "&nbsp;&nbsp;";
			}
			else {
				$pages_html .= "<a href='" . $page_url . "' title='" . ($i+1) . "'>" . ($i+1) . "</a> ";
			}
		}
		
		$out_html = "<p class='listnav'>";
		
		//first page
		$out_html .= $start_html . "&nbsp;&nbsp;";
		
		//previous page
		$out_html .= $prev_html . "&nbsp;&nbsp;";
		
		//pages
		$out_html .= $pages_html;
		
		//next page
		$out_html .= $next_html . "&nbsp;&nbsp;";
		
		//last page
		$out_html .= $end_html;
		
		$out_html .= "</p>";
		
		return $out_html;
	}
}

// arrayToString ---------------------------------------------------------------
// creates a first, previous, next and last button
// tom calthrop - 07 November 2005
//
function arrayToString($arr) {
	$str = "";
	foreach($arr as $key => $i):
		$str .= $key . "=" . $i . "&amp;";
	endforeach;
	
	$str = substr($str, 0, strlen($str)-5);
	
	return $str;
	
}

// htmlspecialchars_decode ---------------------------------------------------------------
// Build in to PHP5, but included here for <5. Used to strip html from RSS descriptions
// tom calthrop - 07 May 2006
//
if (!function_exists('htmlspecialchars_decode')) {
   function htmlspecialchars_decode($str, $quote_style = ENT_COMPAT) {
	   return strtr($str, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $quote_style)));
   }
}

/*
* compare
* general function for usort (used in SocialNetwork.class.php
* 8th January 2005
*/
function compare($a, $b) {

	if($a["degree"]==$b["degree"])
		return 0;
	elseif($a["degree"]<$b["degree"])
		return -1;
	else
		return 1;
}




/*
* searchTextFormat
* takes a search string, highlights it in the supplied txt
* and strips unwanted data
*
* tom calthrop
* 10th April 2004
*/
function searchTextFormat($search, $txt) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",          // Strip out HTML tags
       	"'([\r\n])[\s]+'",                // Strip out white space
       	"'&(quot|#34);'i"                // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search))-20);

	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}

	//make the search word red
	$txt = preg_replace("/($search)/i","<span class='txt_search_highlight'>\\0</span>",$txt);

	return $txt;
}

?>