<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

require_once($language_path_core . 'inc/me_common.inc.php');

if (isset($_POST['update_search_criteria'])) {
	// we set the preference and metadata
	$_POST['user_metadata'] = trim($_POST['user_metadata']);
	
	if(empty($_POST['user_metadata'])) {
		$GLOBALS['am_error_log'][] = array('metadata_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		// update metadata
		$query = "
			SELECT user_metadata 
			FROM " . $db->prefix . "_user 
			WHERE 
			user_id=" . $_SESSION['user_id']
		;
					
		$result = $db->Execute($query);
		
		$rec = array();
		$rec['user_metadata'] =  $_POST['user_metadata'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
		
		// set user preference
		$user->deletetUserPreference($core_config['user']['preference']['allow_sn_search'], $_SESSION['user_id']);
		$user->insertUserPreference($core_config['user']['preference']['allow_sn_search'], $_SESSION['user_id']);
	}
	
}


// SELECT MY METADATA --------------------------------------
$query = "
	SELECT user_metadata 
	FROM " . $db->prefix . "_user 
	WHERE 
	user_id=" . $_SESSION['user_id']
;
			
$result = $db->Execute($query);

if (isset($result->fields)) {
	if (!empty($result->fields['user_metadata'])) {
		$output_my_metadata = $result->fields['user_metadata'];
		$output_my_metadata = explode(',', $output_my_metadata);
		
		$body->set('my_metadata', $output_my_metadata);
		$body->set('my_metadata_string', $result->fields['user_metadata']);
	}
	
}
else {
	$error_info = "File=sn_search.php -- " . $query . " -- " . $db->ErrorMsg();
	$GLOBALS['am_error_log'][] = array('db_error', $error_info);
}


// if we have metadata and we have set out "allow search" preference we allow 
// this user to search on others
if (isset($output_my_metadata) && $user->selUserPreference($_SESSION['user_id'], $core_config['user']['preference']['allow_sn_search'])) {
	
	$body->set('display_allow_search', 1);
	
	// SELECT MY FIRST DEGREE METADATA ------------------
/*	require_once ("class/SocialNetwork.class.php");
	$sn = new SocialNetwork($_SESSION['user_id'], $db);
	
	$degree1_network  = $sn->prepareNetwork(1, $_SESSION['user_id']);
	$degree1_network_user_ids = "";*/
	if (!empty($degree1_network)) {
		foreach($degree1_network[0] as $key => $i):
			$degree1_network_user_ids .= $i . ",";
		endforeach;
		$degree1_network_user_ids = substr($degree1_network_user_ids, 0, -1);
		
		if (!empty($degree1_network_user_ids)) {
	
			$query = "
				SELECT u.user_metadata 
				FROM " . $db->prefix . "_user u, " . $db->prefix . "_user_preference up  
				WHERE 
				u.user_id in(" . $degree1_network_user_ids . ") AND 
				u.user_id=up.user_id AND 
				up.user_preference_id=" . $core_config['user']['preference']['allow_sn_search']
			;
						
			$result = $db->Execute($query);
			
			if (isset($result->fields)) {
			
				$output_degree1_metadata = array();
			
				while (!$result->EOF) {
					$temp1 = $result->fields['user_metadata'];
					if (!empty($temp1)) {
						$temp_arr = explode(',', $temp1);
						$output_degree1_metadata = array_merge($output_degree1_metadata, $temp_arr);
					}
					
					$result->MoveNext();
				}
				
				$result->Close();
				
				$output_degree1_metadata = array_unique($output_degree1_metadata);
				sort($output_degree1_metadata);
				$body->set('degree1_metadata', $output_degree1_metadata);
				
			}
			else {
				$error_info = "File=sn_search.php -- " . $query . " -- " . $db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
		}
	}
		
	// SELECT LOCATIONS ------------------
	$output_locations = $user->selLocations($_SESSION['language_id']);
	$body->set('locations', $output_locations);
	
	
	// SELECT IDENTITY CUSTOM FIELDS ------------------
	if (!empty($core_config['user']['identity']['custom_searchable'])) {
		include_once($language_path . 'inc/identity_common.inc.php');
		$output_custom_fields = array();
		
		foreach($core_config['user']['identity']['custom_searchable'] as $key => $i):
			$output_custom_fields[$core_config['user']['identity']['custom_searchable'][$key]] = $lang['identity']['custom'][$i];
		endforeach;
		
		$body->set('custom_fields', $output_custom_fields);
	}
	
	// COUNT SEARCHABLE USERS -------------------------------------------
	$query = "
		SELECT count(user_id) as total 
		FROM " . $db->prefix . "_user_preference 
		WHERE 
		user_preference_id=" . $core_config['user']['preference']['allow_sn_search']
	;
					
	$result = $db->Execute($query);
	
	$output_count_searchable_users = "0";
	
	if (isset($result->fields)) {
		if (!empty($result->fields['total'])) {
			$output_count_searchable_users = $result->fields['total'];
		}
	}	
	
	$lang['txt_searchable_users'] = str_replace("SYS_KEYWORD_COUNT", $output_count_searchable_users, $lang['txt_searchable_users']);
	
	
	// GET MY TAGS
	require_once('class/Tag.class.php');
	$tag = new Tag($db, null, $core_config['tag']['core']['network']);
	$tag->user_id = $_SESSION['user_id'];
	
	$output_tags = $tag->selTags(1);
	
	if (!empty($output_tags)) {
		$body->set('tags', $output_tags);
	}
	
	// BUILD SEARCH QUERY -----------------------------------------------
	if (isset($_POST['search']) || !empty($_REQUEST['meta'])) {
		// if no search criteria is filled we error
		if(empty($_REQUEST['meta']) && empty($_POST['search_text']) && empty($_POST['tag_body']) && empty($_POST['location_id']) && empty($_POST['custom_fields_id'])) {
			$GLOBALS['am_error_log'][] = array('empty_search');
		}
		elseif (!empty($_REQUEST['meta'])) {
			$query = "
				SELECT u.user_id, i.identity_nic, u.user_metadata, l.location_name, 
				u.user_create_datetime, u.location_id, i.identity_id
				FROM " . $db->prefix . "_user u
				INNER JOIN " . $db->prefix . "_user_location l
				ON u.location_id=l.location_id
				INNER JOIN " . $db->prefix . "_user_identity i
				ON (u.user_id=i.user_id AND i.identity_search=1)
				INNER JOIN " . $db->prefix . "_user_preference up
				ON (up.user_preference_id=" . $core_config['user']['preference']['allow_sn_search'] . " AND u.user_id=up.user_id)
				WHERE u.user_metadata like " . $db->qstr("%" . $_REQUEST['meta'] . "%", get_magic_quotes_gpc()) . " AND 
				1=1 
				ORDER BY 
				i.identity_nic"
			;
			
			// we need to exclude users who have blocked you
			$result = $db->Execute($query);
			
			$output_search_results = array();
			
			if (isset($result->fields)) {
				while (!$result->EOF) {
					$temp1 = $result->fields;
					array_push($output_search_results, $temp1);
					$result->MoveNext();
				}
			}
			
			$body->set('search_results', $output_search_results);
			
		}
		else {
		
			if (isset($_POST['search_text'])) {
				$search_text = "'%" . $_POST['search_text'] . "%'";
			}
		
			$query = "
				SELECT u.user_id, i.identity_nic, u.user_metadata, l.location_name, 
				u.user_create_datetime, u.location_id, i.identity_id
				FROM " . $db->prefix . "_user u
				INNER JOIN " . $db->prefix . "_user_location l
				ON u.location_id=l.location_id
				INNER JOIN " . $db->prefix . "_user_identity i
				ON (u.user_id=i.user_id AND i.identity_search=1)
				INNER JOIN " . $db->prefix . "_user_preference up
				ON (up.user_preference_id=" . $core_config['user']['preference']['allow_sn_search'] . " AND u.user_id=up.user_id) 
				WHERE "
			;
			
			$query .= "(";
			
			if (!empty($_POST['search_text'])) {
				$query .= "i.identity_nic like " . $search_text . " OR ";
			}
			
			if (!empty($_REQUEST['meta'])) {
				$query .= "u.user_metadata like " . $db->qstr("%" . $_REQUEST['meta'] . "%", get_magic_quotes_gpc()) . " OR ";
			}
			elseif (!empty($_POST['search_text'])) {
				$query .= "u.user_metadata like " . $search_text . " OR ";
			}
			
			if (!empty($query_custom_field)) {
				$query .= $query_custom_field . " OR ";
			}
			
			if (!empty($_POST['location_id'])) {
				$query .= "u.location_id=" . $_POST['location_id'] . " OR ";
			}
			
			if (!empty($_POST['tag_body'])) {
				$query .= "
				(u.user_id=t.item_id AND 
				t.tag_type=" . $core_config['tag']['core']['network'] . " AND
				t.tag_body like " . $db->qstr("%" . $_POST['tag_body'] . "%", get_magic_quotes_gpc()) . ") OR "
			;
			}
			
			//remove last OR
			$query = substr($query, 0, -3);
			$query .= ") AND ";
			
			$query .= "1=1 ";
			
			$query .= "ORDER BY " . $_POST['sort_by'];
		
			// we need to exclude users who have blocked you
			$result = $db->Execute($query);
			
			$output_search_results = array();
			
			if (isset($result->fields)) {
				while (!$result->EOF) {
					$temp1 = $result->fields;
					array_push($output_search_results, $temp1);
					$result->MoveNext();
				}
			}
			
			$body->set('search_text', $_POST['search_text']);
			$body->set('search_results', $output_search_results);
		}
		
		$body->set('search_performed', 1);
	}
	
}
else { // no search allowed
	$ouptut_user_search_pref = $user->selUserPreference($_SESSION['user_id'], $core_config['user']['preference']['allow_sn_search'], 1);
	$body->set('user_search_pref', $ouptut_user_search_pref);
}
	
?>