<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";

$lang['txt_policy'] = readTxtFile($language_path . "texts/structure.txt.php");

// WIKI FORMAT POLICY
require_once('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();
//$wiki->disableRule('wikilink');
$lang['txt_policy'] = stripslashes($lang['txt_policy']);
$lang['txt_policy'] = $wiki->transform($lang['txt_policy'], 'Xhtml');

// we display a list of roles in the structure
if (!empty($core_config['role']['display']['structure'])) {
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	
	if (isset($_SESSION['user_id'])) {
		$file->user_id = $_SESSION['user_id'];
	}
	$file->module_id = 0; // core
	$file->core_config_module = $core_config['module'];
	$file->thumbs = $core_config['file']['image']['thumb'];
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file = $file;
	
	$user->identity_type = $core_config['user']['identity']['type']['registered'];
	
	$output_roles = array();
	
	foreach($core_config['role']['display']['structure'] as $key => $i):
		$tmp = array();
		$tmp['role_id'] = $i;
		
		$user->role_id = $i;
		
		$tmp['identities'] = $user->selUserIdentities();
		
		array_push($output_roles, $tmp);
	endforeach;
	
	$body->set('roles', $output_roles);
	
}


?>