<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Css {
	// contains all methods to manipulate CSS styles held in database
	
	
	// parseCSS --------------------------------------------------------------------
	// takes stylesheet and converts each style into array
	// tom calthrop - 20th October 2006
	//
	function parseCSS ($stylesheet) {
		$css = array();
		
		// pull out all styles
		$pattern = '/(.*?)\}/';
		if (preg_match_all($pattern, $stylesheet, $styles)) {
			
			foreach($styles[0] as $key => $i):
				// pull out each style name from the style
				$pattern = '/(.*?)\{/';
				if (preg_match($pattern, $i, $style_name)) {
					// is the style name allowable?
					$parse_style = false;
					
					foreach ($this->css_config['space_stylesheet'] as $key => $a):
						$pattern = '/' . $a['style'] . '/';	
						if (preg_match($pattern, $style_name[1])) {
							$parse_style = true;
							break;
						}
					endforeach;		
					
					if ($parse_style == true) {
					
						// strip #sheet or .sheet to be sheet
						$strip = array(" ", "#", ".");
						$css_short_name = str_replace($strip, "", $style_name[1]);
						
						$css['sheet'][$css_short_name]['short_name'] = $css_short_name;
						$css['sheet'][$css_short_name]['name'] = $style_name[1];
						
						// extract syle elements
						$pattern = '/\{(.*?)\}/';
						if (preg_match($pattern, $i, $style_elements)) {
						
						$css['sheet'][$css_short_name]['style'] = $style_elements[1];
						}
						
						$elements = explode(";", $style_elements[1]);
						
						if (!empty($elements)) {
							foreach($elements as $key => $e):
								$element = explode(":", $e);
								
								if (!empty($element[0])) {
									$elmt = trim($element[0]);
									$val = trim($element[1]);
									$css['sheet'][$css_short_name]['elements'][$elmt]['value'] = $val;
									
									// if it is an image we need to pull out the value
									// url(get_file.php?file=322bad0b2c59f1cd002f370746680c13&type=image/gif&directory=core/)
									$pattern = '/file=(.*?)\)/';
									if (preg_match($pattern, $val, $element_value)) {
										$css['sheet'][$css_short_name]['elements'][$elmt]['value_url'] = $element_value[1];
									}
									
									// get the file
									$pattern = '/file=(.*?)\&/';
									if (preg_match($pattern, $val, $element_value)) {
										$css['sheet'][$css_short_name]['elements'][$elmt]['file'] = $element_value[1];
									}
														
								}
							endforeach;
						}
						
						// extract aroundme_space_block number
						$pattern = '/aroundme_space_block(.?[0-9]{1,2})/';
						if (preg_match($pattern, $css_short_name, $style_id)) {
							$css['sheet'][$css_short_name]['aroundme_space_block_id'] = $style_id[1];
							
							// we append the array with a "next block id" (the id we use if we add a block to this css
							if (!isset($css['next_block']) || $css['next_block'] < $style_id[1]+1) {
								$css['next_block'] = $style_id[1]+1;
							}
						}
					}
				}
			endforeach;
		}
		
		return $css;
	
	} //EO parseCSS
	
	
	
	// renderCSS --------------------------------------------------------------------
	// takes a set of form vars, checks them and if ok renders them as a single css style
	// tom calthrop - 20th October 2006
	//
	function renderCSS ($style_name, $style_content) {
		$style = "";
		
		// is the style allowed
		$parse_style = false;
					
		foreach ($this->css_config['space_stylesheet'] as $key => $a):
			if ($style_name == $a['style']) {
				$render_style = true;
				break;
			}
		endforeach;		
		
		if ($render_style == true) {
			
			
			if (!empty($style_content['text_color'])) {
				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $style_content['text_color'])) {
					$style .= "color:" . $style_content['text_color'] . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $style_content['text_color']);
				}
			}
			
			if (!empty($style_content['background-img'])) {
				
				if (!empty($style_content['background-img'])) {
					$url = "get_file.php?file=" . $style_content['background-img'] . "&directory=core/";
					$style .= "background-img: url(" . $url . ");";
				}
			}
			
			if (!empty($style_content['background-color'])) {
				
				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $style_content['background-color'])) {
					$style .= "background-color:" . $style_content['background-color'] . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $style_content['background-color']);
				}
			}
			
			if (!empty($style_content['border_color'])) {
				if(preg_match('/^#+[A-Za-z0-9]{6}$/', $style_content['border_color'])) {
					$style .= "border-color:" . $style_content['border_color'] . ";";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_color_incorrect', $style_content['border_color']);
				}
			}
			
			if (!empty($style_content['border_size'])) {
				if(preg_match('/^[0-9]{1,2}$/', $style_content['border_size'])) {
					$style .= "border:solid " . $style_content['border_size']. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $style_content['border_size']);
				}
			}
			
			if (!empty($style_content['text_size'])) {
				if(preg_match('/^[0-9]{1,3}$/', $style_content['text_size'])) {
					$style .= "font-size:" . $style_content['text_size']. "%;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $style_content['text_size']);
				}
			}
			
			if (!empty($style_content['padding'])) {
				if(preg_match('/^[0-9]{1,2}$/', $style_content['padding'])) {
					$style .= "padding:" . $style_content['padding']. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $style_content['padding']);
				}
			}
			
			if (!empty($style_content['margin'])) {
				if(preg_match('/^[0-9]{1,2}$/', $style_content['margin'])) {
					$style .= "margin:" . $style_content['margin']. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_number_incorrect', $style_content['margin']);
				}
			}
			
			if (!empty($style_content['width'])) {
				if(preg_match('/^[0-9]{2,3}$/', $style_content['width'])) {
					$style .= "width:" . $style_content['width']. "px;";
				}
				else {
					$GLOBALS['am_error_log'][] = array('css_width_incorrect', $style_content['width']);
				}
			}
			
			if (!empty($style_content['float'])) {
				$style .= "float:" . $style_content['float']. ";";
			}
		}
		
		return $style;
	} //EO renderCSS
	
	
	
	// updateCSS --------------------------------------------------------------------
	// we update the style with the elements in the stylesheet
	// tom calthrop - 20th October 2006
	//
	function updateCSS ($style_name, $style_sheet, $style_content) {
		// we delete the style from the sheet
		$pattern = "/" . $style_name . " \{(.*?)\}/";
		
		if (preg_match($pattern, $style_sheet)) {
			$style_sheet = preg_replace($pattern, "", $style_sheet);
			$style_sheet = str_replace("\n\n", "\n", $style_sheet);
		}
		
		$style_sheet = trim ($style_sheet);
		
		// we insert
		// what kind of style is this?
		foreach ($this->css_config['space_stylesheet'] as $key => $a):
			if ($style_name == $a['style']) {
				$style_type = $a['style_type'];
				break;
			}
		endforeach;
		
		if (isset($a['style_type']) && $a['style_type'] == "id") {
			$style_name = "#" . $style_name;
			
			$style = $style_name . " {" . $style_content . "}\n";
		
			$style_sheet = $style_sheet . $style;
		}
		elseif (isset($a['style_type']) && $a['style_type'] == "class") {
			$style_name = "." . $style_name;
			
			$style = $style_name . " {" . $style_content . "}\n";
		
			$style_sheet = $style_sheet . $style;
		}
		else { // html
			$style = $style_name . " {" . $style_content . "}\n";
		
			$style_sheet = $style . $style_sheet;
		}
		
		
	
	
		return $style_sheet;
		
		
	} //EO updateCSS
}
?>
