<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";


if (!isset($_REQUEST['contact_id'])) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

if (isset($_POST['update_contact'])) {
	updateContactReport($_POST);
}


// SETUP WIKI ------------------------------------------------------------
require_once('components/core/class/Wiki/Wiki.php');
require_once ('components/core/class/Wiki/Wiki/Parse.php');
require_once ('components/core/class/Wiki/Wiki/Render.php');
$wiki = new Text_Wiki();

if (isset($_SESSION['user_id'])) {
	if ($user->selUserPreference($_SESSION['user_id'], $core_config['user']['preference']['use_new_window'])) {
		$wiki->setRenderConf('xhtml', 'url', 'target', '_blank');
	}
}


// SETUP COMMENTS --------------------------------------------------------
require_once('components/core/class/Comment.class.php');
$comment = new Comment($db, $core_config);
$comment->wiki = $wiki;
$comment->module_id = 0;


$output_contact_report = selContactReport($_REQUEST['contact_id']);

if (isset($output_contact_report)) {
	$body->set('contact_report', $output_contact_report);
	
	if (!empty($output_contact_report['reportee_user_id'])) {
		// get reporter
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->user_id = $_SESSION['user_id'];
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
		$output_identity = $user->selUserIdentity($output_contact_report['reportee_user_id'], null, 1);
	
		$body->set('identity', $output_identity);
	}
	else {
		$lang['email_contact_report'] = str_replace("SYS_KEYWORD_EMAIL", $output_contact_report['reportee_email'], $lang['email_contact_report']);
	}
	
	$output_maintainers = selMaintainers();
	$body->set('maintainers', $output_maintainers);
	
	
	// SET AND GET COMMENTS ----------------------------------------------
	if (isset($_POST['insert_comment'])) {
		$comment->user_id = $_SESSION['user_id'];
		$comment->item_id = $output_contact_report['contact_id'];
		$comment->item_user_id = $output_contact_report['reportee_user_id'];
		$comment->insertComment($_POST);
	}
	if (isset($_POST['preview_comment'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
		$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
		$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
		
		$body->set('comment', $output_comment);
		$body->set('display', 'preview_comment');
	}
	elseif (isset($_POST['edit_comment_again'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
		$body->set('comment', $output_comment);
	}
	
	$query = "
		SELECT c.comment_id, c.comment_parent_id, c.comment_body, c.user_id, 
		c.item_id, c.comment_create_datetime, c.module_id, c.item_id, c.inner_item_id, 
		i.identity_id, i.identity_nic, u.user_create_datetime, c.inner_item_revision 
		FROM " . $db->prefix . "_user_identity i, " . $db->prefix . "_comment c, " . $db->prefix . "_user u
		WHERE 
		c.user_id=u.user_id AND u.user_id=i.user_id AND 
		i.identity_type=" . $core_config['user']['identity']['type']['registered'] . " AND 
		module_id=0 AND item_id=" . $output_contact_report['contact_id']
	;
	
	$result = $db->Execute($query);
	
	$output_comments = array();
	
	if (isset($result->fields)) {
		
		while (!$result->EOF) {
			$temp = $result->fields;
			$temp['participation_create_datetime'] = $temp['user_create_datetime'];
			array_push($output_comments, $temp);
			
			$result->MoveNext();
		}
	}
	
	$body->set('comments', $output_comments);
}


/*
* selContactReport
* Tom Calthrop 29th September 2006
*/
function selContactReport($contact_id) {
	
	global $db;
	
	$query = "
		SELECT contact_id, reportee_user_id, contact_report_type, 
		reportee_language_id, report_datetime, report_status_id, 
		reportee_email, contact_message, contact_source, 
		contact_url, assigned_user_id 
		FROM " . $db->prefix . "_contact 
		WHERE
		contact_id=" . $contact_id
	;
	
	$result = $db->SelectLimit($query, 1); //returns last 1 rows
	
	if (isset($result->fields)) {
		
		$temp = $result->fields;
		
		return $temp;
	}
}


/*
* selMaintainers
* Tom Calthrop 29th September 2006
*/
function selMaintainers() {
	
	global $db, $core_config, $user;
	
	require_once('class/User.class.php');
	$user = new User($db, $core_config['user']);
		
	$query = "
		SELECT user_id, user_core_permission  
		FROM " . $db->prefix . "_user 
		WHERE
		user_core_permission>0"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		
		unset ($user->user_ids);
		while (!$result->EOF) {
			if($result->fields['user_core_permission'] & $core_config['resource']['user']['mng_contacts']) {
				$user->user_ids[] = $result->fields['user_id'];
			}
			
			$result->MoveNext();
		}
	}
	
	// GET IDENTITIES FOR EACH MAINTAINER
	if (!empty($user->user_ids)) {	
		require_once ("class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->module_id = 0; // core
		$file->directory = "core";
		
		$user->file = $file;
		$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
		
		$user->identity_type = $core_config['user']['identity']['type']['registered'];
		
		
		$user->order_by = "i.identity_type desc";
		
		return $user->selUserIdentities();
	}
}


/*
* updateContactReport
* Tom Calthrop 29th September 2006
*/
function updateContactReport($data) {
	
	global $db;
	
	$query = "
		SELECT contact_id, report_status_id, assigned_user_id 
		FROM " . $db->prefix . "_contact 
		WHERE
		contact_id=" . $data['contact_id']
	;
	
	$result = $db->SelectLimit($query, 1); //returns last 1 rows
	
	if (!isset($data['assigned_user_id']) || $data['assigned_user_id'] < 1) {
		$data['assigned_user_id'] = "null";
	}
	
	if (isset($result->fields)) {
		
		$rec = array();
		$rec['report_status_id'] =  $data['report_status_id'];
		$rec['assigned_user_id'] =  $data['assigned_user_id'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}

?>