<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";

if (isset($_POST['update_location'])) {
	// we insert or update the language
	if (!empty($_POST['location_id'])) {
		updateLocation($_POST);
	}
	else {
		insertLocation($_POST);
	}
		
}
elseif (isset($_POST['delete_location'])) {
	// we select the language
	deleteLocation($_POST['location_id']);
}
elseif (isset($_REQUEST['location_id'])) {
	// we select the language
	$output_location = selLocation($_REQUEST['location_id']);
	$body->set('location', $output_location);
}

$output_locations = selLocations();
$body->set('locations', $output_locations);



/*
* selLocations
* Tom Calthrop 29th September 2006
*/
function selLocations() {
	
	global $db;
	
	$query = "
		SELECT location_id, language_id, location_name 
		FROM " . $db->prefix . "_user_location 
		ORDER BY location_name"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		
		$temp = array();
		
		while (!$result->EOF) {
			$temp1 = $result->fields;
			
			array_push($temp, $temp1);
			
			$result->MoveNext();
		}
		
		return $temp;
	}
}


/*
* selLocation
* Tom Calthrop 29th September 2006
*/
function selLocation($location_id) {
	
	global $db;
	
	$query = "
		SELECT location_id, language_id, location_name 
		FROM " . $db->prefix . "_user_location 
		WHERE location_id=" . $location_id
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		
		return $result->fields;
	}
}


/*
* updateLocation
* Tom Calthrop 29th September 2006
*/
function updateLocation($data) {
	
	global $db;
	
	$query = "
		SELECT location_id, language_id, location_name 
		FROM " . $db->prefix . "_user_location 
		WHERE location_id=" . $data['location_id']
	;
	
	$result = $db->SelectLimit($query, 1);
		
	if (isset($result->fields)) {
		
		$rec = array();
		$rec['language_id'] = $data['language_id'];
		$rec['location_name'] = $data['location_name'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}


/*
* insertLocation
* Tom Calthrop 29th September 2006
*/
function insertLocation($data) {
	
	global $db;
	
	$rec = array();
	$rec['language_id'] = $data['language_id'];
	$rec['location_name'] = $data['location_name'];
		
	$table = $db->prefix . "_user_location";
			
	$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
	$result = $db->Execute($query);
}


/*
* deleteLocation
* Tom Calthrop 29th September 2006
*/
function deleteLocation($location_id) {
	
	global $db;
	
	$query = "
		DELETE 
		FROM " . $db->prefix . "_user_location 
		WHERE location_id=" . $location_id
	;
	
	$result = $db->Execute($query);
}
?>