<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";
$my_testimonials = false;
require_once($language_path_core . 'inc/me_common.inc.php');

if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

// Check my testimonials or a users?
if (!isset($module_id) && !isset($_REQUEST['item_id']) && !isset($_REQUEST['identity_id'])) {
	$my_testimonials = true;
}
else {
	
	$output_identity_relation = $user->selUserIdentity(null, $_REQUEST['identity_id'], 1);

	if (empty($output_identity_relation)) {
		header("Location: index.php?" . strip_tags(SID));
		exit;
	}

	
		
	$item_id = $output_identity_relation['identity_id'];

	if (!empty($output_participation)) {
		$output_identity = $user->selUserIdentity(null, $output_participation['identity_id'], 1);
	}
	else { // we are not participating in this item/module hence we get my registered card
		$user->identity_type = $core_config['user']['identity']['type']['registered'];
		$output_identity = $user->selUserIdentity($_SESSION['user_id'], null, 1);
	}
}

// setup the file ----------------------------------------------------------------------
require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);
$file->module_id = 0;
$file->directory = "core";
$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];

// handle the user the file
$user->file = $file;

// setup the testimonial ----------------------------------------------------------------
require_once ("class/Testimonial.class.php");
$testimonial = new Testimonial($db);

if (!$my_testimonials) {
	$testimonial->identity_id = $item_id;
	$testimonial->testifier_identity_id = $output_identity['identity_id'];
}
else {
	$output_testimonials['received'] = array();
	$output_testimonials['written'] = array();
	$identities = $user->selUserIdentities($_SESSION['user_id']);
	foreach($identities as $i) {
		$testimonial->identity_id = $i['identity_id'];
		$t = $testimonial->selTestimonials();
		
		foreach($t as $v) {
			array_push($output_testimonials['received'], $v);
		}
		$t = $testimonial->selTestimonials(false);
		foreach($t as $v) {
			array_push($output_testimonials['written'], $v);
		}
	}
	
}

if (isset($_POST['frm_submit'])) {

	if (isset($_POST['frm_testimonial'])) {
		require_once('components/core/class/Kses/kses.php');
		
		$_POST['frm_testimonial'] = kses_parse($_POST['frm_testimonial'], 'min');
		
		$testimonial->setTestimonial($_POST['frm_testimonial']);
		if ($testimonial->isOk()) {
			
			$testimonial->insertTestimonial();
		}
	}
}
elseif (isset($_REQUEST['delete'])) {
	$testimonial->deleteTestimonial($_REQUEST['delete']);
	header("location: index.php?amn=core_testimonial");
	exit;
}

if (!$my_testimonials) {
	$output_identity = $user->selUserIdentity(null, $_REQUEST['identity_id']);
}

if (!$my_testimonials) {
	$output_testimonials['received'] = $testimonial->selTestimonials();
	$output_testimonials['written']  = $testimonial->selTestimonials(false);
}

if (isset($output_identity)) {
	$body->set("identity", $output_identity);
}

if (isset($output_testimonials)) {
	$body->set("testimonials", $output_testimonials);
}	


?>