<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include dirname(__FILE__) . "/../components/core/config/aroundme_core.config.php";
include "config/batch.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once(dirname(__FILE__) . '/../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];


	$chart           = ImageCreate($batch_config['latest_activity']['width'], $batch_config['latest_activity']['height']);
	$backgroundcolor = ImageColorAllocate($chart, $batch_config['latest_activity']['color']['grids_background']['red'], $batch_config['latest_activity']['color']['grids_background']['green'], $batch_config['latest_activity']['color']['grids_background']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $batch_config['latest_activity']['color']['grids']['red'], $batch_config['latest_activity']['color']['grids']['green'], $batch_config['latest_activity']['color']['grids']['blue']);
	$gridscolor_bg   = ImageColorAllocate($chart, $batch_config['latest_activity']['color']['grids_background']['red'], $batch_config['latest_activity']['color']['grids_background']['green'], $batch_config['latest_activity']['color']['grids_background']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $batch_config['latest_activity']['color']['foreground']['red'], $batch_config['latest_activity']['color']['foreground']['green'], $batch_config['latest_activity']['color']['foreground']['blue']);
	$chart_bg = ImageColorAllocate($chart, $batch_config['latest_activity']['color']['background']['red'], $batch_config['latest_activity']['color']['background']['green'], $batch_config['latest_activity']['color']['background']['blue']);
	
	$stamp = date('Y-m-d H:i:s', strtotime("-1 day"));
	$y_values = array(); // we need to init y_values
	for ($i=288;$i>0;$i--){
		array_push($y_values, array('session_lastused' => date('Y-m-d H:i:s', time() - 24*60*60 + 5*60*$i), 'total' => 0));
	}

	$query = "
		SELECT session_lastused, session_firstused 
		FROM " . $db->prefix . "_user_session 
		WHERE session_lastused > '" . $stamp . "' AND
		session_ip IS NOT null
		ORDER BY session_lastused DESC"
	;

	$result = $db->Execute($query);
	$max_val = 0;
	if (isset($result->fields)) {
		while(!$result->EOF) {
			foreach($y_values as $key => $i) {
				if ($result->fields['session_lastused'] >= $i['session_lastused']) {
					if ($result->fields['session_firstused'] < $i['session_lastused']) {
						$y_values[$key]['total']++;
						$max_val = $max_val < $y_values[$key]['total'] ? $y_values[$key]['total'] : $max_val;
					}
				}
			}
			$result->moveNext();
		}
		$result->Close();
	}
	
	$z = ($batch_config['latest_activity']['width'] - $batch_config['latest_activity']['padding']['left'] - $batch_config['latest_activity']['padding']['right']) / 288;
	$f = ($batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top']*2 - $batch_config['latest_activity']['padding']['bottom']) / $max_val;

	imagefilledrectangle($chart, $batch_config['latest_activity']['padding']['left']+1, 0, $batch_config['latest_activity']['width'], $batch_config['latest_activity']['height'] - 2*$batch_config['latest_activity']['padding']['bottom'], $chart_bg);

	for($i = 0; $i < count($y_values) - 1; $i++) {
		$y1 = $batch_config['latest_activity']['height'] - $f*$y_values[$i]['total'] - $batch_config['latest_activity']['padding']['bottom'] - $batch_config['latest_activity']['padding']['top'] -1;
		$y2 = $batch_config['latest_activity']['height'] - $f*$y_values[$i + 1]['total'] - $batch_config['latest_activity']['padding']['bottom'] - $batch_config['latest_activity']['padding']['top'] - 1;
		$x1 = $z*$i + $batch_config['latest_activity']['padding']['left'];
		
		if ($y_values[$i]['total'] != $y_values[$i + 1]['total']) {
			$x2 = $z*($i+0) + $batch_config['latest_activity']['padding']['left'];
		}
		else {
			$x2 = $z*($i+1) + $batch_config['latest_activity']['padding']['left'];
		}
		
		imageline($chart, $x1+1, $y1, $x2+1, $y2, $foregroundcolor);
	}
	
// 	imagefilledrectangle($chart, 0, 0, $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['height'], $gridscolor_bg);
// 	imagefilledrectangle($chart, 0, $batch_config['latest_activity']['height'] - 2*$batch_config['latest_activity']['padding']['bottom'], $batch_config['latest_activity']['width'], $batch_config['latest_activity']['height'], $gridscolor_bg);
	
	imageline($chart, 1 + $batch_config['latest_activity']['padding']['left'], 1 + $batch_config['latest_activity']['padding']['top'] , 1 + $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top'] - $batch_config['latest_activity']['padding']['bottom'], $gridscolor);
	imageline($chart, 1 + $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top'] - $batch_config['latest_activity']['padding']['bottom'], $batch_config['latest_activity']['width'] - $batch_config['latest_activity']['padding']['right'], $batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top'] - $batch_config['latest_activity']['padding']['bottom'], $gridscolor);
	imageline($chart, 1 + $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['padding']['top'], 5 + $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['padding']['left'], $gridscolor);

	for($i=0;$i<=24;$i++) {
		$x1 = $batch_config['latest_activity']['padding']['left'] + $i*12*$z;
		$x2 = $x1;
		$y1 = $batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top'] - $batch_config['latest_activity']['padding']['bottom'];
		$y2 = $y1 - 3;
		imageline($chart, $x1, $y1, $x2, $y2, $gridscolor);
		
		if ($i == 0 || $i == 12 || $i == 24) {
			imagestring($chart, 1, $x1 - 5, $batch_config['latest_activity']['height'] - $batch_config['latest_activity']['padding']['top'] - $batch_config['latest_activity']['padding']['bottom'], -$i, $gridscolor);
		}
	}

	imagestring($chart, 0, 1, $batch_config['latest_activity']['padding']['top'], intval($max_val/0.75), $gridscolor);
	
	imagestring($chart, 1, $batch_config['latest_activity']['padding']['left'], $batch_config['latest_activity']['height'] - 10, date('Y-m-d h:i:s'), $gridscolor);
	imagepng($chart, $batch_config['latest_activity']['name']); 
	imageDestroy($chart);
}
?>