<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class UserLedger {

	// Rate --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd November 2006
	//
	function UserLedger($db, $config) {
		$this->db = $db;
		$this->config = $config;
	}



	// selUserLedger --------------------------------------------------------------------
	// selects a single  User Ledger
	// tom calthrop - 5th Febuary 2007
	//
	function selUserLedger($user_id=null) {

		$query = "
			SELECT ledger_id, user_id, ledger_net, ledger_type, ledger_payment_date,
			ledger_expiry_date, ledger_note
			FROM " . $this->db->prefix . "_user_ledger 
			WHERE "
		;
		
		if (!empty($user_id)) {
		    $query .= "user_id=" . $user_id . " AND ";
		}
		
		if (isset($this->ledger_type)) {
		    $query .= "ledger_type=" . $this->ledger_type . " AND ";
		}

		if (isset($this->ledger_payment_date)) {
			$query .= "ledger_payment_date>" . $this->db->DBDate($this->ledger_payment_date) . " AND ";
		}
		
		if (isset($this->ledger_expiry_date)) {
			$query .= "ledger_expiry_date<" . $this->db->DBDate($this->ledger_expiry_date) . " AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by ledger_payment_date";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "method=selUserLedger class=UserLedger.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selUserLedger



	// selUserLedger --------------------------------------------------------------------
	// selects a single  User Ledger
	// tom calthrop - 5th Febuary 2007
	//
	function selUserLedgerItem($ledger_id) {

		$query = "
			SELECT ledger_id, user_id, ledger_net, ledger_type, ledger_payment_date,
			ledger_expiry_date, ledger_note
			FROM " . $this->db->prefix . "_user_ledger 
			WHERE
			ledger_id=" . $ledger_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			return $temp;
		}
		else {
			$error_info = "method=selUserLedgerItem class=UserLedger.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selUserLedgerItem



	// updateUserLedgerItem --------------------------------------------------------------------
	// inserts or updates a user ledger item
	// tom calthrop - 23rd November 2006
	//
	function updateUserLedgerItem($data) {
		
		$rec = array();
		$rec['user_id'] = $data['user_id'];
		$rec['ledger_net'] = $data['ledger_net'];
		$rec['ledger_payment_date'] = $this->db->DBDate($data['ledger_payment_date']);
		$rec['ledger_type'] = $data['ledger_type'];
		
		if (!empty($data['ledger_expiry_date'])) {
			$rec['ledger_expiry_date'] = $this->db->DBDate($data['ledger_expiry_date']);
		}

		if (!empty($data['ledger_note'])) {
			$rec['ledger_note'] = $data['ledger_note'];
		}
		
		if (!empty($data['ledger_id'])) { // we update
			$query = "
				SELECT * 
				FROM " . $this->db->prefix . "_user_ledger 
				WHERE ledger_id=" . $data['ledger_id']
			;
			
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
			}

		}
		else { // we insert
			$table = $this->db->prefix . "_user_ledger";
		
			$query = $this->db->getInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
		}
	} //EO updateUserLedgerItem
}
?>
