<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


$query = "
	SELECT COUNT(comment_id) AS total
	FROM " . $db->prefix . "_comment
	WHERE MATCH(comment_body) AGAINST (" . $db->qstr($search_text) . ") AND
	webspace_id=" . $_REQUEST['ws']
;
$result = $db->Execute($query, 1);

if ($result) {
	$total = $result[0]['total'];
	$body->set('total_nr_of_rows', $total);
}

$query = "
	SELECT MATCH(comment_body) AGAINST (" . $db->qstr($search_text) . ") AS score
	FROM " . $db->prefix . "_comment
	WHERE MATCH(comment_body) AGAINST (" . $db->qstr($search_text) . ") AND
	webspace_id=" . $_REQUEST['ws'] . "
	ORDER BY score DESC"
;
$result = $db->Execute($query, 1);

if ($result) {
	$max = $result[0]['score'];
}


$query = "
	SELECT comment_id, webspace_id, webpage_id, plugin_name as item_title,
	plugin_item_id, comment_body as item_body,
	MATCH(comment_body) AGAINST (" . $db->qstr($search_text) . ") AS score
	FROM " . $db->prefix . "_comment
	WHERE MATCH(comment_body) AGAINST (" . $db->qstr($search_text) . ") AND
	webspace_id=" . $_REQUEST['ws'] . "
	ORDER BY score DESC"
;

$from = isset($_GET['_frm']) ? (int) $_GET['_frm'] : 0;

$result = $db->Execute($query, $core_config['display']['max_list_rows'], $from);

if (!empty($result)) {
	foreach($result as $key => $r) {
		$result[$key]['percentage'] = round(($r['score'] / $max) * 100);


		$url = "index.php?ws=" . $r['webspace_id'] . "&amp;wp=" . $r['webpage_id'];
			
		// append link with correct item type
		if (isset($r['item_title'])) {

			if (is_file("components/" .$r['item_title'] . "/inc/plugin_item_declaration.inc.php")) {
				include_once ("components/" . $r['item_title']. "/inc/plugin_item_declaration.inc.php");

				$function_name = "am_plugin_" . $r['item_title'] . "_getItemTableName";

				if (function_exists($function_name)) {
					$item_item_url = $function_name();
					$url .= "&amp;" . $item_item_url . "=" . $r['plugin_item_id'];
				}
			}
		}

		$url .= "#comment_id" . $r['comment_id'];

		$result[$key]['link'] = $url;
	}
	$search_result = $result;
}
else {
	$search_result = array();
}

?>