<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

// HEADER ------------------------------------------------------------------
include ("config/core.config.php");
include ("inc/functions.inc.php");


// SETUP DATABASE ------------------------------------------------------
require_once('class/Db.class.php');
$db = new Database($core_config['db']);


// START SESSION -----------------------------------------------------------
session_name($core_config['node']['php_session_name']);
session_start();

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_stylesheet', $_SESSION['connection_permission'])) {

	// temp
	$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
	
	
	// SETUP TEMPLATE -------------------------------------------------------------------
	$template_path = "template/";
	
	require_once('class/Template.class.php');
	$tpl = & new Template();
	
	
	if (isset($_POST['update_webspace_css'])) {
		// build the style
		$style = "";
		
		if ($_POST['mode'] == "expert") {
			//
			$style .= $_POST['webspace_css_simple'] . "\n\n";
			$style .= "/* expert */\n";
			$style .= $_POST['webspace_css_expert'];

			
		}
		else {
			// we obtain the style
			if (!empty($_POST['style_dir_name']) && $_POST['style_dir_name'] != "none") {

				$style_body = @file_get_contents(dirname(__FILE__) . "/template/themes/" . $_POST['style_dir_name'] . "/style.css");

				$style .= "/* simple:" . $_POST['style_dir_name'] . " */\n";
				$style .= $style_body . "\n\n";
				$style .= "/* expert */\n";
				$style .= stripslashes($_POST['webspace_css_expert']);

			}
			else {
				$style .= "/* expert */\n";
				$style .= stripslashes($_POST['webspace_css_expert']);
			}
		}
		
		$query = "
			UPDATE " . $db->prefix . "_webspace
			SET
			webspace_css=" . $db->qstr($style) . "
			WHERE webspace_id=" . $_POST['ws']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result)) {
			$tpl->set('update_mother', 1);
		}
	}
	
	$query = "
		SELECT webspace_css, webspace_id
		FROM " . $db->prefix . "_webspace
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result) && isset($result[0]['webspace_id'])) {

		// we attempt to split the style sheet
		// stylesheets can contain the following strings:
		
		/* simple:matrix */
		/* expert */

		// if non are found it is assumed that the contents of the css is presented in 'expert' mode
		
		$style = $result[0]['webspace_css'];

		$styles = explode("/* expert */", $style);

		$style_simple = "";
		$style_expert = "";
		
		if (!empty($styles[1])) {
			$style_simple = trim($styles[0]);
			$style_expert = trim($styles[1]);
		}
		else {
			$style_expert = trim($styles[0]);
		}
			
		if (!empty($style_simple)) {
			// we attempt to find the name of the style
			$pattern = "/\/\* simple:(.*?) \*\//";
				
			if (preg_match_all($pattern, $style_simple, $style_dir_name_arr)) {
				
				if (!empty($style_dir_name_arr[1])) {
					$tpl->set('style_dir_name', $style_dir_name_arr[1][0]);
				}
			}
		}
		
		$output_webspace = $result[0];

		$output_webspace['style_simple'] = $style_simple;
		$output_webspace['style_expert'] = $style_expert;
	}
	
	
	// get language include files and create language array
	$lang = array();
	$language_path = "language/" . $_SESSION['language_code'] . "/";
	require_once($language_path . 'popup_stylesheet.lang.php');

	
	if (isset($_REQUEST['view']) && $_REQUEST['view'] == "expert") {

		$tpl->set('display', "expert");
	}
	else {
		$output_styles = array();
		
		// obtain the styles
		foreach (glob(dirname(__FILE__) . '/template/themes/*/language/' . $_SESSION['language_code'] . '/style.lang.php') as $f):

			unset ($lang['style_title'], $style_temp);
			
			// GET NAME
			$pattern = "/template\/themes\/(.*?)\/language/";
		
			if (preg_match ($pattern, $f, $dname)) {
				if (!empty($dname[1])) {

					include_once($f);
					
					$style_temp['name'] = $dname[1];
					
					if (isset($lang['style_title'])) {
						$style_temp['title'] = $lang['style_title'];
					}
					else {
						$style_temp['title'] = "";
					}

					array_push ($output_styles, $style_temp);
				}
			}
		endforeach;

		if (!empty($output_styles)) {
			$tpl->set('styles', $output_styles);
		}

		$output_webspace['style_expert'] = htmlspecialchars($style_expert);
	}
	
	
	// APPLY VARS TO TEMPLATES -----------------------------------------------
	$tpl->set('lang', $lang);
	$tpl->set('template_path', $template_path);
	$tpl->set('webspace', $output_webspace);
	
	echo $tpl->fetch($template_path . 'popup_stylesheet.tpl.php');
}
?>