<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


include_once('config/core.config.php');

// SESSION HANDLER ----------------------------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['php']['session_name']);
session_start();


if (isset($_REQUEST['audio']) && $_REQUEST['audio'] == 1) {
	//Create a CAPTCHA
	$text = $_SESSION['text'];

	// create verbal
	$verbal = "";
	
	for ($i = 0; $i < strlen($text); $i++) {
		$verbal .= "'" . substr($text, $i, 1) . "',";
	}
	
	shell_exec("echo \"" . $verbal . "\" | text2wave -o audio_captcha.wav");
    header('Content-type: audio/x-wav');
    header("Content-Disposition: attachment;filename=audio_captcha.wav");
    echo file_get_contents("audio_captcha.wav");
    @unlink("audio_captcha.wav");
}
else {
	// Generate a string.
	$char_count = 6;
	
	// $text1 = "L4HB0"; // Here is our text
	$text = "";

	$charpool   = array (2,3,4,7,8,9,'A','B','C','D','E','F','G','H','K','M','N','P','R','T','W','U','Y');
	$poollength = count($charpool) - 1;

	for ($i = 0; $i < $char_count; $i++) {
		$text .= $charpool[mt_rand(0, $poollength)];
	}

	$text = strtoupper($text); // ensure that we are uppercase for audio version
	
	$_SESSION['text'] = $text;
	
	$font_path = "font/FreeSans.ttf";

	
	$text_size = 45;
	
	$width = $text_size * $char_count + 30;
	$height = $text_size + 30;
	$image = imagecreate($width, $height);
	
	$white = imagecolorallocate($image, 255, 255, 255);
	$black = imagecolorallocate($image, 0, 0, 0);
	imagefill($image, 0, 0, $white);
	
	$textcolor = imagecolorallocate($image, 0, 0, 0); // Set text color
	
	$x = 20;
	$y = $text_size + 10;
	$deg_window = 23;
	$color_max = 200;
	$x_deviation_min = -2;
	$x_deviation_max = 2;
	
	for ($i = 0; $i < strlen($text); $i++) {
		$degrees = rand(0, $deg_window * 2) - $deg_window;
		imagettftext($image, $text_size, $degrees, $x + ($i * ($text_size - 3)) + rand($x_deviation_min, $x_deviation_max), $y, $black, $font_path, $text[$i]);
	}

	// Generate 20 random colors and draw random elipses.
	$color_count = 20;
	$color_values = array();
	$spot_count = intval($width * $height * 0.007);
	
	$color_min = 80;
	$color_max = 220;
	
	$spot_r_min = 2;
	$spot_r_max = 7;
	$r_deviation_max = 3;
	
	for ($i = 0; $i < $color_count; $i++) {
		$color_values[$i] = imagecolorallocate($image,
												rand($color_min, $color_max),
												rand($color_min, $color_max),
												rand($color_min, $color_max));
	}
	
	for ($i = 0; $i < $spot_count; $i++) {
		$r = rand($spot_r_min, $spot_r_max);
		$x_deviation = rand(0, $r_deviation_max);
		$y_deviation = rand(0, $r_deviation_max);
		imagefilledellipse($image, rand(0, $width - 1), rand(0, $height - 1),
							$r + $x_deviation,
							$r + $y_deviation,
							$color_values[rand(0, 19)]);
	}
	
	header("Content-type: image/jpeg");
	imagejpeg($image, '', 90);
	imagedestroy($image);
}

$_SESSION['hash'] = md5($text);

?>