<?php

// ---------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// --------------------------------------------------------------------

?>

<div class="am_administration">
	<div id="am_administration_left">
		<div class="box">
			<div class="box_header">
				<h1>Your identity</h1>
			</div>

			<div class="box_body">
				<p>
					<?php echo $lang['txt_identity_intro'];?><br />
				</p>
			</div>
		</div>

		<div class="box">
			<div class="box_header">
				<h1>Your identity profile</h1>
			</div>

			<div class="box_body">
				<p>
					<?php
					if (isset($identity_attributes)) {
					foreach($identity_attributes as $key => $i):
					
					if ($key == 'media/image/aspect11') {
						$identity_profile_avatar = $i;
						break;
					}
					?>
					<span class="profile_title"><?php echo $lang['txt_' . $key];?></span>
					<span class="profile_value"><?php echo $i; ?></span>
					<br />
					<?php
					endforeach;
					
					if (isset($identity_profile_avatar)) {
					?>
						<span class="profile_title"><?php echo $lang['txt_media/image/aspect11'];?></span>
						<span class="profile_value"><img src="<?php echo $identity_profile_avatar; ?>" border="0" /></span>
						<br />
					<?php	
					}
					}
					?>
				</p>

				<p>
					<a href="index.php?t=profile">edit your identity profile</a>
				</p>
			</div>
		</div>
	</div>
	
	<div id="am_administration_right">
		<?php
		if(!defined('AM_WEBSPACE_ID')){
		?>
		<div class="box">
			<div class="box_header">
				<h1>Create your webspace</h1>
			</div>

			<div class="box_body">
				<p>
					A webspace is your personal website in which you can blog, create a wall and present yourself to the world!
				</p>

				<p>
					<a href="index.php?t=create_webspace">Create your webspace</a>
				</p>
			</div>
		</div>
		<?php }?>




		<div class="box">
			<div class="box_header">
				<h1>Connections</h1>
			</div>

			<div class="box_body">
				<p>
					People can connect to your webspace. These are called 'inbound connections' because they connect to you. You can connect to websites. These are called outbound connections as you connect to them. 
				</p>
	
				<ul>
					<li><a href="index.php?t=network">view inbound connections</a></li>
					<li><a href="index.php?t=network&amp;v=outbound">view outbound connections</a></li>
				</ul>
			</div>
		</div>

		
		<div class="box">
			<div class="box_header">
				<h1>Statistics</h1>
			</div>

			<div class="box_body">
				<?php
				if (isset($statistics)) {
				?>
				<table cellspacing="0" cellpadding="2" border="0" width="100%">
				<?php
				foreach ($statistics as $key => $i):
				?>
				<tr>
					<td valign="top">
						<?php echo  $lang['arr_statistics'][$key];?>
					</td>
					<td valign="top">
						<?php echo $i;?>
					</td>
				</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
</div>