<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

	<title><?php echo $lang['txt_html_title'];?></title>

	<style type="text/css">
	<!--
	<?php 
	if (empty($_REQUEST['stylesheet'])) {
	?>
	@import url(<?php echo AM_TEMPLATE_PATH;?>css/aroundme.css);
	<?php
	}
	else {
	?>
	@import url(<?php echo $_REQUEST['stylesheet']; ?>);
	<?php }?>
	-->
	</style>

	<!--[if IE]>
	<style type="text/css">
	@import url(<?php echo AM_TEMPLATE_PATH;?>css/aroundme-IE.css);
	</style>
	<![endif]-->
</head>

<body id="am_admin">

	
	<?php
	if (!empty($GLOBALS['am_error_log'])) {
	?>
	<div id="error_container">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		?>
	</div>
	<?php }?>
	
	<?php
	if (isset($stage) && $stage < 5) {
	?>
	<form method="post">
	<input type="hidden" name="username" value="<?php if (isset($_POST['username'])) echo $_POST['username'];?>" />
	<input type="hidden" name="pass1" value="<?php if (isset($_POST['pass1'])) echo $_POST['pass1']; ?>" />
	
	<table cellspacing="0" cellpadding="0" border="0" width="100%">
		<tr>
			<?php
			if (empty($_REQUEST['remote'])) {
			?>
			<td valign="top" width="50%">
				<div class="box">
					<div class="box_header">
						<h1>Create</h1>
					</div>
							
					<div class="box_body">
						<p>
							Create your identity in 4 simple steps.
						</p>
								
						<ol>
							<?php
							if (isset($stage) && $stage > 1) {
							?>
							<li><del>Agree terms</del></li>
							<?php
							}
							else {
							?>
							<li>Agree terms</li>
							<?php }?>
									
							<?php
							if (isset($stage) && $stage > 2) {
							?>
							<li><del>Username &amp; Openid</del></li>
							<ul>
								<li>username:<b> <?php echo $username; ?></b></li>
								<li>openid:<b> <?php echo $openid; ?></b></li>
							</ul>
							<?php
							}
							else {
							?>
							<li>Username &amp; Openid</li>
							<?php }?>
									
							<?php
							if (isset($stage) && $stage > 3) {
							?>
							<li><del>Choose password</del></li>
							<?php
							}
							else {
							?>
							<li>Choose password</li>
							<?php }?>

							<?php
							if (isset($stage) && $stage > 4) {
							?>
							<li><del>The challange</li>
							<?php
							}
							else {
							?>
							<li>The challange</li>
							<?php }?>
						</ol>
					</div>
				</div>
			</td>
			<td valign="top" width="50%">
			<?php 
			}
			else {
			?>
			<td valign="top" width="100%">
			<?php }?>
				<?php
				if (isset($stage) && $stage == 1) {
				?>
				<div class="box">
					<div class="box_header">
						<h1>1. Agree terms</h1>
					</div>
				
					<div class="box_body">
						<div style="width:100%; height:380px;overflow:auto">
							<?php include('core/language/en/terms_of_use.lang.php');?>
						</div>

						<p align="right">
							<input type="submit" name="reject_terms" value="I disagree" />
							<input type="submit" name="accept_terms" value="I agree" />
						</p>
					</div>
				</div>
						
				<?php
				}
				elseif (isset($stage) && $stage == 2) {
				?>
					
				<div class="box">
					<div class="box_header">
						<h1>2. Choose your name</h1>
					</div>

					<div class="box_body">
				
						<?php 
						if (!isset($name_ok) && !isset($name_in_use)) { 
						?>
						<p>
							You can use any characters (a-z or A-Z) with no spaces. You can also use a dot. Many people prefer firstname.surname as their identity name.<br />
						</p>
								
						<p>
							Find out it the name you want to use if free.
						</p>
							
						<p>
							<label for="id_username">Name</label>
							<input type="text" name="username" id="id_username" value="" /><br />
						</p>
	
						<p align="right">
							<input type="submit" value="Check for availability" name="check_username" class="input_submit" /><br />
						</p>
						<?php }?>
					
						<?php 
						if (isset($name_ok)) { 
						?>
					
						<p>
							<?php echo $lang['txt_username_available']; ?>
							<input type="hidden" name="username" id="id_username" value="<?php if (isset($_POST['username'])) echo $_POST['username']; ?>" /><br />
						</p>

						<p>
							Your OpenID will be <?php echo $proposed_openid = str_replace("REPLACE", $_POST['username'], $core_config['am']['domain_replace_pattern']);?>
						</p>

						<p>
							Would you like to choose it?
						</p>
					
						<p align="right">
							<input type="submit" value="Choose again" name="choose_again" class="input_submit_light" />
							&nbsp;
							<input type="submit" value="Use this name" name="choose_username" class="input_submit" />
						</p>
						<?php }?>
					
						<?php 
						if (isset($name_in_use)) { 
						?>
								
						<p>
							<?php echo $lang['txt_username_taken']; ?>
						</p>
						
						<p>
							<label for="id_username">Name</label>
							<input type="text" name="username" id="id_username" value="" /><br />
						</p>
	
						<p align="right">
							<input type="submit" value="Check for availability" name="check_username" class="input_submit" /><br />
						</p>
						<?php }?>
					
					</div>
				</div>

					<?php
					}
					elseif (isset($stage) && $stage == 3) {
					?>
					<div class="box">
						<div class="box_header">
							<h1>3. Password</h1>
						</div>

						<div class="box_body">
							
							<p>
								Choose password
							</p>
								
							<p>
								<label for="id_pass1">Password</label>
								<input type="password" name="pass1" id="id_pass1" value="" /><br />
							</p>
					
							<p>
								<label for="id_pass2">Confirm Password</label>
								<input type="password" name="pass2" id="id_pass2" value="" /><br />
							</p>
							
							<p>
								<i>Your password must be at least 2 characters long</i>
							</p>
									
							<p align="right">
								<input type="submit" value="Set password" name="register_password" class="input_submit" style="margin:2px;" /><br />
							</p>
									
						</div>
					</div>

					<?php
					}
					elseif (isset($stage) && $stage == 4) {
					?>

					<div class="box">
						<div class="box_header">
							<h1>4. Challange</h1>
						</div>

						<div class="box_body">
							<p>
								Please type the characters exactly as you see them below. 
								You can also use the <a href="core/get_captcha.php?audio=1">Audio version</a>
							</p>

							<img class="captcha" src="core/get_captcha.php" style="border: 1px solid #000;" /><br/>
		
							<p>
								<label for="id_captcha">Response</label>
								<input type="text" name="captcha_text" id="id_captcha" value="" />
							</p>
							
							<p align="right">
								<input type="submit" value="Submit response" name="register_challange" class="input_submit" style="margin:2px;" /><br />
							</p>
						</div>
					</div>

					<?php }?>
			</td>
		</tr>
	</table>
	</form>
	<?php
	}
	elseif (isset($stage) && $stage == 5) {
	?>
			
	<div class="box">
		<div class="box_header">
			<h1>You are done!</h1>
		</div>
		<?php
		if (empty($_REQUEST['remote'])) {
		?>
		<div class="box_body">
			<p>
				Congratulations! You now own this Openid url: <b><a href="<?php echo $openid;?>"><?php echo $openid; ?></a></b>
			</p>

			<h3>Logging in</h3>
			<ol>
				<li>Click the link to visit your OpenID page.</li>
				<li>Press 'Connect' to login.</li>
				<li>Enter your OpenID (<?php echo $openid;?>in the box provided and press 'GO'.</li>
				<li>Enter the password that you gave here.</li>
			</ol>
		</div>
		<?php
		}
		else {
		?>
		<div class="box_body">
		<form method="post" action="<?php echo $_REQUEST['return_to']; ?>">
			<p>
				Your are done! Your OpenID is <b><?php echo $openid;?></b>.
			</p>
			
			<p>
				<label for="openid_login">OpenID</label>	
				<input type="text" id="openid_login" name="openid_login" value="<?php echo $openid;?>" onFocus="this.value=''; return false;" />
			</p>
			
			<p>
				Press "go". You will be taken to your OpenID account and asked to login (use the password that you have just typed in here).
				Then you will be asked what identity information you want to give to this website, then
				you will be logged in.
			</p>
			
			<p align="right">
				<input type="submit" name="connect"  value="go" />
			</p>
		</form>
		</div>
		<?php }?>
	</div>
	<?php }?>
</body>
</html>